/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.items.weapons;

import com.google.common.collect.Multimap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.silvercatcher.reforged.ReforgedMod;
import org.silvercatcher.reforged.api.IZombieEquippable;
import org.silvercatcher.reforged.api.ItemExtension;
import org.silvercatcher.reforged.material.MaterialDefinition;
import org.silvercatcher.reforged.material.MaterialManager;

public class ItemDirk
extends ItemSword
implements ItemExtension,
IZombieEquippable {
    protected final MaterialDefinition materialDefinition;
    protected final boolean unbreakable;

    public ItemDirk(Item.ToolMaterial material) {
        this(material, false);
    }

    public ItemDirk(Item.ToolMaterial material, boolean unbreakable) {
        super(material);
        this.func_77637_a(ReforgedMod.tabReforged);
        this.unbreakable = unbreakable;
        this.materialDefinition = MaterialManager.getMaterialDefinition(material);
        this.func_77655_b(this.materialDefinition.getPrefixedName("dirk"));
        this.func_77656_e(this.materialDefinition.getMaxUses());
        this.func_77625_d(1);
    }

    @Override
    public Multimap getAttributeModifiers(ItemStack stack) {
        return ItemExtension.super.getAttributeModifiers(stack);
    }

    @Override
    public float getHitDamage() {
        return this.materialDefinition.getDamageVsEntity() + 2.0f;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.materialDefinition.getEnchantability();
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker.func_70093_af()) {
            target.func_70097_a(this.getDamage(attacker), 2.0f);
        }
        if (stack.func_77973_b().func_77645_m()) {
            stack.func_77972_a(1, attacker);
        }
        return true;
    }

    public boolean func_77645_m() {
        return !this.unbreakable;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (stack.func_77973_b().func_77645_m() && (double)state.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, entityLiving);
        }
        return true;
    }

    @Override
    public float zombieSpawnChance() {
        switch (this.materialDefinition.getMaterial()) {
            case GOLD: {
                return 1.0f;
            }
            case IRON: {
                return 2.0f;
            }
            case STONE: {
                return 3.0f;
            }
            case WOOD: {
                return 4.0f;
            }
        }
        return 0.0f;
    }
}

