/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.items.weapons;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.silvercatcher.reforged.ReforgedMod;
import org.silvercatcher.reforged.api.ExtendedItem;
import org.silvercatcher.reforged.api.IZombieEquippable;
import org.silvercatcher.reforged.material.MaterialDefinition;
import org.silvercatcher.reforged.material.MaterialManager;
import org.silvercatcher.reforged.props.IStunProperty;

public class ItemMace
extends ExtendedItem
implements IZombieEquippable {
    protected final MaterialDefinition materialDefinition;
    protected final boolean unbreakable;

    public ItemMace(Item.ToolMaterial material) {
        this(material, false);
    }

    public ItemMace(Item.ToolMaterial material, boolean unbreakable) {
        this.unbreakable = unbreakable;
        this.func_77625_d(1);
        this.materialDefinition = MaterialManager.getMaterialDefinition(material);
        this.func_77656_e((int)((float)this.materialDefinition.getMaxUses() * 0.5f));
        this.func_77655_b(this.materialDefinition.getPrefixedName("mace"));
    }

    @Override
    public float getHitDamage() {
        return this.materialDefinition.getDamageVsEntity() + 5.0f;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.materialDefinition.getEnchantability();
    }

    public Item.ToolMaterial getMaterial() {
        return this.materialDefinition.getMaterial();
    }

    public MaterialDefinition getMaterialDefinition() {
        return this.materialDefinition;
    }

    private Potion getPotion(String name) {
        return Potion.func_180142_b((String)name);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        IStunProperty prop;
        if ((float)field_77697_d.nextInt(25) < 8.0f - this.zombieSpawnChance() && (prop = (IStunProperty)target.getCapability(ReforgedMod.STUN_PROP, null)) != null) {
            prop.setStunned(true);
            target.func_70690_d(new PotionEffect(this.getPotion("slowness"), 3, 10, false, false));
            target.func_70690_d(new PotionEffect(this.getPotion("mining_fatigue"), 3, 10, false, false));
            target.func_70690_d(new PotionEffect(this.getPotion("blindness"), 3, 10, false, false));
            target.func_70690_d(new PotionEffect(this.getPotion("weakness"), 3, 10, false, false));
        }
        if (stack.func_77973_b().func_77645_m()) {
            stack.func_77972_a(1, attacker);
        }
        return false;
    }

    public boolean func_77645_m() {
        return !this.unbreakable;
    }

    @Override
    public float zombieSpawnChance() {
        switch (this.materialDefinition.getMaterial()) {
            case GOLD: {
                return 1.0f;
            }
            case IRON: {
                return 2.0f;
            }
            case STONE: {
                return 3.0f;
            }
            case WOOD: {
                return 4.0f;
            }
        }
        return 0.0f;
    }
}

