/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.items.weapons;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.silvercatcher.reforged.api.CompoundTags;
import org.silvercatcher.reforged.api.ExtendedItem;

public class ItemNestOfBees
extends ExtendedItem {
    private static int shot_delay = 4;
    private static int buildup = 25;

    public ItemNestOfBees() {
        this.func_77655_b("nest_of_bees");
        this.func_77656_e(80);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("empty"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                float mrl = 1.0f;
                if (stack.func_77973_b() instanceof ItemNestOfBees && CompoundTags.giveCompound(stack).func_74762_e("ammo") > 0) {
                    mrl = 0.0f;
                }
                return mrl;
            }
        });
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"item.nestofbees.arrows", (Object[])new Object[0]) + ": " + CompoundTags.giveCompound(stack).func_74762_e("ammo"));
    }

    @Override
    public float getHitDamage() {
        return 0.0f;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        NBTTagCompound compound = CompoundTags.giveCompound(stack);
        if (compound.func_74767_n("activated")) {
            return EnumAction.BOW;
        }
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return CompoundTags.giveCompound(stack).func_74767_n("activated") ? 72000 : buildup;
    }

    @Override
    public boolean isWeapon() {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            playerIn.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184614_ca());
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184592_cb());
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase playerIn) {
        NBTTagCompound compound = CompoundTags.giveCompound(stack);
        if (compound.func_74762_e("ammo") > 0) {
            compound.func_74757_a("activated", true);
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187616_bj, SoundCategory.MASTER, 1.0f, 1.0f);
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityPlayer && isSelected) {
            EntityPlayer player = (EntityPlayer)entityIn;
            NBTTagCompound compound = CompoundTags.giveCompound(stack);
            int delay = compound.func_74762_e("delay");
            if (delay == 0) {
                int arrows = compound.func_74762_e("ammo");
                if (arrows == 0) {
                    compound.func_74757_a("activated", false);
                }
                if (compound.func_74767_n("activated")) {
                    this.shoot(worldIn, player);
                    if (stack.func_77973_b().func_77645_m()) {
                        stack.func_77972_a(1, (EntityLivingBase)player);
                    }
                    --arrows;
                }
                compound.func_74768_a("ammo", arrows);
                compound.func_74768_a("delay", shot_delay);
            } else if (compound.func_74767_n("activated")) {
                compound.func_74768_a("delay", Math.max(0, delay - 1));
            }
        }
    }

    protected void shoot(World world, EntityPlayer shooter) {
        if (!world.field_72995_K) {
            EntityArrow arrow = new ItemArrow().func_185052_a(world, new ItemStack(Items.field_151032_g), (EntityLivingBase)shooter);
            arrow.func_184547_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, ItemBow.func_185059_b((int)40) * 3.0f, 1.0f);
            arrow.func_70239_b(2.0);
            arrow.func_70186_c(arrow.field_70159_w, arrow.field_70181_x, arrow.field_70179_y, 3.0f + field_77697_d.nextFloat() / 2.0f, 1.5f);
            world.func_72838_d((Entity)arrow);
        }
        world.func_184148_a(null, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, SoundEvents.field_187631_bo, SoundCategory.MASTER, 3.0f, 1.0f);
    }
}

