/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.manager;

import codechicken.lib.util.CommonUtils;
import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.api.FreqCoord;
import codechicken.wirelessredstone.api.WirelessTransmittingDevice;
import codechicken.wirelessredstone.device.Remote;
import codechicken.wirelessredstone.device.Sniffer;
import codechicken.wirelessredstone.entity.EntityREP;
import codechicken.wirelessredstone.entity.EntityWirelessTracker;
import codechicken.wirelessredstone.init.ModItems;
import codechicken.wirelessredstone.item.ItemWirelessMap;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.manager.RedstoneEtherAddons;
import codechicken.wirelessredstone.network.WRServerPH;
import codechicken.wirelessredstone.util.WirelessMapNodeStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;

public class RedstoneEtherServerAddons
extends RedstoneEtherAddons {
    private HashMap<String, RedstoneEtherAddons.AddonPlayerInfo> playerInfos = new HashMap();
    private HashMap<EntityWirelessTracker, HashSet<EntityPlayerMP>> trackerPlayerMap = new HashMap();
    private HashSet<EntityWirelessTracker> playerTrackers = new HashSet();
    int trackerTicks = 0;

    public void setTriangRequired(EntityPlayer player, int freq, boolean required) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (required) {
            info.triangSet.add(freq);
        } else {
            info.triangSet.remove(freq);
        }
    }

    private RedstoneEtherAddons.AddonPlayerInfo getPlayerInfo(EntityPlayer player) {
        return this.playerInfos.get(player.func_70005_c_());
    }

    @Override
    public boolean isRemoteOn(EntityPlayer player, int freq) {
        Remote currentremote = this.getPlayerInfo((EntityPlayer)player).remote;
        return currentremote != null && currentremote.getFreq() == freq;
    }

    public int getRemoteFreq(EntityPlayer player) {
        Remote currentremote = this.getPlayerInfo((EntityPlayer)player).remote;
        if (currentremote == null) {
            return 0;
        }
        return currentremote.getFreq();
    }

    @Override
    public void activateRemote(World world, EntityPlayer player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.remote != null) {
            if (info.remote.isBeingHeld()) {
                return;
            }
            this.deactivateRemote(world, player);
        }
        if (RedstoneEther.server().isPlayerJammed(player)) {
            return;
        }
        info.remote = new Remote(player);
        info.remote.metaOn();
        RedstoneEther.server().addTransmittingDevice(info.remote);
    }

    @Override
    public boolean deactivateRemote(World world, EntityPlayer player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.remote == null) {
            return false;
        }
        info.remote.metaOff();
        RedstoneEther.server().removeTransmittingDevice(info.remote);
        info.remote = null;
        return true;
    }

    public void addSniffer(EntityPlayer player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.sniffer != null) {
            this.remSniffer(player);
        }
        info.sniffer = new Sniffer(player);
        RedstoneEther.server().addReceivingDevice(info.sniffer);
        byte[] ethercopy = new byte[625];
        for (int freq = 1; freq <= 5000; ++freq) {
            int arrayindex = freq - 1 >> 3;
            int bit = freq - 1 & 7;
            if (!RedstoneEther.server().isFreqOn(freq)) continue;
            int n = arrayindex;
            ethercopy[n] = (byte)(ethercopy[n] | 1 << bit);
        }
        WRServerPH.sendEtherCopyTo(player, ethercopy);
    }

    public void remSniffer(EntityPlayer player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.sniffer == null) {
            return;
        }
        RedstoneEther.server().removeReceivingDevice(info.sniffer);
        info.sniffer = null;
    }

    public void processSMPMaps(World world) {
        RedstoneEther.loadServerWorld(world);
        int dimension = CommonUtils.getDimension((World)world);
        ArrayList players = ServerUtils.getPlayersInDimension((int)dimension);
        Map<BlockPos, RedstoneEther.TXNodeInfo> txnodes = RedstoneEther.server().getTransmittersInDimension(dimension);
        Set<WirelessTransmittingDevice> devices = RedstoneEther.server().getTransmittingDevicesInDimension(dimension);
        for (EntityPlayer player : players) {
            ItemStack helditem = player.func_184614_ca();
            if (helditem == null || helditem.func_77973_b() != ModItems.itemWirelessMap || RedstoneEther.server().isPlayerJammed(player)) continue;
            ItemWirelessMap map = (ItemWirelessMap)helditem.func_77973_b();
            MapData mapdata = map.func_77873_a(helditem, world);
            if (mapdata.field_76200_c != player.field_71093_bK) continue;
            WirelessMapNodeStorage mapnodes = this.getMapNodes(player);
            TreeSet<FreqCoord> oldnodes = mapnodes.nodes;
            int lastdevices = mapnodes.devices.size();
            this.updatePlayerMapData(player, world, mapdata, txnodes, devices);
            TreeSet<FreqCoord> addednodes = new TreeSet<FreqCoord>((SortedSet<FreqCoord>)mapnodes.nodes);
            TreeSet<FreqCoord> removednodes = new TreeSet<FreqCoord>();
            if (oldnodes.size() != 0) {
                for (FreqCoord node : oldnodes) {
                    if (addednodes.remove(node)) continue;
                    removednodes.add(node);
                }
            }
            if (addednodes.size() == 0 && removednodes.size() == 0 && devices.size() == 0 && lastdevices <= 0) continue;
            WRServerPH.sendMapUpdatePacketTo(player, helditem.func_77952_i(), mapdata, addednodes, removednodes, mapnodes.devices);
        }
    }

    private void updatePlayerMapData(EntityPlayer player, World world, MapData mapdata, Map<BlockPos, RedstoneEther.TXNodeInfo> txnodes, Set<WirelessTransmittingDevice> devices) {
        TreeSet<FreqCoord> mnodes = new TreeSet<FreqCoord>();
        TreeSet<FreqCoord> mdevices = new TreeSet<FreqCoord>();
        int blockwidth = 1 << mapdata.field_76197_d;
        int minx = mapdata.field_76201_a - blockwidth * 64;
        int minz = mapdata.field_76199_b - blockwidth * 64;
        int maxx = mapdata.field_76201_a + blockwidth * 64;
        int maxz = mapdata.field_76199_b + blockwidth * 64;
        for (Map.Entry<BlockPos, RedstoneEther.TXNodeInfo> entry : txnodes.entrySet()) {
            BlockPos node = entry.getKey();
            RedstoneEther.TXNodeInfo info = entry.getValue();
            if (!info.on || node.func_177958_n() <= minx || node.func_177958_n() >= maxx || node.func_177952_p() <= minz || node.func_177952_p() >= maxz || !RedstoneEther.server().canBroadcastOnFrequency(player, info.freq)) continue;
            mnodes.add(new FreqCoord(node.func_177958_n() - mapdata.field_76201_a, node.func_177956_o(), node.func_177952_p() - mapdata.field_76199_b, info.freq));
        }
        for (WirelessTransmittingDevice device : devices) {
            Vector3 pos = device.getTransmitPos();
            if (!(pos.x > (double)minx) || !(pos.x < (double)maxx) || !(pos.z > (double)minz) || !(pos.z < (double)maxz) || !RedstoneEther.server().canBroadcastOnFrequency(player, device.getFreq())) continue;
            mdevices.add(new FreqCoord((int)pos.x, (int)pos.y, (int)pos.z, device.getFreq()));
        }
        WirelessMapNodeStorage mapnodes = this.getMapNodes(player);
        mapnodes.nodes = mnodes;
        mapnodes.devices = mdevices;
    }

    public void onLogin(EntityPlayer player) {
        this.playerInfos.put(player.func_70005_c_(), new RedstoneEtherAddons.AddonPlayerInfo());
    }

    public void onLogout(EntityPlayer player) {
        this.playerInfos.remove(player.func_70005_c_());
    }

    public void onDimensionChange(EntityPlayer player) {
        if (this.getPlayerInfo(player) != null) {
            this.deactivateRemote(player.field_70170_p, player);
            this.remSniffer(player);
        }
        this.playerInfos.put(player.func_70005_c_(), new RedstoneEtherAddons.AddonPlayerInfo());
        Iterator<EntityWirelessTracker> iterator = this.playerTrackers.iterator();
        while (iterator.hasNext()) {
            EntityWirelessTracker tracker = iterator.next();
            if (!tracker.attachedPlayerName.equals(player.func_70005_c_())) continue;
            tracker.copyToDimension(player.field_71093_bK);
            iterator.remove();
        }
    }

    public WirelessMapNodeStorage getMapNodes(EntityPlayer player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        return info.mapNodes;
    }

    public void updateSMPMapInfo(World world, EntityPlayer player, MapData mapdata, int mapno) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (!info.mapInfoSet.contains(mapno)) {
            WRServerPH.sendMapInfoTo(player, mapno, mapdata);
            info.mapInfoSet.add(mapno);
        }
    }

    public void clearMapNodes(EntityPlayer player) {
        this.getPlayerInfo((EntityPlayer)player).mapNodes.clear();
    }

    public void tickTriangs() {
        for (Map.Entry<String, RedstoneEtherAddons.AddonPlayerInfo> entry : this.playerInfos.entrySet()) {
            EntityPlayerMP player = ServerUtils.getPlayer((String)entry.getKey());
            for (Integer freq : entry.getValue().triangSet) {
                Vector3 strengthvec;
                double spinto = !RedstoneEther.server().isFreqOn(freq) ? -1.0 : (this.isRemoteOn((EntityPlayer)player, freq) ? -2.0 : ((strengthvec = this.getBroadcastVector((EntityPlayer)player, freq)) == null ? -2.0 : (double)(player.field_70177_z + 180.0f) * 0.017453292519943 - Math.atan2(-strengthvec.x, strengthvec.z)));
                WRServerPH.sendTriangAngleTo((EntityPlayer)player, freq, (float)spinto);
            }
        }
    }

    public Vector3 getBroadcastVector(EntityPlayer player, int freq) {
        double distancePow2;
        Vector3 vecTransmitter;
        Vector3 vecAmplitude = new Vector3(0.0, 0.0, 0.0);
        Vector3 vecPlayer = new Vector3(player.field_70165_t, 0.0, player.field_70161_v);
        for (FreqCoord node : RedstoneEther.server().getActiveTransmittersOnFreq(freq, player.field_71093_bK)) {
            vecTransmitter = new Vector3((double)node.x + 0.5, 0.0, (double)node.z + 0.5);
            distancePow2 = vecTransmitter.subtract(vecPlayer).magSquared();
            vecAmplitude.add(vecTransmitter.multiply(1.0 / distancePow2));
        }
        for (WirelessTransmittingDevice device : RedstoneEther.server().getTransmittingDevicesOnFreq(freq)) {
            if (device.getAttachedEntity() == player) {
                return null;
            }
            if (device.getDimension() != player.field_71093_bK) continue;
            vecTransmitter = device.getTransmitPos();
            vecTransmitter.y = 0.0;
            distancePow2 = vecTransmitter.subtract(vecPlayer).magSquared();
            vecAmplitude.add(vecTransmitter.multiply(1.0 / distancePow2));
        }
        if (vecAmplitude.isZero()) {
            return null;
        }
        return vecAmplitude;
    }

    public void addTracker(EntityWirelessTracker tracker) {
        this.trackerPlayerMap.put(tracker, new HashSet());
        if (tracker.attachedPlayerName != null) {
            this.playerTrackers.add(tracker);
        }
    }

    public void removeTracker(EntityWirelessTracker tracker) {
        HashSet<EntityPlayerMP> trackedPlayers = this.trackerPlayerMap.get(tracker);
        if (trackedPlayers != null) {
            for (EntityPlayerMP player : trackedPlayers) {
                WRServerPH.sendRemoveTrackerTo(player, tracker);
            }
        }
        this.trackerPlayerMap.remove(tracker);
        if (!tracker.attachedInOtherDimension()) {
            this.playerTrackers.remove(tracker);
        }
    }

    public void updateTracker(EntityWirelessTracker tracker) {
        HashSet<Object> trackedPlayers = this.trackerPlayerMap.get(tracker);
        if (trackedPlayers == null) {
            trackedPlayers = new HashSet();
            this.trackerPlayerMap.put(tracker, trackedPlayers);
        }
        for (EntityPlayerMP player : trackedPlayers) {
            WRServerPH.sendTrackerUpdatePacketTo(player, tracker);
        }
        if (tracker.attachedPlayerName != null) {
            this.playerTrackers.add(tracker);
        } else {
            this.playerTrackers.remove(tracker);
        }
    }

    public void processTrackers() {
        ++this.trackerTicks;
        HashSet playerEntities = new HashSet(ServerUtils.getPlayers());
        boolean updateFree = this.trackerTicks % 5 == 0;
        boolean updateAttached = this.trackerTicks % 100 == 0;
        Iterator<Map.Entry<EntityWirelessTracker, HashSet<EntityPlayerMP>>> iterator = this.trackerPlayerMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EntityWirelessTracker, HashSet<EntityPlayerMP>> entry = iterator.next();
            HashSet<EntityPlayerMP> trackedPlayers = entry.getValue();
            HashSet<EntityPlayerMP> playersToTrack = new HashSet<EntityPlayerMP>();
            EntityWirelessTracker tracker = entry.getKey();
            ChunkPos chunk = new ChunkPos(tracker.field_70176_ah, tracker.field_70164_aj);
            for (EntityPlayer entityPlayer : playerEntities) {
                EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
                if (tracker.field_70128_L) {
                    WRServerPH.sendRemoveTrackerTo(player, tracker);
                    continue;
                }
                if (tracker.getDimension() == player.field_71093_bK && !ServerUtils.isPlayerLoadingChunk((EntityPlayerMP)player, (ChunkPos)chunk) && !tracker.attachedToLogout()) {
                    playersToTrack.add(player);
                    if (trackedPlayers.contains(player) && (!tracker.isAttachedToEntity() || !updateAttached) && (tracker.isAttachedToEntity() || !updateFree)) continue;
                    WRServerPH.sendTrackerUpdatePacketTo(player, tracker);
                    continue;
                }
                if (!trackedPlayers.contains(player)) continue;
                WRServerPH.sendRemoveTrackerTo(player, tracker);
            }
            if (tracker.field_70128_L) {
                iterator.remove();
                continue;
            }
            trackedPlayers.clear();
            trackedPlayers.addAll(playersToTrack);
        }
    }

    public boolean detonateREP(EntityPlayer player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.activeREP == null) {
            return false;
        }
        if (info.activeREP.field_70128_L) {
            info.activeREP = null;
            return false;
        }
        info.activeREP.detonate();
        info.activeREP.func_70106_y();
        return true;
    }

    @Override
    public void invalidateREP(EntityPlayer player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info != null) {
            info.activeREP = null;
        }
    }

    public void updateREPTimeouts() {
        for (Map.Entry<String, RedstoneEtherAddons.AddonPlayerInfo> entry : this.playerInfos.entrySet()) {
            RedstoneEtherAddons.AddonPlayerInfo info = entry.getValue();
            if (info.REPThrowTimeout <= 0) continue;
            --info.REPThrowTimeout;
        }
    }

    public void throwREP(ItemStack itemstack, World world, EntityPlayer player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.REPThrowTimeout > 0) {
            return;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        EntityREP activeREP = new EntityREP(world, (EntityLivingBase)player);
        world.func_72838_d((Entity)activeREP);
        WRServerPH.sendSpawnREP(activeREP);
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
        info.activeREP = activeREP;
        info.REPThrowTimeout = 40;
    }
}

