/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.handler;

import de.eydamos.backpack.Backpack;
import de.eydamos.backpack.data.PlayerSave;
import de.eydamos.backpack.init.Configurations;
import de.eydamos.backpack.item.ItemBackpack;
import de.eydamos.backpack.misc.Constants;
import java.io.File;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class HandlerCommonEvents {
    @SubscribeEvent
    public void serverTick(TickEvent.PlayerTickEvent event) {
        if (Configurations.MAX_BACKPACK_AMOUNT > 0 && event.side == Side.SERVER) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            int counter = 0;
            if (!PlayerSave.loadPlayer(player.field_70170_p, (EntityPlayer)player).getBackpack().func_190926_b()) {
                ++counter;
            }
            NonNullList inventory = player.field_71071_by.field_70462_a;
            for (ItemStack itemStack : inventory) {
                if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof ItemBackpack) || ++counter <= Configurations.MAX_BACKPACK_AMOUNT) continue;
                EntityItem item = player.func_70099_a(itemStack.func_77946_l(), 0.0f);
                if (item != null) {
                    item.func_174867_a(40);
                }
                itemStack.func_190918_g(1);
            }
            if ((counter -= Configurations.MAX_BACKPACK_AMOUNT) > 0) {
                TextComponentString message = new TextComponentString("[Backpacks] ");
                message.func_150257_a((ITextComponent)new TextComponentTranslation("text.backpack_allowed_backpacks", new Object[]{Configurations.MAX_BACKPACK_AMOUNT}));
                player.func_145747_a((ITextComponent)message);
                message = new TextComponentString("[Backpacks] ").func_150257_a((ITextComponent)new TextComponentTranslation("text.backpack_dropped_backpacks", new Object[]{counter}));
                player.func_145747_a((ITextComponent)message);
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        try {
            File playersDir;
            File dataDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "data");
            File backpackDir = new File(dataDir, Constants.INVENTORIES_PATH);
            if (!backpackDir.exists() && !backpackDir.mkdirs()) {
                Backpack.logger.warn("Unable to create backpack/inventory folder. Saving backpack inventory will fail!");
            }
            if (!(playersDir = new File(dataDir, Constants.PLAYERS_PATH)).exists() && !playersDir.mkdirs()) {
                Backpack.logger.warn("Unable to create backpack/player folder. Saving player specific backpack data will fail!");
            }
        }
        catch (Exception e) {
            Backpack.logger.info("Unable to check if backpack folders are present. If you are a client connecting to a server ignore this info.");
        }
    }

    @SubscribeEvent
    public void playerDies(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        PlayerSave playerSave = PlayerSave.loadPlayer(player.field_70170_p, player);
        ItemStack backpack = playerSave.getBackpack();
        if (!backpack.func_190926_b()) {
            event.getDrops().add(new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, backpack));
            playerSave.func_70299_a(0, ItemStack.field_190927_a);
        }
    }
}

