/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class NVLCommonFunctions {
    public static final int BOTTOM = 0;
    public static final int TOP = 1;
    public static final int NORTH = 2;
    public static final int SOUTH = 3;
    public static final int WEST = 4;
    public static final int EAST = 5;
    public static final String[] directions = new String[]{"DOWN", "UP", "NORTH", "SOUTH", "WEST", "EAST"};
    public static final String[] TEXTFORMATCOLORS = new String[]{"\u00a70", "\u00a71", "\u00a72", "\u00a73", "\u00a74", "\u00a75", "\u00a76", "\u00a77", "\u00a78", "\u00a79", "\u00a7a", "\u00a7b", "\u00a7c", "\u00a7d", "\u00a7e", "\u00a7f"};
    public static final String[] TEXTFORMATCOLORSFROMMETA = new String[]{"\u00a78", "\u00a74", "\u00a72", "\u00a76", "\u00a71", "\u00a75", "\u00a7b", "\u00a77", "\u00a78", "\u00a7d", "\u00a7a", "\u00a7e", "\u00a7b", "\u00a75", "\u00a76", "\u00a7f"};
    public static final int TXTBLACK = 0;
    public static final int TXTDARK_BLUE = 1;
    public static final int TXTDARK_GREEN = 2;
    public static final int TXTDARK_AQUA = 3;
    public static final int TXTDARK_RED = 4;
    public static final int TXTPURPLE = 5;
    public static final int TXTORANGE = 6;
    public static final int TXTGRAY = 7;
    public static final int TXTDARK_GRAY = 8;
    public static final int TXTINDIGO = 9;
    public static final int TXTBRIGHT_GREEN = 10;
    public static final int TXTAQUA = 11;
    public static final int TXTRED = 12;
    public static final int TXTPINK = 13;
    public static final int TXTYELLOW = 14;
    public static final int TXTWHITE = 15;
    public static final String[] TEXTCOLORS = new String[]{"Black", "Dark Blue", "Dark Green", "Dark Aqua", "Dark Red", "Purple", "Orange (Gold)", "Gray", "Dark Gray", "Indigo (blue)", "Bright Green", "Aqua", "Red", "Pink", "Yellow", "White"};
    private File gfh;
    private File cfh;
    private File sfh = null;
    private String MODName = "";
    private Boolean EnableLogging = true;

    public NVLCommonFunctions(String Owner) {
        this.MODName = Owner;
        if (this.EnableLogging.booleanValue()) {
            this.gfh = this.prepareLogFile("Logs");
            this.cfh = this.prepareLogFile("ClientLogs");
            this.sfh = this.prepareLogFile("ServerLogs");
        }
    }

    public String getModID() {
        return this.MODName;
    }

    public void logLine(String module, String message) {
        if (this.EnableLogging.booleanValue()) {
            String part = "C";
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                part = "S";
            }
            if (this.gfh != null) {
                this.feedIntoLog(this.gfh, "[" + this.MODName + "] " + part + " [" + module + "] " + message);
            } else {
                System.out.println(part + "[" + module + "] " + message);
            }
            if (this.sfh != null && part == "S") {
                this.feedIntoLog(this.sfh, "[" + this.MODName + "][" + module + "] " + message);
            }
            if (this.cfh != null && part == "C") {
                this.feedIntoLog(this.cfh, "[" + this.MODName + "][" + module + "] " + message);
            }
        }
    }

    private void feedIntoLog(File lfh, String Message) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(lfh, true));
            out.println(Message);
            out.close();
        }
        catch (IOException e) {
            System.out.println("NVLCommon:IOException:" + e);
        }
    }

    private File prepareLogFile(String Name) {
        File fh = null;
        File fld = new File("logs/NVL");
        if (!fld.exists()) {
            System.out.println("NVLCommon: MKDir result: " + fld.mkdir());
        }
        if (!(fh = new File("logs/NVL/" + Name + ".txt")).exists()) {
            try {
                System.out.println("NVLCommon:CreateFile result: " + fh.createNewFile());
            }
            catch (IOException e) {
                System.out.println("NVLCommon:CreateFile exception: " + e.toString());
            }
        }
        return fh;
    }

    public static void addChatMessage(ICommandSender sender, String message) {
        String[] lines;
        for (String line : lines = message.replace("\\n", "\n").split("\n")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(line));
        }
    }

    public static void addChatMessageClient(ICommandSender sender, String message) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            NVLCommonFunctions.addChatMessage(sender, message);
        }
    }

    public static boolean isServerDedicated() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S();
    }

    public static String getDyeColorName(int index) {
        String[] Colors = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "silver", "gray", "pink", "lime", "yellow", "light blue", "magenta", "orange", "white"};
        String r = "";
        if (index >= 0 && index < 16) {
            r = Colors[index];
        }
        return r;
    }

    public static boolean isIC2Present() {
        return NVLCommonFunctions.isMODPresent("IC2");
    }

    public static boolean isMODPresent(String MODName) {
        return Loader.isModLoaded((String)MODName);
    }

    public static String createNVLFolder() {
        String r = "";
        r = FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I() + "/NVL";
        File fld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71209_f(r);
        if (!fld.exists()) {
            fld.mkdir();
        }
        return r;
    }

    public void ExtractRecipes() {
        ArrayList recipes = (ArrayList)ForgeRegistries.RECIPES.getValues();
        if (recipes != null) {
            this.logLine("NVLCommon", "ExtractRecipes: Recipes size: " + recipes.size());
            for (int scan = 0; scan < recipes.size(); ++scan) {
                IRecipe tmpRecipe = (IRecipe)recipes.get(scan);
                if (tmpRecipe == null) continue;
                ItemStack ro = tmpRecipe.func_77571_b();
                try {
                    if (ro != null) {
                        boolean sr = tmpRecipe instanceof ShapedRecipes;
                        boolean lr = tmpRecipe instanceof ShapelessRecipes;
                        boolean sor = tmpRecipe instanceof ShapedOreRecipe;
                        boolean lor = tmpRecipe instanceof ShapelessOreRecipe;
                        this.logLine("NVLCommon", "ExtractRecipes [" + scan + "]:" + tmpRecipe + ":" + ro.func_77977_a() + ":[" + sr + "," + lr + "," + sor + "," + lor + "]");
                        continue;
                    }
                    this.logLine("NVLCommon", "ExtractRecipes [" + scan + "]:" + tmpRecipe + ":NULL");
                    continue;
                }
                catch (Exception e) {
                    this.logLine("NVLCommon", "ExtractRecipes Exception: " + e.getMessage());
                }
            }
        }
    }

    public static boolean CompareItemStacks(ItemStack One, ItemStack Two) {
        boolean r = false;
        if (One == null && Two == null) {
            r = true;
        } else if (One != null && Two != null && One.func_77973_b() != null && Two.func_77973_b() != null) {
            r = One.func_77977_a().equals(Two.func_77977_a());
        }
        return r;
    }

    public static ArrayList<String> loadTextFile(String fileName) throws IOException {
        ArrayList<String> r = new ArrayList<String>();
        InputStream st = NVLCommonFunctions.class.getResourceAsStream(fileName);
        if (st != null) {
            InputStreamReader isReader = null;
            isReader = new InputStreamReader(st, "UTF-8");
            if (isReader != null) {
                String line;
                LineNumberReader reader = new LineNumberReader(isReader);
                while ((line = reader.readLine()) != null) {
                    r.add(line);
                }
            }
            st.close();
        }
        return r;
    }
}

