/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.common;

import hu.nvl.nvlforcefields.common.NVLCommonFunctions;
import hu.nvl.nvlforcefields.entities.NVLEntityFieldControllerSecure;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class NVLPacketHandler {
    private static NVLCommonFunctions logger;
    private static final int PTFFCS = 0;

    public NVLPacketHandler(NVLCommonFunctions common) {
        logger = common;
    }

    private static void logLine(String msg) {
        logger.logLine("NVLPacketHandler", msg);
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) throws IOException {
        String channelName = event.getPacket().channel();
        if (channelName.equals("NVLFF1710155810")) {
            NetHandlerPlayServer theNetHandlerPlayServer = (NetHandlerPlayServer)event.getHandler();
            EntityPlayerMP thePlayer = theNetHandlerPlayServer.field_147369_b;
            WorldServer w = thePlayer.func_184102_h().func_71218_a(thePlayer.field_71093_bK);
            ByteBuf buf = event.getPacket().payload();
            if (w != null) {
                try {
                    ByteBufInputStream bbis = new ByteBufInputStream(buf);
                    int PacketType = bbis.readInt();
                    if (PacketType == 0) {
                        NVLPacketHandler.processFFCSPacket((World)w, bbis, thePlayer);
                    }
                    bbis.close();
                }
                catch (IOException e) {
                    NVLPacketHandler.logLine("onServerPacket: Exception: " + e.toString());
                }
            }
        }
    }

    public static void processFFCSPacket(World w, ByteBufInputStream bbis, EntityPlayerMP player) {
        try {
            int x = bbis.readInt();
            int y = bbis.readInt();
            int z = bbis.readInt();
            BlockPos Coords = new BlockPos(x, y, z);
            String newOwner = bbis.readUTF();
            String newMember = bbis.readUTF();
            Boolean newPublic = bbis.readBoolean();
            TileEntity te = w.func_175625_s(Coords);
            if (te != null && te instanceof NVLEntityFieldControllerSecure) {
                if (!newOwner.isEmpty()) {
                    ((NVLEntityFieldControllerSecure)te).setOwner(newOwner);
                }
                ((NVLEntityFieldControllerSecure)te).setPublic(newPublic);
                if (!newMember.isEmpty()) {
                    ((NVLEntityFieldControllerSecure)te).setMember(newMember);
                }
            } else {
                NVLPacketHandler.logLine("processFFCSPacket: Wrong TileEntity at " + Coords.toString() + ":" + te);
            }
        }
        catch (IOException e) {
            NVLPacketHandler.logLine("processFFCSPacket: Exception: " + e.toString());
        }
    }

    public static FMLProxyPacket createFFCSPacket(BlockPos selfCoords, String newOwner, String newMember, Boolean newPublic) {
        ByteBufOutputStream bbos = new ByteBufOutputStream(Unpooled.buffer());
        FMLProxyPacket thePacket = null;
        try {
            bbos.writeInt(0);
            bbos.writeInt(selfCoords.func_177958_n());
            bbos.writeInt(selfCoords.func_177956_o());
            bbos.writeInt(selfCoords.func_177952_p());
            bbos.writeUTF(newOwner);
            bbos.writeUTF(newMember);
            bbos.writeBoolean(newPublic.booleanValue());
            PacketBuffer buf = new PacketBuffer(bbos.buffer());
            thePacket = new FMLProxyPacket(buf, "NVLFF1710155810");
            bbos.close();
        }
        catch (IOException e) {
            NVLPacketHandler.logLine("createFFCSPacket Exception: " + e.toString());
        }
        return thePacket;
    }
}

