/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.common;

import hu.nvl.nvlforcefields.common.NVLTileEntity;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class NVLTileEntityInventory
extends NVLTileEntity
implements IInventory {
    protected ArrayList<Integer> dropList = new ArrayList();
    protected ItemStack[] Inv;

    public void func_145839_a(NBTTagCompound tag) {
        this.func_174888_l();
        NBTTagList items = tag.func_150295_c("Inventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound temp = items.func_150305_b(i);
            int slot = temp.func_74762_e("Slot");
            if (slot < 0 || slot >= this.Inv.length) continue;
            this.Inv[slot] = new ItemStack(temp);
            if (this.Inv[slot] != null) continue;
            this.Inv[slot] = ItemStack.field_190927_a;
        }
        super.func_145839_a(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.Inv.length; ++i) {
            ItemStack stack = this.Inv[i];
            if (stack == null || stack.func_190926_b()) continue;
            NBTTagCompound temp = new NBTTagCompound();
            temp.func_74768_a("Slot", i);
            stack.func_77955_b(temp);
            itemList.func_74742_a((NBTBase)temp);
        }
        tag.func_74782_a("Inventory", (NBTBase)itemList);
        tag = super.func_189515_b(tag);
        return tag;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack r = ItemStack.field_190927_a;
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null && !stack.func_190926_b()) {
            if (stack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
                r = stack;
            } else {
                r = stack.func_77979_a(amount);
                if (stack.func_190916_E() == 0) {
                    this.func_70299_a(slot, ItemStack.field_190927_a);
                }
            }
        }
        return r;
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.Inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < this.Inv.length) {
            return this.Inv[slot];
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_94041_b(int slot, ItemStack arg1) {
        return false;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.Inv[slot] = stack;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.Inv.length; ++i) {
            this.Inv[i] = ItemStack.field_190927_a;
        }
    }

    public void func_174886_c(EntityPlayer arg0) {
    }

    public int func_174887_a_(int arg0) {
        return this.Inv[0].func_190916_E();
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174889_b(EntityPlayer arg0) {
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack r = this.Inv[slot];
        this.Inv[slot] = ItemStack.field_190927_a;
        return r;
    }

    public void func_174885_b(int slot, int amount) {
        if (this.Inv[slot] != null && !this.Inv[slot].func_190926_b()) {
            this.Inv[slot].func_190920_e(amount);
        }
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer arg0) {
        return false;
    }

    public int getInventorySizeForContainer() {
        return this.Inv.length;
    }

    protected void addStackToSlots(ItemStack stack, int Start, int End) {
        if (stack != null && !stack.func_190926_b()) {
            for (int i = Start; i <= End && stack.func_190916_E() > 0; ++i) {
                if (this.Inv[i] == null || this.Inv[i].func_190926_b()) {
                    this.Inv[i] = stack.func_77946_l();
                    stack.func_190920_e(0);
                    continue;
                }
                if (!this.CompareStacks(this.Inv[i], stack) || this.Inv[i].func_190916_E() >= stack.func_77976_d()) continue;
                int t = this.Inv[i].func_77976_d() - this.Inv[i].func_190916_E();
                if (stack.func_190916_E() < t) {
                    t = stack.func_190916_E();
                }
                this.Inv[i].func_190920_e(this.Inv[i].func_190916_E() + t);
                stack.func_190920_e(stack.func_190916_E() - t);
            }
        }
    }

    protected int mergeStacks(ItemStack stack, int amount, int from, int to, boolean reverse) {
        if ((amount = this.addStackToExisting(stack, amount, from, to, reverse)) > 0) {
            amount = this.placeToEmpty(stack, amount, from, to, reverse);
        }
        return amount;
    }

    protected int placeToEmpty(ItemStack stack, int amount, int from, int to, boolean reverse) {
        if (reverse) {
            for (int i = to; i >= from && amount > 0; --i) {
                amount = this.placeStackToEmptySlot(i, stack, amount);
            }
        } else {
            for (int i = from; i <= to && amount > 0; ++i) {
                amount = this.placeStackToEmptySlot(i, stack, amount);
            }
        }
        return amount;
    }

    private int placeStackToEmptySlot(int slot, ItemStack stack, int amount) {
        if (this.Inv[slot] == null || this.Inv[slot].func_190926_b()) {
            int draw = stack.func_77976_d();
            if (amount < draw) {
                draw = amount;
            }
            this.Inv[slot] = stack.func_77946_l();
            this.Inv[slot].func_190920_e(draw);
            amount -= draw;
        }
        return amount;
    }

    protected int addStackToExisting(ItemStack stack, int amount, int from, int to, boolean reverse) {
        if (reverse) {
            for (int i = to; i >= from && amount > 0; --i) {
                amount = this.addToSlot(i, stack, amount);
            }
        } else {
            for (int i = from; i <= to && amount > 0; ++i) {
                amount = this.addToSlot(i, stack, amount);
            }
        }
        return amount;
    }

    private int addToSlot(int slot, ItemStack stack, int amount) {
        if (this.Inv[slot] != null && !this.Inv[slot].func_190926_b() && this.CompareStacks(stack, this.Inv[slot]) && this.Inv[slot].func_190916_E() < this.Inv[slot].func_77976_d()) {
            int draw = this.Inv[slot].func_77976_d() - this.Inv[slot].func_190916_E();
            if (draw > amount) {
                draw = amount;
            }
            this.Inv[slot].func_190920_e(this.Inv[slot].func_190916_E() + draw);
            amount -= draw;
        }
        return amount;
    }

    public boolean areSlotsFree(int start, int end) {
        boolean r = true;
        if (start >= 0 && end < this.Inv.length) {
            for (int i = start; i <= end && r; ++i) {
                r = this.Inv[i] == null || this.Inv[i].func_190926_b();
            }
        } else {
            r = false;
        }
        return r;
    }

    public TileEntity getFirstNeighbourContainer(TileEntity home) {
        TileEntity e = null;
        e = home.func_145831_w().func_175625_s(home.func_174877_v().func_177982_a(0, -1, 0));
        if (!(e != null && e instanceof IInventory || (e = home.func_145831_w().func_175625_s(home.func_174877_v().func_177982_a(0, 1, 0))) != null && e instanceof IInventory || (e = home.func_145831_w().func_175625_s(home.func_174877_v().func_177982_a(-1, 0, 0))) != null && e instanceof IInventory || (e = home.func_145831_w().func_175625_s(home.func_174877_v().func_177982_a(1, 0, 0))) != null && e instanceof IInventory || (e = home.func_145831_w().func_175625_s(home.func_174877_v().func_177982_a(0, 0, -1))) != null && e instanceof IInventory || (e = home.func_145831_w().func_175625_s(home.func_174877_v().func_177982_a(0, 0, 1))) == null || e instanceof IInventory)) {
            e = null;
        }
        return e;
    }

    public boolean CompareStacks(ItemStack One, ItemStack Two) {
        boolean r = false;
        if ((One == null || One.func_190926_b()) && (Two == null || Two.func_190926_b())) {
            r = true;
        } else if (One != null && Two != null && !One.func_190926_b() && !Two.func_190926_b()) {
            r = One.func_185136_b(Two);
        }
        return r;
    }

    public int putInventoryStack(IInventory target, ItemStack stack, int transferAmount) {
        int r = 0;
        if (stack != null) {
            int amount = transferAmount;
            if (stack.func_190916_E() < transferAmount) {
                amount = stack.func_190916_E();
            }
            boolean found = false;
            for (int i = 0; i < target.func_70302_i_() && !found && amount > 0; ++i) {
                int free;
                if (!target.func_94041_b(i, stack)) continue;
                ItemStack sis = target.func_70301_a(i);
                if (sis == null || sis.func_190926_b()) {
                    ItemStack dest = stack.func_77946_l();
                    dest.func_190920_e(amount);
                    target.func_70299_a(i, dest);
                    found = true;
                    r += amount;
                    continue;
                }
                if (!this.CompareStacks(sis, stack) || (free = sis.func_77976_d() - sis.func_190916_E()) <= 0) continue;
                int draw = free;
                if (draw > amount) {
                    draw = amount;
                }
                sis.func_190920_e(sis.func_190916_E() + draw);
                target.func_70299_a(i, sis);
                r += draw;
                if ((amount -= draw) != 0) continue;
                found = true;
            }
        }
        return r;
    }

    public void dropItems(BlockPos pos) {
        Random rand = new Random();
        for (int i = 0; i < this.Inv.length; ++i) {
            ItemStack item;
            if (!this.dropList.contains(i) || (item = this.Inv[i]) == null || item.func_190926_b()) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), item.func_77946_l());
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            this.field_145850_b.func_72838_d((Entity)entityItem);
            item.func_190920_e(0);
        }
    }
}

