/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.common.configs;

import hu.nvl.nvlforcefields.common.NVLCommonFunctions;
import java.io.IOException;
import java.util.ArrayList;

public class NVLMappingsConfigFile {
    private NVLCommonFunctions logger;
    public static ArrayList<String> sources = new ArrayList();
    public static ArrayList<String> destinations = new ArrayList();

    public NVLMappingsConfigFile(NVLCommonFunctions common, String fileName) {
        this.logger = common;
        if (!fileName.isEmpty()) {
            this.loadMappings(fileName);
        }
    }

    protected void logLine(String msg) {
        this.logger.logLine(this.getClass().getSimpleName(), msg);
    }

    public void addMapping(String from, String to) {
        if (!sources.contains(from)) {
            sources.add(from);
            destinations.add(to);
        } else {
            this.logLine("addMapping: already exists: [" + from + "]");
        }
    }

    public int getMappingCount() {
        return sources.size();
    }

    public String getMapped(String from) {
        String r = "";
        int idx = sources.indexOf(from);
        if (idx > -1) {
            r = destinations.get(idx);
        }
        return r;
    }

    public void loadMappings(String fileName) {
        try {
            ArrayList<String> lines = NVLCommonFunctions.loadTextFile("/assets/" + this.logger.getModID().toLowerCase() + "/config/" + fileName);
            for (int i = 0; i < lines.size(); ++i) {
                String[] parts;
                String line = lines.get(i);
                if (line.isEmpty() || line.startsWith(";") || line.startsWith("/") || line.startsWith("#") || (parts = line.split(",")).length != 2) continue;
                this.addMapping(parts[0], parts[1]);
            }
        }
        catch (IOException e) {
            this.logLine("loadMappings: exception " + e.getMessage());
        }
    }
}

