/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.common.dataclasses;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class NVLCoordinates {
    public int dim;
    public int x;
    public int y;
    public int z;
    public int ori;

    public NVLCoordinates() {
        this.reset();
    }

    public NVLCoordinates(int Dimension, int ix, int iy, int iz, int io) {
        this.setCoords(Dimension, ix, iy, iz, io);
    }

    public NVLCoordinates(TileEntity te) {
        this.reset();
        this.getCoordsFromTileEntity(te);
    }

    public NVLCoordinates(String line) {
        this.reset();
        this.fillDataFromString(line);
    }

    public NVLCoordinates(NVLCoordinates CopyFrom) {
        this.dim = CopyFrom.dim;
        this.x = CopyFrom.x;
        this.y = CopyFrom.y;
        this.z = CopyFrom.z;
        this.ori = CopyFrom.ori;
    }

    public void setCoords(int Dimension, int ix, int iy, int iz, int io) {
        this.dim = Dimension;
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.ori = io;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public void fillDataFromString(String line) {
        String[] params = line.split(",");
        if (params.length == 4) {
            this.dim = Integer.parseInt(params[0]);
            this.x = Integer.parseInt(params[1]);
            this.y = Integer.parseInt(params[2]);
            this.z = Integer.parseInt(params[3]);
            this.ori = -1;
        }
        if (params.length == 5) {
            this.dim = Integer.parseInt(params[0]);
            this.x = Integer.parseInt(params[1]);
            this.y = Integer.parseInt(params[2]);
            this.z = Integer.parseInt(params[3]);
            this.ori = Integer.parseInt(params[4]);
        }
    }

    public void copyCoordinates(NVLCoordinates Coords) {
        this.dim = Coords.dim;
        this.x = Coords.x;
        this.y = Coords.y;
        this.z = Coords.z;
        this.ori = Coords.ori;
    }

    public Boolean isValid() {
        return this.y >= 0 && this.y <= 255;
    }

    public Boolean isSet() {
        return this.dim != -99999 || this.y != -1000;
    }

    public void reset() {
        this.dim = -99999;
        this.x = 0;
        this.y = -1000;
        this.z = 0;
        this.ori = -1;
    }

    public String toString() {
        return this.isValid() != false ? this.dim + "," + this.x + "," + this.y + "," + this.z + "," + this.ori : "invalid";
    }

    public String toStringNocheck() {
        return this.dim + "," + this.x + "," + this.y + "," + this.z + "," + this.ori;
    }

    public void getCoordsFromTileEntity(TileEntity e) {
        if (e != null) {
            this.dim = e.func_145831_w().field_73011_w.getDimension();
            this.x = e.func_174877_v().func_177958_n();
            this.y = e.func_174877_v().func_177956_o();
            this.z = e.func_174877_v().func_177952_p();
            this.ori = -1;
        }
    }

    public boolean isCoordinatesNear(NVLCoordinates check) {
        return this.isCoordinatesNear(check, 8);
    }

    public boolean isCoordinatesNear(NVLCoordinates check, int distance) {
        return check.dim == this.dim && check.x > this.x - distance && check.x < this.x + distance && check.y > this.y - distance && check.y < this.y + distance && check.z > this.z - distance && check.z < this.z + distance;
    }

    public boolean isMatch(NVLCoordinates check) {
        return check.dim == this.dim && check.x == this.x && check.y == this.y && check.z == this.z;
    }

    public void setDistanceBetween(NVLCoordinates Source, NVLCoordinates Destination) {
        this.reset();
        this.x = Source.x - Destination.x;
        this.y = Source.y - Destination.y;
        this.z = Source.z - Destination.z;
    }

    public void applyDistance(NVLCoordinates Target) {
        this.x += Target.x;
        this.y += Target.y;
        this.z += Target.z;
    }

    public void applyDistance(int Side2, int Distance) {
        if (Side2 >= 0 && Side2 < 6) {
            switch (Side2) {
                case 0: {
                    this.y -= Distance;
                    break;
                }
                case 1: {
                    this.y += Distance;
                    break;
                }
                case 2: {
                    this.z -= Distance;
                    break;
                }
                case 3: {
                    this.z += Distance;
                    break;
                }
                case 4: {
                    this.x -= Distance;
                    break;
                }
                case 5: {
                    this.x += Distance;
                }
            }
        }
    }
}

