/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.common.dataclasses;

import hu.nvl.nvlforcefields.entities.NVLEntityFieldColumn;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class NVLPeerProperties {
    public static final int PTUNKNOWN = 0;
    public static final int PTENDPOINT = 1;
    public static final int PTEMITTER = 2;
    public static final int PTCONTROLLER = 3;
    private int side = -1;
    private int distance = 0;
    private int peertype = 0;
    private String uid = "";
    private Boolean online = false;

    public NVLPeerProperties() {
        this.reset();
    }

    public NVLPeerProperties(NVLEntityFieldColumn base, NVLEntityFieldColumn remote) {
        this.reset();
        this.readRelativeInfo(base, remote);
    }

    public void reset() {
        this.side = -1;
        this.distance = 0;
        this.peertype = 0;
        this.uid = "";
        this.online = false;
    }

    public void getDistance(TileEntity te, int x, int y, int z) {
        if (x == te.func_174877_v().func_177958_n() && z == te.func_174877_v().func_177952_p()) {
            if (te.func_174877_v().func_177956_o() > y) {
                this.distance = te.func_174877_v().func_177956_o() - y;
                this.side = 0;
            }
            if (te.func_174877_v().func_177956_o() < y) {
                this.distance = y - te.func_174877_v().func_177956_o();
                this.side = 1;
            }
        }
        if (x == te.func_174877_v().func_177958_n() && y == te.func_174877_v().func_177956_o()) {
            if (te.func_174877_v().func_177952_p() > z) {
                this.distance = te.func_174877_v().func_177952_p() - z;
                this.side = 2;
            }
            if (te.func_174877_v().func_177952_p() < z) {
                this.distance = z - te.func_174877_v().func_177952_p();
                this.side = 3;
            }
        }
        if (z == te.func_174877_v().func_177952_p() && y == te.func_174877_v().func_177956_o()) {
            if (te.func_174877_v().func_177958_n() > x) {
                this.distance = te.func_174877_v().func_177958_n() - x;
                this.side = 4;
            }
            if (te.func_174877_v().func_177958_n() < x) {
                this.distance = x - te.func_174877_v().func_177958_n();
                this.side = 5;
            }
        }
    }

    public int getSide() {
        return this.side;
    }

    public int getDistance() {
        return this.distance;
    }

    public int getPeerType() {
        return this.peertype;
    }

    public String getUID() {
        return this.uid;
    }

    public Boolean isOnline() {
        return this.online;
    }

    public void setPeerType(int newType) {
        this.peertype = newType;
    }

    public void setOnline(Boolean state) {
        this.online = state;
    }

    public void setSide(int newSide) {
        this.side = newSide;
    }

    public boolean isEqual(NVLPeerProperties p) {
        return p.getDistance() == this.distance && p.getSide() == this.side;
    }

    public void copyFromPeerProps(NVLPeerProperties p) {
        this.distance = p.getDistance();
        this.side = p.getSide();
        this.peertype = p.getPeerType();
        this.uid = p.getUID();
        this.online = p.isOnline();
    }

    public void readRelativeInfo(NVLEntityFieldColumn base, NVLEntityFieldColumn remote) {
        if (base != null && remote != null) {
            this.peertype = remote.getMode();
            this.uid = remote.getUID();
            this.getDistance(base, remote.func_174877_v().func_177958_n(), remote.func_174877_v().func_177956_o(), remote.func_174877_v().func_177952_p());
        }
    }

    public String exportAsString() {
        return this.side + "," + this.distance + "," + this.peertype + "," + this.uid + "," + (this.online != false ? "1" : "0");
    }

    public void importFromString(String line) {
        this.reset();
        String[] params = line.split(",");
        if (params.length == 4) {
            this.side = Integer.parseInt(params[0]);
            this.distance = Integer.parseInt(params[1]);
            this.peertype = Integer.parseInt(params[2]);
            this.uid = params[3];
        }
        if (params.length == 5) {
            this.side = Integer.parseInt(params[0]);
            this.distance = Integer.parseInt(params[1]);
            this.peertype = Integer.parseInt(params[2]);
            this.uid = params[3];
            this.online = params[4] == "1";
        }
    }

    public void readFromNBT(NBTTagCompound c, String prefix) {
        this.side = c.func_74762_e(prefix.concat("s"));
        this.distance = c.func_74762_e(prefix.concat("d"));
        this.peertype = c.func_74762_e(prefix.concat("p"));
        this.uid = c.func_74779_i(prefix.concat("u"));
        this.online = c.func_74767_n(prefix.concat("o"));
    }

    public void writeToNBT(NBTTagCompound c, String prefix) {
        c.func_74768_a(prefix.concat("s"), this.side);
        c.func_74768_a(prefix.concat("d"), this.distance);
        c.func_74768_a(prefix.concat("p"), this.peertype);
        c.func_74778_a(prefix.concat("u"), this.uid);
        c.func_74757_a(prefix.concat("o"), this.online.booleanValue());
    }

    public boolean isOkForField() {
        return this.distance > 1 && this.side > -1;
    }
}

