/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.entities;

import hu.nvl.nvlforcefields.blocks.NVLBlockFieldColumn;
import hu.nvl.nvlforcefields.common.NVLTileEntityInventory;
import hu.nvl.nvlforcefields.common.dataclasses.NVLCoordinates;
import hu.nvl.nvlforcefields.common.dataclasses.NVLEnumOnlineStates;
import hu.nvl.nvlforcefields.common.dataclasses.NVLPeerProperties;
import hu.nvl.nvlforcefields.entities.NVLEntityFieldController;
import hu.nvl.nvlforcefields.registries.NVLBlockRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class NVLEntityFieldColumn
extends NVLTileEntityInventory
implements ITickable {
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"fieldcolor", EnumDyeColor.class);
    public static final PropertyEnum<NVLEnumOnlineStates> ONLINESTATE = PropertyEnum.func_177709_a((String)"onlinestate", NVLEnumOnlineStates.class);
    public static final Block FORCEFIELDBLOCK1 = NVLBlockRegistry.NVLFFBlock;
    public static final Block FORCEFIELDBLOCK2 = NVLBlockRegistry.NVLFFBlockSolid;
    public static final int DEFAULTFIELDLENGTH = 20;
    protected NVLPeerProperties[] peers = new NVLPeerProperties[6];
    protected NVLPeerProperties myController = new NVLPeerProperties();
    protected boolean online = false;
    private boolean initialized = false;
    private String uid = "";
    public IBlockState fieldBlock = FORCEFIELDBLOCK1.func_176223_P();
    protected int fieldMeta = 0;
    protected int maxFieldLength = 20;
    protected int mymode = 1;
    protected String allowField = "111111";
    private Boolean needValidation = false;

    public NVLEntityFieldColumn() {
        for (int i = 0; i < 6; ++i) {
            this.peers[i] = new NVLPeerProperties();
        }
        this.Inv = new ItemStack[0];
    }

    public int getMode() {
        return this.mymode;
    }

    public boolean getOnline() {
        return this.online;
    }

    public String getUID() {
        return this.uid;
    }

    public void destroyEndpoint() {
        if (this.mymode == 2) {
            this.turnOff();
        }
        for (int i = 0; i < 6; ++i) {
            NVLEntityFieldColumn c;
            if (this.peers[i].getDistance() <= 0 || (c = this.getColumnEntity(this.peers[i].getSide(), this.peers[i].getDistance())) == null) continue;
            c.disconnectEndpoint(this);
        }
    }

    public void registerController(NVLEntityFieldColumn c, int newFieldLength, String newAllowance, IBlockState newField, int newFieldMeta) {
        this.myController.readRelativeInfo(this, c);
        this.mymode = 2;
        this.maxFieldLength = newFieldLength;
        this.allowField = newAllowance;
        this.fieldMeta = newFieldMeta;
        this.fieldBlock = this.fieldMeta > -1 ? newField.func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176766_a((int)newFieldMeta)) : newField;
        this.turnOn();
    }

    public void clearController() {
        this.turnOff();
        this.myController.reset();
    }

    public Boolean hasController() {
        return this.myController.getDistance() > 0;
    }

    public int getNumberOfEndpoints() {
        int r = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.peers[i].getDistance() <= 0) continue;
            ++r;
        }
        return r;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        for (int i = 0; i < 6; ++i) {
            this.peers[i].readFromNBT(tag, "ffefc:p" + i);
        }
        this.myController.readFromNBT(tag, "ffefc:myc");
        this.mymode = tag.func_74762_e("ffefc:mode");
        this.online = tag.func_74767_n("ffefc:onl");
        this.initialized = tag.func_74767_n("ffefc:ini");
        this.allowField = tag.func_74779_i("ffefc:af");
        if (this.allowField.length() != 6) {
            this.allowField = "111111";
        }
        this.fieldMeta = tag.func_74762_e("ffefc:fm");
        this.fieldBlock = this.fieldMeta > -1 ? Block.func_149684_b((String)tag.func_74779_i("ffefc:fb")).func_176223_P().func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176766_a((int)this.fieldMeta)) : Block.func_149684_b((String)tag.func_74779_i("ffefc:fb")).func_176223_P();
        this.uid = tag.func_74779_i("ffefc:uid");
        super.func_145839_a(tag);
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.needValidation = true;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74778_a("ffefc:uid", this.uid);
        tag.func_74768_a("ffefc:fm", this.fieldMeta);
        ResourceLocation l = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.fieldBlock.func_177230_c());
        String name = l.toString();
        tag.func_74778_a("ffefc:fb", name);
        tag.func_74778_a("ffefc:af", this.allowField);
        tag.func_74757_a("ffefc:ini", this.initialized);
        tag.func_74757_a("ffefc:onl", this.online);
        tag.func_74768_a("ffefc:mode", this.mymode);
        for (int i = 0; i < 6; ++i) {
            this.peers[i].writeToNBT(tag, "ffefc:p" + i);
        }
        this.myController.writeToNBT(tag, "ffefc:myc");
        return tag;
    }

    protected void validatePeers() {
        if (this.online) {
            int i;
            NVLPeerProperties[] newPeers = new NVLPeerProperties[6];
            for (i = 0; i < 6; ++i) {
                newPeers[i] = new NVLPeerProperties();
            }
            newPeers[0].copyFromPeerProps(this.peers[0]);
            newPeers[1].copyFromPeerProps(this.peers[1]);
            for (i = 2; i < this.peers.length; ++i) {
                if (this.peers[i].getDistance() <= 0) continue;
                int newSide = this.findPeer(this.peers[i].getUID(), this.peers[i].getDistance());
                if (newSide > -1) {
                    newPeers[newSide].copyFromPeerProps(this.peers[i]);
                    newPeers[newSide].setSide(newSide);
                    continue;
                }
                this.logLine("validatePeers: could not find peer:" + this.peers[i].getUID());
            }
            this.peers = newPeers;
            this.syncClient();
        }
    }

    protected int findPeer(String findUID, int distance) {
        int r = -1;
        for (int i = 2; i < 6 && r == -1; ++i) {
            NVLEntityFieldColumn t = this.getColumnEntity(i, distance);
            if (t == null || !t.getUID().equals(findUID)) continue;
            r = i;
        }
        return r;
    }

    public void setOnlineRemote(NVLEntityFieldColumn emitter, boolean state) {
        NVLPeerProperties peer = new NVLPeerProperties(this, emitter);
        if (state) {
            this.peers[peer.getSide()] = peer;
            this.peers[peer.getSide()].setOnline(state);
        } else {
            this.peers[peer.getSide()].reset();
        }
        this.syncClient();
        this.evaluateOnline();
    }

    private void evaluateOnline() {
        Boolean r = false;
        for (int i = 0; i < 6 && !r.booleanValue(); ++i) {
            if (!this.peers[i].isOnline().booleanValue()) continue;
            r = true;
        }
        this.online = r;
        this.setMeta();
    }

    public boolean isOnline() {
        return this.online;
    }

    public void disconnectEndpoint(NVLEntityFieldColumn endpoint) {
        NVLEntityFieldColumn c;
        NVLPeerProperties peer = new NVLPeerProperties(this, endpoint);
        if (peer.getUID().equals(this.peers[peer.getSide()].getUID())) {
            this.processField(peer.getSide(), false);
            this.peers[peer.getSide()].reset();
        }
        if (this.hasController().booleanValue() && (c = this.getColumnEntity(this.myController.getSide(), this.myController.getDistance())) != null) {
            ((NVLEntityFieldController)c).endpointDisconnected();
        }
    }

    public void turnOn() {
        if (!(this.mymode != 2 && this.mymode != 3 || this.online)) {
            this.online = true;
            for (int i = 0; i < 6; ++i) {
                if (this.allowField.charAt(i) != '1') continue;
                this.scanDirection(i);
                this.processField(i, true);
            }
            this.setMeta();
            this.syncClient();
        }
    }

    protected void scanDirection(int dir) {
        this.peers[dir].reset();
        NVLEntityFieldColumn ce = this.getColumnEntity(dir, 1);
        if (ce == null) {
            boolean search = true;
            for (int i = 1; i <= this.maxFieldLength + 1 && search; ++i) {
                NVLCoordinates c = new NVLCoordinates(this);
                c.applyDistance(dir, i);
                Block b = this.func_145831_w().func_180495_p(c.getBlockPos()).func_177230_c();
                if (b instanceof NVLBlockFieldColumn) {
                    ce = this.getColumnEntity(dir, i);
                    if (ce == null || ce.getMode() != 1) continue;
                    this.peers[dir].readRelativeInfo(this, ce);
                    ce.setOnlineRemote(this, true);
                    search = false;
                    continue;
                }
                search = NVLBlockRegistry.REPLACEABLES.contains(b);
            }
        }
    }

    public void turnOff() {
        if ((this.mymode == 2 || this.mymode == 3) && this.online) {
            for (int i = 0; i < 6; ++i) {
                if (this.peers[i].getDistance() <= 0) continue;
                this.processField(i, false);
                this.disconnectPeer(this.peers[i]);
            }
            this.online = false;
            if (this.mymode == 2) {
                this.mymode = 1;
            }
            this.setMeta();
            this.syncClient();
        }
    }

    protected void disconnectPeer(NVLPeerProperties peer) {
        NVLEntityFieldColumn c;
        if (peer.getDistance() > 0 && (c = this.getColumnEntity(peer.getSide(), peer.getDistance())) != null) {
            c.setOnlineRemote(this, false);
            peer.reset();
        }
    }

    private void processField(int side, boolean onoff) {
        if (onoff) {
            if (this.scanField(side)) {
                this.createField(side, true);
            }
        } else {
            this.createField(side, false);
        }
    }

    private boolean scanField(int side) {
        boolean r = false;
        if (this.peers[side].isOkForField()) {
            r = true;
            Block b = null;
            for (int i = 1; i < this.peers[side].getDistance() && r; ++i) {
                NVLCoordinates c = new NVLCoordinates(this);
                c.applyDistance(side, i);
                b = this.func_145831_w().func_180495_p(c.getBlockPos()).func_177230_c();
                r = NVLBlockRegistry.REPLACEABLES.contains(b);
            }
        }
        return r;
    }

    private void createField(int side, boolean create) {
        NVLCoordinates c = new NVLCoordinates(this);
        for (int i = 1; i < this.peers[side].getDistance(); ++i) {
            c.getCoordsFromTileEntity(this);
            c.applyDistance(side, i);
            if (!create) {
                if (this.func_145831_w().func_180495_p(c.getBlockPos()).func_177230_c().equals(this.fieldBlock.func_177230_c())) {
                    this.func_145831_w().func_175698_g(c.getBlockPos());
                    this.func_145831_w().func_175685_c(c.getBlockPos(), Blocks.field_150350_a, true);
                    if (this.func_145831_w().func_180495_p(c.getBlockPos()).func_177230_c().equals(Blocks.field_150355_j)) {
                        this.func_145831_w().func_175656_a(c.getBlockPos(), Blocks.field_150358_i.func_176223_P());
                    }
                }
            } else {
                this.func_145831_w().func_180501_a(c.getBlockPos(), this.fieldBlock, 3);
                if (this.func_145831_w().func_180495_p(c.getBlockPos().func_177982_a(0, -1, 0)).func_177230_c().equals(Blocks.field_150355_j)) {
                    this.func_145831_w().func_175656_a(c.getBlockPos().func_177982_a(0, -1, 0), Blocks.field_150358_i.func_176223_P());
                }
            }
            if (!FMLCommonHandler.instance().getEffectiveSide().isServer()) continue;
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(c.getBlockPos(), state, state, 3);
        }
    }

    public void setField(IBlockState b, int meta) {
        if (!b.func_177230_c().equals(this.fieldBlock.func_177230_c()) || meta != this.fieldMeta) {
            IBlockState old = this.fieldBlock;
            this.fieldBlock = meta > -1 ? b.func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176766_a((int)meta)) : b;
            this.fieldMeta = meta;
            if (this.online) {
                for (int i = 0; i < 6; ++i) {
                    this.repaintField(i, old);
                }
            }
        }
    }

    private void repaintField(int side, IBlockState old) {
        if (this.peers[side].getDistance() > 0) {
            NVLCoordinates c = new NVLCoordinates(this);
            for (int i = 1; i < this.peers[side].getDistance(); ++i) {
                c.getCoordsFromTileEntity(this);
                c.applyDistance(side, i);
                if (!this.func_145831_w().func_180495_p(c.getBlockPos()).func_177230_c().equals(old.func_177230_c())) continue;
                this.func_145831_w().func_180501_a(c.getBlockPos(), this.fieldBlock, 3);
            }
        }
    }

    private void setMeta() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a(ONLINESTATE, (Comparable)((Object)NVLEnumOnlineStates.getByBoolean(this.online)));
        this.func_145831_w().func_180501_a(this.field_174879_c, state, 3);
    }

    protected void syncClient() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    protected NVLEntityFieldColumn getColumnEntity(int dir, int distance) {
        NVLEntityFieldColumn r = null;
        NVLCoordinates c = new NVLCoordinates(this);
        if (c.isValid().booleanValue()) {
            c.applyDistance(dir, distance);
            TileEntity e = this.func_145831_w().func_175625_s(c.getBlockPos());
            if (e instanceof NVLEntityFieldColumn) {
                r = (NVLEntityFieldColumn)e;
            }
        }
        return r;
    }

    public void func_73660_a() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (!this.initialized && this.uid.isEmpty()) {
                this.uid = this.generateUID2("EFC");
                this.initialized = true;
                this.syncClient();
            }
            if (this.needValidation.booleanValue()) {
                this.validatePeers();
                this.needValidation = false;
            }
        }
    }

    private String generateUID2(String Prefix) {
        Random ra = new Random();
        String r = Prefix + Integer.toString(ra.nextInt(1000000), 16);
        return r;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        return ItemStack.field_190927_a;
    }
}

