/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.entities;

import hu.nvl.nvlforcefields.common.dataclasses.NVLPeerProperties;
import hu.nvl.nvlforcefields.entities.NVLEntityFieldColumn;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;

public class NVLEntityFieldController
extends NVLEntityFieldColumn {
    public static final int MAXCOLORS = 16;
    protected NVLPeerProperties[][] emitters;
    private ItemStack redstoneEnabled;
    private ItemStack redstoneDisabled;
    protected Boolean canRedstoneControl = false;
    protected int MAXEMITTERS = 5;
    protected String allowEmitters = "111111";

    public NVLEntityFieldController() {
        this.Inv = new ItemStack[33];
        this.mymode = 3;
        this.emitters = new NVLPeerProperties[6][this.MAXEMITTERS];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < this.MAXEMITTERS; ++j) {
                this.emitters[i][j] = new NVLPeerProperties();
            }
        }
        this.fillSlots();
    }

    public void fillSlots() {
        for (int i = 0; i < 16; ++i) {
            this.Inv[i] = new ItemStack((Block)Blocks.field_150397_co, 1, 16 - i - 1);
            this.Inv[i].func_151001_c(I18n.func_74838_a((String)("FieldColors." + i)));
            this.Inv[16 + i] = new ItemStack((Block)Blocks.field_150397_co, 1, 16 - i - 1);
            this.Inv[16 + i].func_151001_c(I18n.func_74838_a((String)("FieldColors.Solid." + i)));
        }
        this.redstoneEnabled = new ItemStack(Items.field_151137_ax, 1);
        this.redstoneEnabled.func_151001_c(I18n.func_74838_a((String)"RedstoneEnabled"));
        this.redstoneDisabled = new ItemStack(Blocks.field_150430_aB, 1);
        this.redstoneDisabled.func_151001_c(I18n.func_74838_a((String)"RedstoneDisabled"));
        this.Inv[32] = this.canRedstoneControl != false ? this.redstoneEnabled : this.redstoneDisabled;
    }

    public void toggleRedcontrol() {
        if (this.online) {
            this.turnOff();
        }
        this.canRedstoneControl = this.canRedstoneControl == false;
        this.Inv[32] = this.canRedstoneControl != false ? this.redstoneEnabled : this.redstoneDisabled;
    }

    public boolean canRedstoneOperate() {
        return this.canRedstoneControl;
    }

    public boolean canOperate(EntityPlayer player) {
        return true;
    }

    public boolean canOpenGUI(EntityPlayer player) {
        return true;
    }

    public void retestRedstone() {
        Boolean r;
        if (this.canRedstoneControl.booleanValue() && (r = Boolean.valueOf(this.func_145831_w().func_175687_A(this.field_174879_c) > 0)) != this.online) {
            if (r.booleanValue()) {
                this.turnOn();
            } else {
                this.turnOff();
            }
        }
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < this.MAXEMITTERS; ++j) {
                this.emitters[i][j].readFromNBT(tag, "ffefco:ed" + i + j);
            }
        }
        this.canRedstoneControl = tag.func_74767_n("ffefco:crc");
        super.func_145839_a(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < this.MAXEMITTERS; ++j) {
                this.emitters[i][j].writeToNBT(tag, "ffefco:ed" + i + j);
            }
        }
        tag.func_74757_a("ffefco:crc", this.canRedstoneControl.booleanValue());
        return tag;
    }

    @Override
    public void turnOn() {
        if (!this.online) {
            super.turnOn();
            for (int i = 0; i < 6; ++i) {
                if (this.allowEmitters.charAt(i) != '1') continue;
                Boolean end = false;
                for (int j = 0; j < this.MAXEMITTERS; ++j) {
                    if (!end.booleanValue()) {
                        NVLEntityFieldColumn c = this.getColumnEntity(i, j + 1);
                        if (c != null && c.getMode() == 1 && !c.getOnline()) {
                            this.emitters[i][j].readRelativeInfo(this, c);
                            c.registerController(this, this.maxFieldLength, this.allowField, this.fieldBlock, this.fieldMeta);
                        } else {
                            end = true;
                        }
                    }
                    if (!end.booleanValue()) continue;
                    this.emitters[i][j].reset();
                }
            }
        }
    }

    @Override
    public void turnOff() {
        if (this.online) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < this.MAXEMITTERS; ++j) {
                    NVLEntityFieldColumn c;
                    if (this.emitters[i][j].getDistance() <= 0 || (c = this.getColumnEntity(i, this.emitters[i][j].getDistance())) == null) continue;
                    c.clearController();
                }
            }
            super.turnOff();
        }
    }

    @Override
    protected void validatePeers() {
        if (this.online) {
            int j;
            int i;
            NVLPeerProperties[][] newEmitters = new NVLPeerProperties[6][this.MAXEMITTERS];
            for (i = 0; i < 6; ++i) {
                for (j = 0; j < this.MAXEMITTERS; ++j) {
                    newEmitters[i][j] = new NVLPeerProperties();
                }
            }
            for (i = 0; i < 6; ++i) {
                for (j = 0; j < this.MAXEMITTERS; ++j) {
                    if (this.emitters[i][j].getDistance() <= 0) continue;
                    if (i < 2) {
                        newEmitters[i][j].copyFromPeerProps(this.emitters[i][j]);
                        continue;
                    }
                    int newSide = this.findPeer(this.emitters[i][j].getUID(), this.emitters[i][j].getDistance());
                    if (newSide > -1) {
                        newEmitters[newSide][j].copyFromPeerProps(this.emitters[i][j]);
                        newEmitters[newSide][j].setSide(newSide);
                        continue;
                    }
                    this.logLine("validateEmitters: could not find emitter:" + this.emitters[i][j].getUID());
                }
            }
            this.emitters = newEmitters;
            this.syncClient();
        }
        super.validatePeers();
    }

    @Override
    public void setField(IBlockState b, int meta) {
        if (!b.func_177230_c().equals(this.fieldBlock.func_177230_c()) || this.fieldMeta != meta) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < this.MAXEMITTERS; ++j) {
                    NVLEntityFieldColumn c;
                    if (this.emitters[i][j].getDistance() <= 0 || (c = this.getColumnEntity(i, j + 1)) == null) continue;
                    c.setField(b, meta);
                }
            }
            super.setField(b, meta);
        }
    }

    @Override
    public void destroyEndpoint() {
        this.turnOff();
        super.destroyEndpoint();
    }

    @Override
    public void disconnectEndpoint(NVLEntityFieldColumn endpoint) {
        super.disconnectEndpoint(endpoint);
        this.endpointDisconnected();
    }

    public void endpointDisconnected() {
        if (this.online) {
            int endpoints = this.getNumberOfEndpoints();
            if (endpoints == 0) {
                for (int i = 0; i < 6 && endpoints == 0; ++i) {
                    for (int j = 0; j < this.MAXEMITTERS && endpoints == 0; ++j) {
                        NVLEntityFieldColumn c;
                        if (this.emitters[i][j].getDistance() <= 0 || (c = this.getColumnEntity(i, j + 1)) == null) continue;
                        endpoints += c.getNumberOfEndpoints();
                    }
                }
            }
            if (endpoints == 0) {
                this.turnOff();
            }
        }
    }
}

