/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.entities;

import hu.nvl.nvlforcefields.common.NVLPacketHandler;
import hu.nvl.nvlforcefields.entities.NVLEntityFieldController;
import hu.nvl.nvlforcefields.nvlforcefields;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.StringUtils;

public class NVLEntityFieldControllerSecure
extends NVLEntityFieldController {
    private String owner = "";
    protected ArrayList<String> users = new ArrayList();
    private String onlineUsers = "";
    private Boolean isPublic = true;
    private Boolean clientSyncFlag = true;

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.owner = tag.func_74779_i("ffefcs:csowner");
        String s = tag.func_74779_i("ffefcs:csusers");
        this.users.clear();
        if (!s.isEmpty()) {
            String[] userList = s.split(";");
            for (int i = 0; i < userList.length; ++i) {
                this.users.add(userList[i]);
            }
        }
        this.isPublic = tag.func_74767_n("ffefcs:cspub");
        this.clientSyncFlag = tag.func_74767_n("ffefcs:csflag");
        if (tag.func_74764_b("ffefcs:onlul")) {
            this.onlineUsers = tag.func_74779_i("ffefcs:onlul");
        }
        super.func_145839_a(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74778_a("ffefcs:csowner", this.owner);
        tag.func_74778_a("ffefcs:csusers", StringUtils.join(this.users, (String)";"));
        tag.func_74757_a("ffefcs:cspub", this.isPublic.booleanValue());
        tag.func_74757_a("ffefcs:csflag", this.clientSyncFlag.booleanValue());
        tag.func_74778_a("ffefcs:onlul", StringUtils.join((Object[])FMLCommonHandler.instance().getMinecraftServerInstance().func_71213_z(), (String)";"));
        return tag;
    }

    @Override
    public boolean canOperate(EntityPlayer player) {
        boolean r;
        boolean bl = r = this.isPublic != false || this.owner.isEmpty();
        if (!r) {
            if (player.func_70005_c_().equals(this.owner)) {
                r = true;
            } else if (this.users.indexOf(player.func_70005_c_()) > -1) {
                r = true;
            }
        }
        return r;
    }

    @Override
    public boolean canOpenGUI(EntityPlayer player) {
        return this.owner.isEmpty() || this.owner.equals(player.func_70005_c_());
    }

    public String getOwner() {
        return this.owner;
    }

    public final ArrayList<String> getUserList() {
        return this.users;
    }

    public Boolean getPublicity() {
        return this.isPublic;
    }

    public Boolean getSyncMode() {
        return this.clientSyncFlag;
    }

    public String getOnlineUsers() {
        return this.onlineUsers;
    }

    public void setOwner(String newOwner) {
        if (!this.owner.equals(newOwner)) {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                this.owner = newOwner;
                if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                    this.sendUpdateToServer("");
                }
            } else {
                if (newOwner.equals("---DELETE---")) {
                    this.owner = "";
                    this.isPublic = true;
                } else {
                    this.owner = newOwner;
                }
                this.syncClient();
            }
        }
    }

    public void setMember(String newMember) {
        if (!newMember.isEmpty()) {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                this.sendUpdateToServer(newMember);
            } else {
                if (newMember.equals("---CLEARALL---")) {
                    this.users.clear();
                } else {
                    String name = newMember;
                    if (newMember.charAt(0) == '\u00a4') {
                        name = newMember.substring(1);
                        if (!this.users.remove(name)) {
                            this.logLine("setMember: unable to remove [" + name + "] : " + StringUtils.join(this.users, (char)';'));
                        }
                    } else if (this.users.indexOf(name) == -1) {
                        this.users.add(name);
                    }
                }
                this.syncClient();
            }
        }
    }

    public void setPublic(Boolean newPublic) {
        if (this.isPublic != newPublic) {
            this.isPublic = newPublic;
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                this.sendUpdateToServer("");
            } else {
                this.syncClient();
            }
        }
    }

    private void sendUpdateToServer(String newMember) {
        this.clientSyncFlag = false;
        nvlforcefields.channel.sendToServer(NVLPacketHandler.createFFCSPacket(this.field_174879_c, this.owner, newMember, this.isPublic));
    }
}

