/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.guis;

import hu.nvl.nvlforcefields.common.NVLCommonFunctions;
import hu.nvl.nvlforcefields.containers.NVLContainerFFDoor;
import hu.nvl.nvlforcefields.containers.NVLContainerFieldControllerSecure;
import hu.nvl.nvlforcefields.entities.NVLEntityFieldControllerSecure;
import hu.nvl.nvlforcefields.entities.NVLEntityFieldDoorController;
import hu.nvl.nvlforcefields.guis.NVLGuiListHelper;
import hu.nvl.nvlforcefields.guis.components.NVLBooleanGuiButton;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class NVLGuiFFCS
extends GuiContainer {
    private NVLCommonFunctions logger;
    private ResourceLocation texture;
    private World WorldObj;
    private BlockPos sPos;
    private long nextUpdate = 0L;
    private NVLEntityFieldControllerSecure TEntity = null;
    private GuiTextField textfield;
    private boolean Confirm = false;
    private boolean ConfirmAll = false;
    private String OwnerName = "";
    private String PlayerName = "";
    private boolean State = false;
    private boolean UpdateMode = true;
    private NVLGuiListHelper userListHelper;
    private NVLGuiListHelper onlineListHelper;
    private Boolean pageState = true;

    public NVLGuiFFCS(InventoryPlayer player, NVLEntityFieldControllerSecure te, NVLCommonFunctions common) {
        super((Container)new NVLContainerFieldControllerSecure(player, te, common));
        this.init(player, te, common);
        this.texture = new ResourceLocation(this.logger.getModID().toLowerCase(), "textures/gui/ffcs_gui.png");
    }

    public NVLGuiFFCS(InventoryPlayer player, NVLEntityFieldDoorController te, NVLCommonFunctions common) {
        super((Container)new NVLContainerFFDoor(player, te, common));
        this.init(player, te, common);
        this.texture = new ResourceLocation(this.logger.getModID().toLowerCase(), "textures/gui/ffcs_gui.png");
    }

    private void init(InventoryPlayer player, TileEntity te, NVLCommonFunctions common) {
        this.logger = common;
        this.WorldObj = te.func_145831_w();
        this.nextUpdate = this.WorldObj.func_82737_E() + 10L;
        this.PlayerName = player.field_70458_d.func_70005_c_();
        this.field_146294_l = 256;
        this.field_146295_m = 256;
        this.field_146999_f = 256;
        this.field_147000_g = 256;
        this.sPos = te.func_174877_v();
        this.userListHelper = new NVLGuiListHelper(6, 0, 0, 80, 11, "U");
        this.onlineListHelper = new NVLGuiListHelper(2, 0, 0, 58, 11, "O");
    }

    private void logLine(String msg) {
        this.logger.logLine(((Object)((Object)this)).getClass().getSimpleName() + " at " + this.sPos.toString(), msg);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int center = this.field_146294_l / 2;
        this.field_147009_r = 10;
        this.field_147003_i = center - 128;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, center - 35, 34, 152, 16, this.sctl("TakeOwnership")));
        NVLBooleanGuiButton accessButton = new NVLBooleanGuiButton(1, center - 35, 52, 152, 16, this.sctl("isPublic"), this.sctl("isRestricted"));
        accessButton.setState(this.State);
        this.field_146292_n.add(accessButton);
        this.onlineListHelper.setButtonPos(center - 118, 70);
        this.field_146292_n.add(this.onlineListHelper.upButton);
        this.field_146292_n.add(this.onlineListHelper.downButton);
        this.field_146292_n.add(new GuiButton(4, center + 61, 170, 57, 20, this.sctl("Delete")));
        this.textfield = new GuiTextField(0, this.field_146289_q, 92, 187, 80, 19);
        this.textfield.func_146205_d(false);
        this.textfield.func_146195_b(true);
        this.textfield.func_146203_f(16);
        this.textfield.func_146180_a("");
        this.field_146292_n.add(new GuiButton(5, center + 61, 197, 57, 20, this.sctl("Add")));
        this.userListHelper.setButtonPos(center - 34, 70);
        this.field_146292_n.add(this.userListHelper.upButton);
        this.field_146292_n.add(this.userListHelper.downButton);
        this.field_146292_n.add(new GuiButton(8, center - 67, 20, 20, 16, ">"));
        this.field_146292_n.add(new GuiButton(9, center - 118, 20, 20, 16, "<"));
        this.field_146292_n.add(new GuiButton(10, center + 61, 70, 57, 20, this.sctl("Clear")));
        this.field_146292_n.add(new GuiButton(11, center - 118, 197, 72, 20, this.sctl("Add")));
        this.showEditorElements(false);
        this.showOnlineUserList(this.pageState == false);
    }

    protected void func_146976_a(float arg0, int arg1, int arg2) {
        this.field_146297_k.field_71446_o.func_110577_a(this.texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int center = this.field_146294_l / 2;
        this.func_73729_b(center - 128, 10, 0, 0, 256, 256);
    }

    private String sctl(String text) {
        return I18n.func_74838_a((String)"FFCS.Gui.".concat(text));
    }

    protected void func_146979_b(int arg1, int arg2) {
        int center = this.field_146999_f / 2;
        if (this.WorldObj.func_82737_E() > this.nextUpdate) {
            this.nextUpdate = this.WorldObj.func_82737_E() + 10L;
            this.loadData();
        }
        ((GuiButton)this.field_146292_n.get((int)8)).field_146124_l = this.pageState;
        ((GuiButton)this.field_146292_n.get((int)9)).field_146124_l = this.pageState == false;
        this.showEditorElements(false);
        if (this.pageState.booleanValue()) {
            this.func_73732_a(this.field_146289_q, this.sctl("SelectColor"), center - 82, 40, 0xAAFFAA);
        } else {
            this.func_73732_a(this.field_146289_q, this.sctl("OnlineList"), center - 82, 40, 0xAAFFAA);
            this.drawLisHelper(this.onlineListHelper, center - 118, 60);
        }
        if (this.UpdateMode) {
            this.func_73732_a(this.field_146289_q, "Reading data...", center + 40, 14, 0xAAFFAA);
            ((GuiButton)this.field_146292_n.get((int)0)).field_146125_m = false;
        } else {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146125_m = this.OwnerName.isEmpty() || this.OwnerName.equals(this.PlayerName);
            this.func_73732_a(this.field_146289_q, this.OwnerName.isEmpty() ? this.sctl("NoOwner") : this.sctl("Owner") + this.OwnerName, center + 40, 14, 0xAAFFAA);
            if (this.OwnerName.equals(this.PlayerName)) {
                this.showEditorElements(true);
                this.textfield.func_146194_f();
                ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = this.sctl("ReleaseOwnership");
                ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = !this.userListHelper.getSelectedItem().isEmpty();
                ((GuiButton)this.field_146292_n.get((int)4)).field_146126_j = this.Confirm ? this.sctl("Really") : this.sctl("Delete");
                ((GuiButton)this.field_146292_n.get((int)10)).field_146124_l = this.userListHelper.userList.size() > 0;
                ((GuiButton)this.field_146292_n.get((int)10)).field_146126_j = this.ConfirmAll ? this.sctl("Really") : this.sctl("Clear");
                ((GuiButton)this.field_146292_n.get((int)11)).field_146124_l = !this.userListHelper.userList.contains(this.onlineListHelper.getSelectedItem());
                this.drawLisHelper(this.userListHelper, center - 34, 60);
            } else {
                ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = this.sctl("TakeOwnership");
            }
        }
    }

    private void drawLisHelper(NVLGuiListHelper h, int x, int y) {
        h.setStartPos(x, y);
        NVLGuiFFCS.func_73734_a((int)h.getMainLeft(), (int)h.getMainTop(), (int)h.getMainRight(), (int)h.getMainBottom(), (int)-14540254);
        NVLGuiFFCS.func_73734_a((int)h.getBarLeft(), (int)h.getBarTop(), (int)h.getBarRight(), (int)h.getBarBottom(), (int)-12303224);
        h.drawItems(this.field_146289_q);
    }

    private void loadData() {
        this.TEntity = null;
        TileEntity e = this.WorldObj.func_175625_s(this.sPos);
        if (e != null && e instanceof NVLEntityFieldControllerSecure) {
            this.TEntity = (NVLEntityFieldControllerSecure)e;
        }
        if (this.TEntity != null) {
            this.OwnerName = this.TEntity.getOwner();
            this.userListHelper.importArrayList(this.TEntity.getUserList());
            this.State = this.TEntity.getPublicity();
            this.UpdateMode = this.TEntity.getSyncMode() == false;
            ((NVLBooleanGuiButton)((Object)this.field_146292_n.get(1))).setState(this.State);
            this.onlineListHelper.importArray(this.TEntity.getOnlineUsers().split(";"));
        } else {
            this.logLine("loadData: wrong entity");
        }
    }

    private void showColorSelector(Boolean state) {
        int x;
        int y;
        int o = state != false ? 0 : 1000;
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                this.field_147002_h.func_75139_a((int)(y * 4 + x)).field_75221_f = 60 + o + y * 18;
            }
        }
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                this.field_147002_h.func_75139_a((int)(16 + y * 4 + x)).field_75221_f = 60 + o + 72 + y * 18;
            }
        }
    }

    private void showOnlineUserList(Boolean state) {
        this.onlineListHelper.downButton.field_146125_m = state;
        this.onlineListHelper.upButton.field_146125_m = state;
        ((GuiButton)this.field_146292_n.get((int)11)).field_146125_m = state;
    }

    private void showEditorElements(Boolean state) {
        ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m = state;
        for (int i = 4; i < 11; ++i) {
            ((GuiButton)this.field_146292_n.get((int)i)).field_146125_m = state;
        }
        this.textfield.func_146184_c(state.booleanValue());
        this.textfield.func_146195_b(state.booleanValue());
    }

    public void func_73869_a(char c, int i) {
        this.textfield.func_146201_a(c, i);
        if (i == 1) {
            try {
                super.func_73869_a(c, i);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void func_73864_a(int x, int y, int btn) {
        try {
            super.func_73864_a(x, y, btn);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int center = this.field_146294_l / 2;
        this.textfield.func_146192_a(x, y, btn);
        this.userListHelper.handleClick(x - (center - this.field_146999_f / 2), y - 10);
        this.onlineListHelper.handleClick(x - (center - this.field_146999_f / 2), y - 10);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 0) {
            this.TEntity.setOwner(this.OwnerName.isEmpty() ? this.PlayerName : "---DELETE---");
        }
        if (this.OwnerName.equals(this.PlayerName)) {
            if (guibutton.field_146127_k == 1) {
                this.TEntity.setPublic(!this.State);
            }
            this.onlineListHelper.handleButtons(guibutton.field_146127_k);
            if (guibutton.field_146127_k == 4) {
                if (!this.userListHelper.getSelectedItem().isEmpty()) {
                    if (!this.Confirm) {
                        this.Confirm = true;
                    } else {
                        this.TEntity.setMember("\u00a4" + this.userListHelper.getSelectedItem());
                        this.Confirm = false;
                    }
                } else {
                    this.Confirm = false;
                }
            } else {
                this.Confirm = false;
            }
            if (guibutton.field_146127_k == 5 && !this.textfield.func_146179_b().isEmpty()) {
                String t = this.textfield.func_146179_b();
                this.TEntity.setMember(t);
                this.textfield.func_146180_a("");
            }
            this.userListHelper.handleButtons(guibutton.field_146127_k);
            if (guibutton.field_146127_k == 8 || guibutton.field_146127_k == 9) {
                this.pageState = this.pageState == false;
                this.showColorSelector(this.pageState);
                this.showOnlineUserList(this.pageState == false);
            }
            if (guibutton.field_146127_k == 10) {
                if (!this.ConfirmAll) {
                    this.ConfirmAll = true;
                } else {
                    this.TEntity.setMember("---CLEARALL---");
                    this.ConfirmAll = false;
                }
            } else {
                this.ConfirmAll = false;
            }
            String s = this.onlineListHelper.getSelectedItem();
            if (guibutton.field_146127_k == 11 && !s.isEmpty() && !this.userListHelper.userList.contains(s)) {
                this.TEntity.setMember(s);
            }
        } else {
            this.Confirm = false;
            this.ConfirmAll = false;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }
}

