/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.guis;

import hu.nvl.nvlforcefields.common.NVLCommonFunctions;
import hu.nvl.nvlforcefields.common.dataclasses.NVLRecipeItem;
import hu.nvl.nvlforcefields.containers.NVLContainerHelp;
import hu.nvl.nvlforcefields.entities.NVLEntityFFHelp;
import hu.nvl.nvlforcefields.registries.NVLBlockRegistry;
import hu.nvl.nvlforcefields.registries.NVLItemRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.lwjgl.opengl.GL11;

public class NVLGuiHelp
extends GuiContainer {
    private NVLCommonFunctions logger;
    private int rcount = -1;
    private int page = 0;
    private int previouspage = -1;
    private int rindex = 0;
    private int prevrindex = -1;
    private NVLEntityFFHelp e;
    private ResourceLocation bg = new ResourceLocation("nvlforcefields".toLowerCase(), "textures/gui/hg_uni.png");
    private String recipeKind = "";
    private ArrayList<NVLRecipeItem> myrecipes = new ArrayList();

    private void loadRecipes() {
        List recipes = ForgeRegistries.RECIPES.getValues();
        if (recipes != null) {
            IRecipe tmpRecipe;
            int scan;
            NVLRecipeItem one;
            int i;
            for (i = 0; i < NVLBlockRegistry.NVLBlockList.size(); ++i) {
                if (!NVLBlockRegistry.NVLBlockList.get(i).getDisplayHelp()) continue;
                one = new NVLRecipeItem(new ItemStack((Block)NVLBlockRegistry.NVLBlockList.get(i)));
                for (scan = 0; scan < recipes.size(); ++scan) {
                    tmpRecipe = (IRecipe)recipes.get(scan);
                    if (!one.isEqual(tmpRecipe.func_77571_b())) continue;
                    one.addRecipe(tmpRecipe);
                }
                this.myrecipes.add(one);
            }
            for (i = 0; i < NVLItemRegistry.NVLItemList.size(); ++i) {
                if (!NVLItemRegistry.NVLItemList.get(i).getDisplayHelp()) continue;
                one = new NVLRecipeItem(new ItemStack((Item)NVLItemRegistry.NVLItemList.get(i)));
                for (scan = 0; scan < recipes.size(); ++scan) {
                    tmpRecipe = (IRecipe)recipes.get(scan);
                    if (!one.isEqual(tmpRecipe.func_77571_b())) continue;
                    one.addRecipe(tmpRecipe);
                }
                this.myrecipes.add(one);
            }
        }
    }

    public NVLGuiHelp(InventoryPlayer inventoryPlayer, NVLEntityFFHelp tileEntity, NVLCommonFunctions newLogger) {
        super((Container)new NVLContainerHelp(inventoryPlayer, tileEntity, newLogger));
        this.field_147000_g = 256;
        this.field_146999_f = 256;
        this.e = tileEntity;
        this.logger = newLogger;
        this.loadRecipes();
    }

    private void logLine(String msg) {
        this.logger.logLine(((Object)((Object)this)).getClass().getSimpleName(), msg);
    }

    private void text(String s, int x, int y, int color) {
        this.func_73731_b(this.field_146289_q, I18n.func_74837_a((String)s, (Object[])new Object[0]), this.field_146294_l / 2 + x, y, color);
    }

    private void text(String s, String t, int x, int y, int color) {
        this.func_73731_b(this.field_146289_q, I18n.func_74837_a((String)s, (Object[])new Object[0]) + t, this.field_146294_l / 2 + x, y, color);
    }

    public void func_73866_w_() {
        int vcenter = this.field_146294_l / 2;
        this.field_147009_r = 0;
        this.field_147003_i = vcenter - 128;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, vcenter - 120, 20, 20, 12, "<-"));
        this.field_146292_n.add(new GuiButton(1, vcenter + 99, 20, 20, 12, "->"));
        this.field_146292_n.add(new GuiButton(2, vcenter - 30, 170, 20, 12, "<-"));
        this.field_146292_n.add(new GuiButton(3, vcenter - 30, 130, 20, 12, "->"));
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 0 && this.page > 0) {
            --this.page;
        }
        if (guibutton.field_146127_k == 1 && this.page < this.myrecipes.size() - 1) {
            ++this.page;
        }
        if (this.page != this.previouspage) {
            this.rindex = 0;
            this.prevrindex = -1;
            this.previouspage = this.page;
        }
        if (guibutton.field_146127_k == 2 && this.rindex > 0) {
            --this.rindex;
        }
        if (guibutton.field_146127_k == 3 && this.rindex < this.rcount - 1) {
            ++this.rindex;
        }
    }

    protected void func_146976_a(float arg0, int arg1, int arg2) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.bg);
        int wcenter = this.field_146294_l / 2;
        this.func_73729_b(wcenter - 128, 10, 0, 0, 256, 256);
        int objcount = this.myrecipes.size();
        if (objcount > 0) {
            if (this.page >= 0 && this.page < objcount) {
                String s1;
                String s;
                NVLRecipeItem or = this.myrecipes.get(this.page);
                this.rcount = or.getRecipeCount();
                if (this.rindex != this.prevrindex) {
                    this.e.setSlot(9, or.getTarget());
                    IRecipe r = or.getRecipe(this.rindex);
                    if (r instanceof IShapedRecipe) {
                        this.displayShapedRecipe(r);
                        this.recipeKind = "Shaped";
                    } else {
                        this.displayShapelessRecipe(r);
                        this.recipeKind = "Shapeless";
                    }
                    this.prevrindex = this.rindex;
                    ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = this.rcount > 1 && this.rindex > 0;
                    boolean bl = ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = this.rcount > 1 && this.rindex < this.rcount - 1;
                }
                if (!(s = or.getTarget().func_82833_r()).isEmpty()) {
                    this.func_73732_a(this.field_146289_q, s, wcenter, 23, 0xFFFF00);
                }
                if (!(s1 = I18n.func_74837_a((String)("HelpGui.Desc." + or.getTarget().func_77977_a().substring(5)), (Object[])new Object[0]).replace("\\n", "\n")).isEmpty()) {
                    this.field_146289_q.func_78279_b(s1, wcenter - 118, 40, 236, 0xFFFFFF);
                }
                if (this.rcount == 1) {
                    this.text("HelpGui.Recipe", -118, 145, 0xFFFFDD);
                } else {
                    this.text("HelpGui.Recipes", this.rindex + 1 + "/" + this.rcount, -118, 145, 0xFFFFDD);
                }
                this.text("HelpGui.RecipeKind." + this.recipeKind, -118, 155, 0xFFFFAA);
            }
            ((GuiButton)this.field_146292_n.get((int)0)).field_146125_m = objcount > 1 && this.page > 0;
            ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m = objcount > 1 && this.page < objcount - 1;
        }
    }

    private void clearSlots() {
        for (int i = 0; i < 9; ++i) {
            this.e.setSlot(i, ItemStack.field_190927_a);
        }
    }

    private void displayShapedRecipe(IRecipe r) {
        this.clearSlots();
        IShapedRecipe sh = (IShapedRecipe)r;
        int j = 0;
        for (Ingredient i : sh.func_192400_c()) {
            int tp = j / sh.getRecipeWidth() * 3 + j % sh.getRecipeWidth();
            this.e.setSlot(tp, i.func_193365_a().length > 0 ? i.func_193365_a()[0].func_77946_l() : ItemStack.field_190927_a);
            ++j;
        }
    }

    private void displayShapelessRecipe(IRecipe r) {
        this.clearSlots();
        if (r != null) {
            int j = 0;
            for (Object i : r.func_192400_c()) {
                this.e.setSlot(j++, ((Ingredient)i).func_193365_a().length > 0 ? ((Ingredient)i).func_193365_a()[0].func_77946_l() : ItemStack.field_190927_a);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }
}

