/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.guis;

import hu.nvl.nvlforcefields.guis.components.NVLGuiButton;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.FontRenderer;

public class NVLGuiListHelper {
    private final int BUTTONHEIGHT = 20;
    private final int LINEHEIGHT = 11;
    public int listStartX = 0;
    public int listStartY = 0;
    public NVLGuiButton upButton = null;
    public NVLGuiButton downButton = null;
    public String prefix = "";
    public int top = 0;
    public int left = 0;
    public int width = 0;
    public int height = 0;
    public ArrayList<String> userList = null;
    public int barPos = 0;
    public int startPos = 0;
    private int baseID = 0;
    private String selectedItem = "";

    public NVLGuiListHelper(int idBase, int newTop, int newLeft, int newWidth, int newHeight, String newPrefix) {
        this.width = newWidth;
        this.height = newHeight;
        this.prefix = newPrefix;
        this.left = newLeft;
        this.top = newTop;
        this.baseID = idBase;
        this.upButton = new NVLGuiButton(idBase, 0, 0, 14, 20, "^", newPrefix + "U");
        this.upButton.setTexture("nvl_widgets.png");
        this.downButton = new NVLGuiButton(idBase + 1, 0, 0, 14, 20, "v", newPrefix + "D");
        this.downButton.setTexture("nvl_widgets.png");
        this.userList = new ArrayList();
    }

    public void setButtonPos(int newLeft, int newTop) {
        this.upButton.field_146128_h = newLeft + this.width;
        this.upButton.field_146129_i = newTop;
        this.downButton.field_146128_h = newLeft + this.width;
        this.downButton.field_146129_i = newTop + this.height * 11 - 20;
    }

    public void setStartPos(int newLeft, int newTop) {
        this.left = newLeft;
        this.top = newTop;
    }

    public int getBarTop() {
        return this.top + this.barPos * 11;
    }

    public int getBarLeft() {
        return this.left;
    }

    public int getBarRight() {
        return this.left + this.width;
    }

    public int getBarBottom() {
        return this.top + (this.barPos + 1) * 11;
    }

    public int getMainTop() {
        return this.top;
    }

    public int getMainLeft() {
        return this.left;
    }

    public int getMainRight() {
        return this.left + this.width;
    }

    public int getMainBottom() {
        return this.top + this.height * 11;
    }

    public void drawItems(FontRenderer fr) {
        if (this.userList != null && this.userList != null && this.userList.size() > 0) {
            for (int i = 0; i < this.height; ++i) {
                if (this.startPos + i >= this.userList.size()) continue;
                fr.func_78276_b(this.userList.get(this.startPos + i), this.left + 2, this.top + i * 11 + 2, 0x77FFFF);
            }
        }
    }

    public void handleClick(int x, int y) {
        if (x > this.left && x < this.left + this.width && y > this.top && y < this.top + this.height * 11) {
            int tgt = (y - this.top) / 11;
            if (this.userList != null && tgt < this.userList.size()) {
                this.barPos = tgt;
            }
        }
        this.updateSelectedItem();
    }

    public void handleButtons(int id) {
        if (id == this.baseID && this.startPos > 0) {
            --this.startPos;
            this.updateSelectedItem();
        }
        if (id == this.baseID + 1 && this.userList != null && this.startPos + this.height < this.userList.size()) {
            ++this.startPos;
            this.updateSelectedItem();
        }
        this.setButtonStates();
    }

    private void updateSelectedItem() {
        this.selectedItem = "";
        if (this.barPos + this.startPos < this.userList.size()) {
            this.selectedItem = this.userList.get(this.barPos + this.startPos);
        }
    }

    public void importArray(String[] arr) {
        if (arr != null) {
            this.userList.clear();
            for (int i = 0; i < arr.length; ++i) {
                this.userList.add(arr[i]);
            }
            Collections.sort(this.userList);
        }
        this.setButtonStates();
        this.updateSelectedItem();
    }

    public void importArrayList(ArrayList<String> arr) {
        if (arr != null) {
            this.userList.clear();
            this.userList.addAll(arr);
            Collections.sort(this.userList);
        }
        this.setButtonStates();
        this.updateSelectedItem();
    }

    private void setButtonStates() {
        if (this.userList.size() <= this.height) {
            this.upButton.field_146124_l = false;
            this.downButton.field_146124_l = false;
            this.startPos = 0;
        } else {
            this.upButton.field_146124_l = this.startPos > 0;
            this.downButton.field_146124_l = this.startPos + this.height < this.userList.size();
        }
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }
}

