/*
 * Decompiled with CFR 0.152.
 */
package hu.nvl.nvlforcefields.registries;

import hu.nvl.nvlforcefields.blocks.NVLBlockFFDoorField;
import hu.nvl.nvlforcefields.blocks.NVLBlockFieldColumn;
import hu.nvl.nvlforcefields.blocks.NVLBlockFieldController;
import hu.nvl.nvlforcefields.blocks.NVLBlockFieldControllerSecure;
import hu.nvl.nvlforcefields.blocks.NVLBlockFieldDoor;
import hu.nvl.nvlforcefields.blocks.NVLBlockForceField;
import hu.nvl.nvlforcefields.blocks.NVLBlockHelp;
import hu.nvl.nvlforcefields.common.NVLBlock;
import hu.nvl.nvlforcefields.common.NVLBlockPane;
import hu.nvl.nvlforcefields.common.NVLCommonFunctions;
import hu.nvl.nvlforcefields.common.NVLItemBlock;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class NVLBlockRegistry {
    private NVLCommonFunctions logger;
    public static ArrayList<Block> REPLACEABLES = new ArrayList();
    public static ArrayList<NVLBlock> NVLBlockList = new ArrayList();
    public static ArrayList<NVLBlockPane> NVLBlockPaneList = new ArrayList();
    public static NVLBlockForceField NVLFFBlock;
    public static NVLBlockForceField NVLFFBlockSolid;
    public static NVLBlockFieldColumn NVLFFColumn;
    public static NVLBlockFieldController NVLFFController;
    public static NVLBlockFieldControllerSecure NVLFFControllerS;
    public static NVLBlockFieldDoor NVLFFDoor;
    public static NVLBlockHelp NVLHelp;

    public NVLBlockRegistry(NVLCommonFunctions common) {
        this.logger = common;
    }

    protected void logLine(String msg) {
        this.logger.logLine(this.getClass().getSimpleName(), msg);
    }

    public void Load() {
        NVLFFColumn = new NVLBlockFieldColumn(this.logger);
        NVLBlockList.add(NVLFFColumn);
        NVLFFController = new NVLBlockFieldController(this.logger);
        NVLBlockList.add(NVLFFController);
        NVLFFControllerS = new NVLBlockFieldControllerSecure(this.logger);
        NVLBlockList.add(NVLFFControllerS);
        NVLFFDoor = new NVLBlockFieldDoor(this.logger);
        NVLBlockList.add(NVLFFDoor);
        NVLHelp = new NVLBlockHelp(this.logger);
        NVLBlockList.add(NVLHelp);
        NVLFFBlock = new NVLBlockForceField(this.logger, 0);
        NVLBlockList.add(NVLFFBlock);
        NVLFFBlockSolid = new NVLBlockForceField(this.logger, 1);
        NVLBlockList.add(NVLFFBlockSolid);
        for (int i = 0; i < 32; ++i) {
            NVLBlockPaneList.add(new NVLBlockFFDoorField(this.logger, i));
        }
    }

    public void filleReplaceables() {
        Block b;
        REPLACEABLES.add(Blocks.field_150350_a);
        REPLACEABLES.add((Block)Blocks.field_150355_j);
        REPLACEABLES.add((Block)Blocks.field_150358_i);
        REPLACEABLES.add((Block)Blocks.field_150353_l);
        REPLACEABLES.add((Block)Blocks.field_150356_k);
        REPLACEABLES.add(Blocks.field_150432_aD);
        REPLACEABLES.add(Blocks.field_150403_cj);
        if (NVLCommonFunctions.isMODPresent("WarpDrive") && (b = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("WarpDrive", "blockAir"))) != null) {
            REPLACEABLES.add(b);
        }
    }

    public void registerBlocks(RegistryEvent.Register<Block> event, CreativeTabs tab) {
        for (NVLBlock nVLBlock : NVLBlockList) {
            if (tab != null && FMLCommonHandler.instance().getEffectiveSide().isClient() && nVLBlock.getRegisterCreativeTab()) {
                nVLBlock.func_149647_a(tab);
            }
            nVLBlock.setRegistryName(nVLBlock.getMyName());
            event.getRegistry().register((IForgeRegistryEntry)nVLBlock);
        }
        for (NVLBlockPane nVLBlockPane : NVLBlockPaneList) {
            if (tab != null && FMLCommonHandler.instance().getEffectiveSide().isClient() && nVLBlockPane.getRegisterCreativeTab()) {
                nVLBlockPane.func_149647_a(tab);
            }
            nVLBlockPane.setRegistryName(nVLBlockPane.getMyName());
            event.getRegistry().register((IForgeRegistryEntry)nVLBlockPane);
        }
    }

    public void registerItemBlocks(RegistryEvent.Register<Item> event, CreativeTabs tab) {
        NVLItemBlock ib;
        for (NVLBlock nVLBlock : NVLBlockList) {
            if (!nVLBlock.getRegisterItemBlock()) continue;
            ib = nVLBlock.myItemBlock;
            ib.setRegistryName(nVLBlock.getMyName());
            if (tab != null && FMLCommonHandler.instance().getEffectiveSide().isClient() && nVLBlock.getRegisterCreativeTab()) {
                ib.func_77637_a(tab);
            }
            event.getRegistry().register((IForgeRegistryEntry)ib);
        }
        for (NVLBlockPane nVLBlockPane : NVLBlockPaneList) {
            if (!nVLBlockPane.getRegisterItemBlock()) continue;
            ib = nVLBlockPane.myItemBlock;
            ib.setRegistryName(nVLBlockPane.getMyName());
            if (tab != null && FMLCommonHandler.instance().getEffectiveSide().isClient() && nVLBlockPane.getRegisterCreativeTab()) {
                ib.func_77637_a(tab);
            }
            event.getRegistry().register((IForgeRegistryEntry)ib);
        }
    }
}

