/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block.canvas;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.client.renderer.block.canvas.CanvasLayer;
import openblocks.client.renderer.block.canvas.CanvasTextureManager;
import openblocks.client.renderer.block.canvas.TextureOrientation;
import openblocks.client.renderer.item.stencil.StencilItemOverride;
import openblocks.client.renderer.item.stencil.StencilTextureManager;
import openblocks.common.IStencilPattern;
import org.apache.commons.lang3.tuple.Pair;

public class CanvasSideState {
    private final int background;
    private final List<CanvasLayer> layers;
    private final TextureOrientation layersOrientation;
    @Nullable
    private OrientedTexture layersTexture;
    private final Optional<IStencilPattern> cover;
    private final TextureOrientation coverOrientation;
    @Nullable
    private Optional<OrientedTexture> coverTexture;
    private final int hash;
    private int referenceCount = 0;
    private static final Map<CanvasSideState, CanvasSideState> canonicMap = Maps.newHashMap();

    private CanvasSideState(int background, List<CanvasLayer> layers, TextureOrientation layersOrientation, Optional<IStencilPattern> cover, TextureOrientation coverOrientation) {
        this.background = background;
        this.layers = ImmutableList.copyOf(layers);
        this.layersOrientation = layersOrientation;
        this.cover = cover;
        this.coverOrientation = coverOrientation;
        this.hash = this.hash();
    }

    private int hash() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Ints.hashCode((int)this.background);
        result = 31 * result + this.cover.hashCode();
        result = 31 * result + this.coverOrientation.hashCode();
        result = 31 * result + this.layers.hashCode();
        result = 31 * result + this.layersOrientation.hashCode();
        return result;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CanvasSideState) {
            CanvasSideState other = (CanvasSideState)obj;
            return this.background == other.background && this.coverOrientation == other.coverOrientation && this.cover.equals(other.cover) && this.layersOrientation == other.layersOrientation && this.layers.equals(other.layers);
        }
        return false;
    }

    public boolean isFullCover() {
        return this.background != 0;
    }

    public boolean hasStencils() {
        return this.isFullCover() || !this.layers.isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public OrientedTexture getLayersTexture() {
        if (this.layersTexture == null) {
            ResourceLocation textureLocation = CanvasTextureManager.INSTANCE.getTexture(this.background, this.layers);
            this.layersTexture = new OrientedTexture(textureLocation, this.layersOrientation);
        }
        return this.layersTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public Optional<OrientedTexture> getCoverTexture() {
        if (this.coverTexture == null) {
            if (this.cover.isPresent()) {
                IStencilPattern coverPattern = this.cover.get();
                ResourceLocation textureLocation = StencilTextureManager.INSTANCE.getStencilTextureLocation(StencilItemOverride.BACKGROUND_TEXTURE, coverPattern);
                this.coverTexture = Optional.of(new OrientedTexture(textureLocation, this.coverOrientation));
            } else {
                this.coverTexture = Optional.empty();
            }
        }
        return this.coverTexture;
    }

    public void onRender() {
        this.getLayersTexture();
    }

    public synchronized void acquire() {
        this.referenceCount = this.referenceCount <= 0 ? 1 : ++this.referenceCount;
    }

    public synchronized void release() {
        if (--this.referenceCount <= 0 && this.layersTexture != null) {
            CanvasTextureManager.INSTANCE.releaseTexture(this.background, this.layers);
            this.layersTexture = null;
        }
    }

    private static synchronized CanvasSideState getCanonic(CanvasSideState i) {
        CanvasSideState o = canonicMap.get(i);
        if (o == null) {
            canonicMap.put(i, i);
            o = i;
        }
        return o;
    }

    static void onTextureReload() {
        for (CanvasSideState k : canonicMap.keySet()) {
            k.clearTextures();
        }
    }

    private void clearTextures() {
        this.layersTexture = null;
        this.coverTexture = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.layers + (this.cover.isPresent() ? "+" + this.cover.toString() : "");
    }

    public static class Builder {
        private int background;
        private final List<CanvasLayer> layers = Lists.newArrayList();

        public Builder addLayer(IStencilPattern pattern, int color, TextureOrientation orientation) {
            this.layers.add(new CanvasLayer(pattern, color, orientation));
            return this;
        }

        public Builder withBackground(int background) {
            this.background = background;
            return this;
        }

        public CanvasSideState withCover(IStencilPattern cover, TextureOrientation rotation) {
            Pair<TextureOrientation, List<CanvasLayer>> layers = Builder.reorientLayers(this.layers);
            return CanvasSideState.getCanonic(new CanvasSideState(this.background, (List)layers.getRight(), (TextureOrientation)((Object)layers.getLeft()), Optional.of(cover), rotation));
        }

        public CanvasSideState withoutCover() {
            Pair<TextureOrientation, List<CanvasLayer>> layers = Builder.reorientLayers(this.layers);
            return CanvasSideState.getCanonic(new CanvasSideState(this.background, (List)layers.getRight(), (TextureOrientation)((Object)layers.getLeft()), Optional.empty(), TextureOrientation.R0));
        }

        private static Pair<TextureOrientation, List<CanvasLayer>> reorientLayers(List<CanvasLayer> layers) {
            if (layers.isEmpty()) {
                return Pair.of((Object)((Object)TextureOrientation.R0), layers);
            }
            TextureOrientation baseRotation = layers.get((int)0).orientation;
            ArrayList rotatedLayers = Lists.newArrayListWithCapacity((int)layers.size());
            for (CanvasLayer originalLayer : layers) {
                TextureOrientation newRotation = originalLayer.orientation.subtract(baseRotation);
                rotatedLayers.add(new CanvasLayer(originalLayer.pattern, originalLayer.color, newRotation));
            }
            return Pair.of((Object)((Object)baseRotation), (Object)rotatedLayers);
        }
    }

    public static class OrientedTexture {
        public final ResourceLocation location;
        public final TextureOrientation orientation;

        public OrientedTexture(ResourceLocation location, TextureOrientation orientation) {
            this.location = location;
            this.orientation = orientation;
        }
    }
}

