/*
 * Decompiled with CFR 0.152.
 */
package openblocks.integration;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import openblocks.Config;
import openblocks.common.entity.EntityMagnet;
import openblocks.integration.ITickingTurtle;
import openmods.entity.EntityBlock;
import openmods.fakeplayer.FakePlayerPool;
import openperipheral.api.adapter.IWorldProvider;
import openperipheral.api.adapter.method.Alias;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.IMultiReturn;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.api.architecture.IAttachable;
import openperipheral.api.helpers.MultiReturn;
import openperipheral.api.peripheral.ExposeInterface;
import openperipheral.api.peripheral.PeripheralTypeId;

@PeripheralTypeId(value="openblocks_magnet")
@ExposeInterface(value={ITickingTurtle.class, IAttachable.class})
public class MagnetControlAdapter
implements ITickingTurtle,
IWorldProvider,
IAttachable {
    private final TurtleSide side;
    private final ITurtleAccess turtle;
    private boolean isAttached;
    private WeakReference<EntityMagnet> magnet = new WeakReference<Object>(null);
    private Owner magnetOwner;
    private int fuelTick = 0;

    public MagnetControlAdapter(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
    }

    public World getWorld() {
        return this.turtle.getWorld();
    }

    protected boolean consumeFuel(int amount) {
        return this.turtle.consumeFuel(amount);
    }

    @ScriptCallable(description="Activate magnet")
    public void activate() {
        EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
        Preconditions.checkState((magnet == null || magnet.field_70128_L ? 1 : 0) != 0, (Object)"Magnet already active");
        World world = this.getWorld();
        Preconditions.checkNotNull((Object)world, (Object)"Trying to spawn magnet, but turtle is unloaded");
        Preconditions.checkState((boolean)this.canSpawn(world), (Object)"Can't deploy magnet");
        Preconditions.checkState((boolean)this.consumeFuel(5), (Object)"No fuel");
        this.magnetOwner = new Owner();
        this.magnetOwner.setTargetPosition(0.0, this.side == TurtleSide.Left ? -1.0 : 1.0, 0.0);
        magnet = new EntityMagnet(world, this.magnetOwner, true);
        world.func_72838_d((Entity)magnet);
        magnet.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        this.magnet = new WeakReference<EntityMagnet>(magnet);
    }

    @ScriptCallable(description="Deactive magnet")
    public void deactivate() {
        this.despawnMagnet(true);
    }

    @ScriptCallable(description="Set target for magnet")
    public void setTarget(@Arg(name="x") double x, @Arg(name="y") double y, @Arg(name="z") double z) {
        Preconditions.checkNotNull((Object)this.magnetOwner, (Object)"Magnet not active");
        Preconditions.checkArgument((boolean)MagnetControlAdapter.checkTargetRange(x, y, z), (Object)"Target out of range");
        this.magnetOwner.setTargetPosition(x, y, z);
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER, ReturnType.NUMBER, ReturnType.NUMBER}, description="Get turtle position")
    public IMultiReturn getPosition() {
        EntityMagnet magnet = this.getMagnet();
        Vec3d rotated = this.getRelativeDistance(magnet);
        return MultiReturn.wrap((Object[])new Object[]{rotated.field_72450_a, rotated.field_72448_b, rotated.field_72449_c});
    }

    @ScriptCallable(returnTypes={ReturnType.BOOLEAN}, description="Is magnet above grabbable entity")
    public boolean isAboveEntity() {
        return this.getMagnet().isAboveTarget();
    }

    @Alias(value={"toggle"})
    @ScriptCallable(returnTypes={ReturnType.BOOLEAN}, description="Grab or release entity/block under magnet")
    public boolean toggleMagnet() {
        return this.getMagnet().toggleMagnet();
    }

    @ScriptCallable(returnTypes={ReturnType.BOOLEAN}, description="Is magnet currently grabbing block or entity")
    public boolean isGrabbing() {
        return this.getMagnet().isLocked();
    }

    @Alias(value={"distance"})
    @ScriptCallable(returnTypes={ReturnType.NUMBER, ReturnType.NUMBER, ReturnType.NUMBER})
    public IMultiReturn getDistanceToTarget() {
        EntityMagnet magnet = this.getMagnet();
        Vec3d current = this.getRelativeDistance(magnet);
        Vec3d target = this.magnetOwner.target;
        return MultiReturn.wrap((Object[])new Object[]{current.field_72450_a - target.field_72450_a, current.field_72448_b - target.field_72448_b, current.field_72449_c - target.field_72449_c});
    }

    @Override
    public void onPeripheralTick() {
        EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
        if (magnet != null && !magnet.field_70128_L && this.isAttached && ++this.fuelTick >= 20) {
            int fuel;
            this.fuelTick = 0;
            int n = fuel = magnet.isLocked() ? 2 : 1;
            if (!this.consumeFuel(fuel)) {
                this.despawnMagnet(false);
            }
        }
    }

    private static boolean checkTargetRange(double x, double y, double z) {
        return Math.abs(x) <= Config.turtleMagnetRange && Math.abs(y) <= Config.turtleMagnetRange && Math.abs(z) <= Config.turtleMagnetRange;
    }

    private Vec3d getRelativeDistance(EntityMagnet magnet) {
        Vec3d magnetPos = new Vec3d(magnet.field_70165_t, magnet.field_70163_u, magnet.field_70161_v);
        Vec3d turtlePos = new Vec3d((Vec3i)this.turtle.getPosition()).func_72441_c(0.5, 0.5, 0.5);
        Vec3d dist = turtlePos.func_178788_d(magnetPos);
        EnumFacing side = this.turtle.getDirection();
        switch (side) {
            case NORTH: {
                return new Vec3d(-dist.field_72449_c, dist.field_72448_b, dist.field_72450_a);
            }
            case SOUTH: {
                return new Vec3d(dist.field_72449_c, dist.field_72448_b, -dist.field_72450_a);
            }
            case EAST: {
                return new Vec3d(dist.field_72450_a, dist.field_72448_b, dist.field_72449_c);
            }
            case WEST: {
                return new Vec3d(-dist.field_72450_a, dist.field_72448_b, -dist.field_72449_c);
            }
        }
        return dist;
    }

    private boolean canSpawn(World world) {
        EnumFacing facing = this.turtle.getDirection();
        EnumFacing spawnSide = this.side == TurtleSide.Left ? facing.func_176735_f() : facing.func_176746_e();
        BlockPos spawnPos = this.turtle.getPosition().func_177972_a(spawnSide);
        return world.func_175623_d(spawnPos);
    }

    private EntityMagnet getMagnet() {
        EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
        Preconditions.checkState((magnet != null && !magnet.field_70128_L ? 1 : 0) != 0, (Object)"Magnet not active");
        return magnet;
    }

    private void despawnMagnet(boolean checkPosition) {
        EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
        Preconditions.checkNotNull((Object)((Object)magnet), (Object)"Magnet not active");
        Vec3d magnetPos = new Vec3d(magnet.field_70165_t, magnet.field_70163_u, magnet.field_70161_v);
        Vec3d turtlePos = new Vec3d((Vec3i)this.turtle.getPosition()).func_72441_c(0.5, 0.5, 0.5);
        Preconditions.checkState((!checkPosition || MagnetControlAdapter.canOperateOnMagnet(magnetPos, turtlePos) ? 1 : 0) != 0, (Object)"Magnet too far");
        magnet.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        magnet.func_70106_y();
        this.magnet.clear();
        this.magnetOwner = null;
    }

    private static boolean canOperateOnMagnet(Vec3d magnetPos, Vec3d turtlePos) {
        return magnetPos.func_72436_e(turtlePos) <= Config.turtleMagnetRangeDeactivate * Config.turtleMagnetRangeDeactivate;
    }

    public boolean isValid() {
        return this.turtle != null && this.turtle.getWorld() != null && this.isAttached;
    }

    public void addComputer(IArchitectureAccess computer) {
        this.isAttached = true;
    }

    public void removeComputer(IArchitectureAccess computer) {
        this.isAttached = false;
    }

    public class Owner
    implements EntityMagnet.IOwner {
        private Vec3d target = new Vec3d(0.0, 0.0, 0.0);

        public synchronized void setTargetPosition(double x, double y, double z) {
            this.target = new Vec3d(x, y, z);
        }

        public synchronized Vec3d getTarget(Vec3d pos, EnumFacing side) {
            double x = pos.field_72450_a + 0.5;
            double y = pos.field_72448_b + 0.5;
            double z = pos.field_72449_c + 0.5;
            y += this.target.field_72450_a;
            switch (side) {
                case NORTH: {
                    x += this.target.field_72449_c;
                    z -= this.target.field_72450_a;
                    break;
                }
                case SOUTH: {
                    x -= this.target.field_72449_c;
                    z += this.target.field_72450_a;
                    break;
                }
                case WEST: {
                    x -= this.target.field_72450_a;
                    z -= this.target.field_72449_c;
                    break;
                }
                case EAST: {
                    x += this.target.field_72450_a;
                    z += this.target.field_72449_c;
                    break;
                }
            }
            return new Vec3d(x, y, z);
        }

        @Override
        public boolean isValid(EntityMagnet magnet) {
            return MagnetControlAdapter.this.turtle != null && MagnetControlAdapter.this.turtle.getWorld() != null && MagnetControlAdapter.this.isAttached;
        }

        @Override
        public Vec3d getTarget() {
            return this.getTarget(new Vec3d((Vec3i)MagnetControlAdapter.this.turtle.getPosition()), MagnetControlAdapter.this.turtle.getDirection());
        }

        @Override
        public EntityBlock createByPlayer(EntityMagnet.IEntityBlockFactory factory) {
            World world = MagnetControlAdapter.this.turtle.getWorld();
            if (world instanceof WorldServer) {
                return (EntityBlock)FakePlayerPool.instance.executeOnPlayer((WorldServer)world, factory::create);
            }
            return null;
        }
    }
}

