/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.common.registry;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.icannt.netherendingores.client.block.itemblock.ItemBlockBasic;
import org.icannt.netherendingores.client.block.itemblock.ItemBlockOreEndModded1;
import org.icannt.netherendingores.client.block.itemblock.ItemBlockOreEndModded2;
import org.icannt.netherendingores.client.block.itemblock.ItemBlockOreEndVanilla;
import org.icannt.netherendingores.client.block.itemblock.ItemBlockOreNetherModded1;
import org.icannt.netherendingores.client.block.itemblock.ItemBlockOreNetherModded2;
import org.icannt.netherendingores.client.block.itemblock.ItemBlockOreNetherVanilla;
import org.icannt.netherendingores.client.block.itemblock.ItemBlockOreOther1;
import org.icannt.netherendingores.common.block.blocks.BlockCreativeTab;
import org.icannt.netherendingores.common.block.blocks.BlockMonsterEndEndermite;
import org.icannt.netherendingores.common.block.blocks.BlockMonsterNetherNetherfish;
import org.icannt.netherendingores.common.block.blocks.BlockOreEndModded1;
import org.icannt.netherendingores.common.block.blocks.BlockOreEndModded2;
import org.icannt.netherendingores.common.block.blocks.BlockOreEndVanilla;
import org.icannt.netherendingores.common.block.blocks.BlockOreNetherModded1;
import org.icannt.netherendingores.common.block.blocks.BlockOreNetherModded2;
import org.icannt.netherendingores.common.block.blocks.BlockOreNetherVanilla;
import org.icannt.netherendingores.common.block.blocks.BlockOreOther1;
import org.icannt.netherendingores.common.registry.BlockData;
import org.icannt.netherendingores.common.registry.OreDictionaryRegistry;
import org.icannt.netherendingores.lib.Config;
import org.icannt.netherendingores.lib.Log;

@GameRegistry.ObjectHolder(value="netherendingores")
public class BlockRegistry {
    @GameRegistry.ObjectHolder(value="creative_tab")
    public static final BlockCreativeTab CREATIVE_TAB = new BlockCreativeTab();
    @GameRegistry.ObjectHolder(value="block_end_endermite")
    public static final BlockMonsterEndEndermite BLOCK_END_ENDERMITE = new BlockMonsterEndEndermite();
    @GameRegistry.ObjectHolder(value="block_nether_netherfish")
    public static final BlockMonsterNetherNetherfish BLOCK_NETHER_NETHERFISH = new BlockMonsterNetherNetherfish();
    @GameRegistry.ObjectHolder(value="ore_end_modded_1")
    public static final BlockOreEndModded1 ORE_END_MODDED_1 = new BlockOreEndModded1();
    @GameRegistry.ObjectHolder(value="ore_end_modded_2")
    public static final BlockOreEndModded2 ORE_END_MODDED_2 = new BlockOreEndModded2();
    @GameRegistry.ObjectHolder(value="ore_end_vanilla")
    public static final BlockOreEndVanilla ORE_END_VANILLA = new BlockOreEndVanilla();
    @GameRegistry.ObjectHolder(value="ore_nether_modded_1")
    public static final BlockOreNetherModded1 ORE_NETHER_MODDED_1 = new BlockOreNetherModded1();
    @GameRegistry.ObjectHolder(value="ore_nether_modded_2")
    public static final BlockOreNetherModded2 ORE_NETHER_MODDED_2 = new BlockOreNetherModded2();
    @GameRegistry.ObjectHolder(value="ore_nether_vanilla")
    public static final BlockOreNetherVanilla ORE_NETHER_VANILLA = new BlockOreNetherVanilla();
    @GameRegistry.ObjectHolder(value="ore_other_1")
    public static final BlockOreOther1 ORE_OTHER_1 = new BlockOreOther1();
    private static final Block[] blocks = new Block[]{CREATIVE_TAB, BLOCK_END_ENDERMITE, BLOCK_NETHER_NETHERFISH, ORE_END_MODDED_1, ORE_END_MODDED_2, ORE_END_VANILLA, ORE_NETHER_MODDED_1, ORE_NETHER_MODDED_2, ORE_NETHER_VANILLA, ORE_OTHER_1};
    private static final Block[] oreBlocks = new Block[]{ORE_END_MODDED_1, ORE_END_MODDED_2, ORE_END_VANILLA, ORE_NETHER_MODDED_1, ORE_NETHER_MODDED_2, ORE_NETHER_VANILLA, ORE_OTHER_1};
    private static final ItemBlock[] itemBlocks = new ItemBlock[]{new ItemBlockBasic(CREATIVE_TAB), new ItemBlockBasic(BLOCK_END_ENDERMITE), new ItemBlockBasic(BLOCK_NETHER_NETHERFISH), new ItemBlockOreEndModded1(ORE_END_MODDED_1), new ItemBlockOreEndModded2(ORE_END_MODDED_2), new ItemBlockOreEndVanilla(ORE_END_VANILLA), new ItemBlockOreNetherModded1(ORE_NETHER_MODDED_1), new ItemBlockOreNetherModded2(ORE_NETHER_MODDED_2), new ItemBlockOreNetherVanilla(ORE_NETHER_VANILLA), new ItemBlockOreOther1(ORE_OTHER_1)};

    private static void angerPigmen(World world, BlockPos blockPos, EntityPlayer player) {
        BlockPos start = new BlockPos((Vec3i)blockPos).func_177982_a(-Config.zombiePigmanAngerRangeRadius, -Config.zombiePigmanAngerRangeHeight, -Config.zombiePigmanAngerRangeRadius);
        BlockPos end = new BlockPos((Vec3i)blockPos).func_177982_a(Config.zombiePigmanAngerRangeRadius, Config.zombiePigmanAngerRangeHeight, Config.zombiePigmanAngerRangeRadius);
        AxisAlignedBB aabb = new AxisAlignedBB(start, end);
        List list = world.func_72872_a(EntityPigZombie.class, aabb);
        for (EntityPigZombie pigman : list) {
            pigman.func_70604_c((EntityLivingBase)player);
        }
    }

    private static boolean hasEnchant(EntityPlayer player, Enchantment enchant) {
        if (player == null || player.func_184614_ca().func_190926_b()) {
            return false;
        }
        NBTTagList list = player.func_184614_ca().func_77986_q();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            short enchantId = list.func_150305_b(i).func_74765_d("id");
            if (Enchantment.func_185262_c((int)enchantId) != enchant) continue;
            return true;
        }
        return false;
    }

    private static short getEnchantLevel(EntityPlayer player, Enchantment enchant) {
        if (player == null || player.func_184614_ca().func_190926_b()) {
            return 0;
        }
        NBTTagList list = player.func_184614_ca().func_77986_q();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            short enchantId = list.func_150305_b(i).func_74765_d("id");
            short enchantLvl = list.func_150305_b(i).func_74765_d("lvl");
            if (Enchantment.func_185262_c((int)enchantId) != enchant) continue;
            return enchantLvl;
        }
        return 0;
    }

    private static boolean isAngeringOre(IBlockState blockState) {
        for (Block block : oreBlocks) {
            if (blockState.func_177230_c() != block) continue;
            return true;
        }
        return false;
    }

    private static int getBlockDataOrdinal(IBlockState blockState) {
        for (Block block : oreBlocks) {
            if (blockState.func_177230_c() != block) continue;
            for (BlockData blockData : BlockData.values()) {
                if (blockData.getModBlock() != blockState.func_177230_c() || blockData.getBlockMeta() != blockState.func_177230_c().func_176201_c(blockState)) continue;
                return blockData.ordinal();
            }
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public static void initModels() {
        CREATIVE_TAB.initItemBlockModels();
        BLOCK_END_ENDERMITE.initItemBlockModels();
        BLOCK_NETHER_NETHERFISH.initItemBlockModels();
        for (BlockData blockData : BlockData.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)blockData.getModBlockItem(), (int)blockData.getBlockMeta(), (ModelResourceLocation)new ModelResourceLocation(blockData.getModBlockItem().getRegistryName(), "blocks=" + blockData.getModBlockStateNameValue()));
        }
    }

    @Mod.EventBusSubscriber
    public static class BlockEventHandler {
        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            EntityPlayer player = event.getPlayer();
            if (!player.func_184812_l_()) {
                int blockDataOrdinal;
                boolean silktouch = BlockRegistry.hasEnchant(player, Enchantments.field_185306_r);
                World world = event.getWorld();
                BlockPos blockPos = event.getPos();
                IBlockState blockState = event.getState();
                if (Config.zombiePigmanAnger && BlockRegistry.isAngeringOre(blockState) && (!silktouch || !Config.zombiePigmanAngerSilkTouch)) {
                    BlockRegistry.angerPigmen(world, blockPos, player);
                }
                if ((!silktouch || !Config.oreExplosionSilkTouch) && Config.oreExplosion && (blockDataOrdinal = BlockRegistry.getBlockDataOrdinal(blockState)) > -1 && BlockData.values()[blockDataOrdinal].getOreExplosion()) {
                    double randExplodeChance;
                    double fortuneMulti = 1.0;
                    if (Config.oreExplosionFortune && Config.dropItems && BlockData.values()[blockDataOrdinal].getDropItems()) {
                        boolean fortune = BlockRegistry.hasEnchant(player, Enchantments.field_185308_t);
                        short fortuneLevel = BlockRegistry.getEnchantLevel(player, Enchantments.field_185308_t);
                        double d = fortuneMulti = Config.oreExplosionFortune && fortune ? 1.0 + 0.1 * (double)fortuneLevel * (double)fortuneLevel : 1.0;
                    }
                    if ((randExplodeChance = world.field_73012_v.nextDouble()) <= Config.oreExplosionChance * fortuneMulti) {
                        world.func_72876_a((Entity)player, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), (float)Config.oreExplosionStrength, true);
                    }
                }
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        public static final Set<ItemBlock> ITEM_BLOCKS = new HashSet<ItemBlock>();

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            Log.debug("Registering Blocks");
            IForgeRegistry registry = event.getRegistry();
            registry.registerAll((IForgeRegistryEntry[])blocks);
            Log.info("Registered Blocks");
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            Log.debug("Registering ItemBlocks");
            IForgeRegistry registry = event.getRegistry();
            for (ItemBlock iB : itemBlocks) {
                registry.register(iB.setRegistryName(iB.func_179223_d().getRegistryName()));
                ITEM_BLOCKS.add(iB);
            }
            Log.info("Registered ItemBlocks");
        }

        @SubscribeEvent
        public static void registerBiome(RegistryEvent.Register<Biome> event) {
            OreDictionaryRegistry.registerDictionaryOres();
        }
    }
}

