/*
 * Decompiled with CFR 0.152.
 */
package org.icannt.netherendingores.common.registry;

import org.icannt.netherendingores.common.registry.BlockData;
import org.icannt.netherendingores.common.registry.RecipeRegistry;
import org.icannt.netherendingores.lib.IntegrationReflector;
import org.icannt.netherendingores.lib.Log;

public class RecipeHelper {
    public static void tryRecipe(BlockData blockData, String device, boolean doAltReplace) {
        String[] materials = new String[]{blockData.func_176610_l()};
        if (doAltReplace) {
            materials = blockData.getItemAltOreDictSuffix();
        }
        for (String material : materials) {
            if (doAltReplace) {
                material = blockData.getAltMaterialName(material);
            }
            try {
                RecipeHelper.addRecipe(blockData, device, material);
                if (Log.isRecipeAddedAlready) {
                    Log.isRecipeAddedAlready = false;
                    Log.logRecipeAlreadyAdded();
                    continue;
                }
                Log.logRecipeSuccess();
            }
            catch (Exception e1) {
                Log.logRecipeFail();
            }
        }
    }

    private static void addRecipe(BlockData blockData, String device, String material) {
        switch (device) {
            case "craft": {
                RecipeRegistry.addCraftingRecipe(blockData, material);
                break;
            }
            case "furnace": {
                RecipeRegistry.addFurnaceRecipe(blockData, material);
                break;
            }
            default: {
                IntegrationReflector.integration.addIntegrationRecipe(blockData, device, material);
            }
        }
    }
}

