/*
 * Decompiled with CFR 0.152.
 */
package com.animania.api.rendering;

import com.animania.client.models.render.ModelRendererAnimania;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class ModelPose {
    private final Map<String, PartData> originalPose = new HashMap<String, PartData>();
    private final Map<String, PartData> modelPose = new HashMap<String, PartData>();
    private final Set<Field> originalFields = new HashSet<Field>();
    private final ModelBase originalModel;
    private float poseStartTime = 0.0f;
    private float originalStartTime = 0.0f;

    public ModelPose(ModelBase original, ModelBase pose) {
        this.originalModel = original;
        try {
            ModelRenderer mr;
            Field[] fields;
            for (Field f : fields = original.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                if (!f.getType().isAssignableFrom(ModelRendererAnimania.class)) continue;
                this.originalFields.add(f);
                mr = (ModelRenderer)f.get(original);
                this.originalPose.put(f.getName(), new PartData(mr.field_78800_c, mr.field_78797_d, mr.field_78798_e, mr.field_78795_f, mr.field_78796_g, mr.field_78808_h, mr.field_78807_k, mr.field_82906_o, mr.field_82908_p, mr.field_82907_q));
            }
            for (Field f : fields = pose.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                if (!f.getType().isAssignableFrom(ModelRendererAnimania.class)) continue;
                mr = (ModelRenderer)f.get(pose);
                this.modelPose.put(f.getName(), new PartData(mr.field_78800_c, mr.field_78797_d, mr.field_78798_e, mr.field_78795_f, mr.field_78796_g, mr.field_78808_h, mr.field_78807_k, mr.field_82906_o, mr.field_82908_p, mr.field_82907_q));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void transitionToPose(float totalAnimateTime, float passedTime) {
        float slide;
        if (this.originalStartTime != 0.0f) {
            this.originalStartTime = 0.0f;
        }
        if (this.poseStartTime == 0.0f) {
            this.poseStartTime = passedTime;
        }
        float f = slide = totalAnimateTime <= 0.0f ? 1.0f : (passedTime - this.poseStartTime) / totalAnimateTime;
        if (slide >= 1.0f) {
            slide = 1.0f;
        }
        try {
            for (Field f2 : this.originalFields) {
                if (!this.modelPose.containsKey(f2.getName())) continue;
                ModelRenderer mr = (ModelRenderer)f2.get(this.originalModel);
                PartData data = this.modelPose.get(f2.getName());
                PartData orig = this.originalPose.get(f2.getName());
                mr.field_78800_c = (float)MathHelper.func_151238_b((double)orig.rotationPointX, (double)data.rotationPointX, (double)slide);
                mr.field_78797_d = (float)MathHelper.func_151238_b((double)orig.rotationPointY, (double)data.rotationPointY, (double)slide);
                mr.field_78798_e = (float)MathHelper.func_151238_b((double)orig.rotationPointZ, (double)data.rotationPointZ, (double)slide);
                mr.field_78795_f = this.lerpRotation(orig.rotateAngleX, data.rotateAngleX, slide);
                mr.field_78796_g = this.lerpRotation(orig.rotateAngleY, data.rotateAngleY, slide);
                mr.field_78808_h = this.lerpRotation(orig.rotateAngleZ, data.rotateAngleZ, slide);
                mr.field_78807_k = data.isHidden;
                mr.field_82906_o = (float)MathHelper.func_151238_b((double)orig.offsetX, (double)data.offsetX, (double)slide);
                mr.field_82908_p = (float)MathHelper.func_151238_b((double)orig.offsetY, (double)data.offsetY, (double)slide);
                mr.field_82907_q = (float)MathHelper.func_151238_b((double)orig.offsetZ, (double)data.offsetZ, (double)slide);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void transitionToNormal(float totalAnimateTime, float passedTime) {
        float slide;
        if (this.poseStartTime != 0.0f) {
            this.poseStartTime = 0.0f;
        }
        if (this.originalStartTime == 0.0f) {
            this.originalStartTime = passedTime;
        }
        float f = slide = totalAnimateTime <= 0.0f ? 1.0f : (passedTime - this.originalStartTime) / totalAnimateTime;
        if (slide >= 1.0f) {
            slide = 1.0f;
        }
        try {
            for (Field f2 : this.originalFields) {
                if (!this.modelPose.containsKey(f2.getName())) continue;
                ModelRenderer mr = (ModelRenderer)f2.get(this.originalModel);
                PartData orig = this.modelPose.get(f2.getName());
                PartData data = this.originalPose.get(f2.getName());
                mr.field_78800_c = (float)MathHelper.func_151238_b((double)orig.rotationPointX, (double)data.rotationPointX, (double)slide);
                mr.field_78797_d = (float)MathHelper.func_151238_b((double)orig.rotationPointY, (double)data.rotationPointY, (double)slide);
                mr.field_78798_e = (float)MathHelper.func_151238_b((double)orig.rotationPointZ, (double)data.rotationPointZ, (double)slide);
                mr.field_78795_f = this.lerpRotation(orig.rotateAngleX, data.rotateAngleX, slide);
                mr.field_78796_g = this.lerpRotation(orig.rotateAngleY, data.rotateAngleY, slide);
                mr.field_78808_h = this.lerpRotation(orig.rotateAngleZ, data.rotateAngleZ, slide);
                mr.field_78807_k = data.isHidden;
                mr.field_82906_o = (float)MathHelper.func_151238_b((double)orig.offsetX, (double)data.offsetX, (double)slide);
                mr.field_82908_p = (float)MathHelper.func_151238_b((double)orig.offsetY, (double)data.offsetY, (double)slide);
                mr.field_82907_q = (float)MathHelper.func_151238_b((double)orig.offsetZ, (double)data.offsetZ, (double)slide);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private float lerpRotation(float from, float to, float slide) {
        double mul = 57.29577951308232;
        double fromdeg = (double)from * mul % 180.0 + 180.0;
        double todeg = (double)to * mul % 180.0 + 180.0;
        if ((double)from == -6.079215658816017) {
            System.out.println("s");
        }
        double lerped = MathHelper.func_151238_b((double)fromdeg, (double)todeg, (double)slide) - 180.0;
        return (float)(lerped / mul);
    }

    private static class PartData {
        private final float rotationPointX;
        private final float rotationPointY;
        private final float rotationPointZ;
        private final float rotateAngleX;
        private final float rotateAngleY;
        private final float rotateAngleZ;
        private final boolean isHidden;
        private final float offsetX;
        private final float offsetY;
        private final float offsetZ;

        public PartData(float rotationPointX, float rotationPointY, float rotationPointZ, float rotateAngleX, float rotateAngleY, float rotateAngleZ, boolean isHidden, float offsetX, float offsetY, float offsetZ) {
            this.rotationPointX = rotationPointX;
            this.rotationPointY = rotationPointY;
            this.rotationPointZ = rotationPointZ;
            this.rotateAngleX = rotateAngleX;
            this.rotateAngleY = rotateAngleY;
            this.rotateAngleZ = rotateAngleZ;
            this.isHidden = isHidden;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }
    }
}

