/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.advancements.criterion;

import com.animania.api.interfaces.IFoodEating;
import com.animania.common.helper.AnimaniaHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class FeedAnimalTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("animania", "feed_animal");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners consumeitemtrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (consumeitemtrigger$listeners == null) {
            consumeitemtrigger$listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, consumeitemtrigger$listeners);
        }
        consumeitemtrigger$listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners consumeitemtrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (consumeitemtrigger$listeners != null) {
            consumeitemtrigger$listeners.remove(listener);
            if (consumeitemtrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        ItemStack item = ItemStack.field_190927_a;
        EntityEntry entity = null;
        boolean useOptional = false;
        ResourceLocation entityloc = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"entity"));
        if (json.has("itemstack")) {
            item = AnimaniaHelper.getItemStack(JsonUtils.func_152754_s((JsonObject)json, (String)"itemstack"));
            if (item.func_190926_b()) {
                throw new JsonSyntaxException("Item cannot be air '" + JsonUtils.func_152754_s((JsonObject)json, (String)"item").toString() + "'");
            }
        } else if (json.has("optional")) {
            try {
                item = AnimaniaHelper.getItemStack(JsonUtils.func_152754_s((JsonObject)json, (String)"optional"));
            }
            catch (Exception e) {
                item = ItemStack.field_190927_a;
            }
            useOptional = true;
        }
        if (!ForgeRegistries.ENTITIES.containsKey(entityloc)) {
            throw new JsonSyntaxException("Unknown entity '" + entityloc + "'");
        }
        entity = (EntityEntry)ForgeRegistries.ENTITIES.getValue(entityloc);
        return new Instance(item, entity, useOptional);
    }

    public void trigger(EntityPlayerMP player, ItemStack item, EntityEntry entry, Entity entity) {
        Listeners enterblocktrigger$listeners = this.listeners.get(player.func_192039_O());
        if (enterblocktrigger$listeners != null) {
            enterblocktrigger$listeners.trigger(item, entry, entity);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ItemStack item, EntityEntry entry, Entity entity) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(item, entry, entity)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final ItemStack item;
        private final EntityEntry entity;
        private final boolean optional;

        public Instance(@Nonnull ItemStack item, @Nullable EntityEntry entity, boolean useOptional) {
            super(ID);
            this.item = item;
            this.entity = entity;
            this.optional = useOptional;
        }

        public boolean test(ItemStack item, EntityEntry entry, Entity entity) {
            if (this.item.func_190926_b() && this.optional) {
                return false;
            }
            if (this.item.func_190926_b()) {
                if (entity instanceof IFoodEating && entry == this.entity) {
                    Set<ItemStack> food = ((IFoodEating)entity).getFoodItems();
                    for (ItemStack is : food) {
                        if (!ItemStack.func_179545_c((ItemStack)is, (ItemStack)item)) continue;
                        return true;
                    }
                }
                return false;
            }
            if (item != null && this.item != null) {
                ItemStack s1 = this.item.func_77946_l();
                ItemStack s2 = item.func_77946_l();
                s1.func_190920_e(1);
                s2.func_190920_e(1);
                boolean equal = ItemStack.func_77989_b((ItemStack)s1, (ItemStack)s2);
                if (this.entity != null && equal && entry == this.entity) {
                    return true;
                }
            }
            return false;
        }
    }
}

