/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.blocks;

import com.animania.Animania;
import com.animania.common.blocks.AnimaniaBlock;
import com.animania.common.items.ItemSaltLick;
import com.animania.common.tileentities.TileEntitySaltLick;
import com.animania.config.AnimaniaConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockSaltLick
extends AnimaniaBlock
implements ITileEntityProvider {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.25, 0.8125);

    public BlockSaltLick() {
        super("salt_lick", Material.field_151576_e, MapColor.field_151666_j, false);
        this.func_149647_a(Animania.TabAnimaniaResources);
        this.func_149711_c(1.2f);
        this.func_149752_b(1.7f);
        this.field_149758_A = true;
        ItemSaltLick item = new ItemSaltLick(this);
        item.setRegistryName(new ResourceLocation("animania", "salt_lick"));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    public void useSaltLick(World world, BlockPos pos, @Nullable EntityLivingBase entity) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntitySaltLick) {
            ((TileEntitySaltLick)te).useSaltLick();
            if (entity != null) {
                entity.func_70691_i(2.0f);
                te.func_70296_d();
            }
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (te != null && te instanceof TileEntitySaltLick) {
            int left = ((TileEntitySaltLick)te).usesLeft;
            int damage = AnimaniaConfig.careAndFeeding.saltLickMaxUses - left;
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, 1, damage));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int left = AnimaniaConfig.careAndFeeding.saltLickMaxUses - stack.func_77952_i();
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntitySaltLick) {
            ((TileEntitySaltLick)te).usesLeft = left;
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        if (world != null && (te = world.func_175625_s(pos)) != null && te instanceof TileEntitySaltLick) {
            double usesLeft = (double)((TileEntitySaltLick)te).usesLeft / (double)AnimaniaConfig.careAndFeeding.saltLickMaxUses;
            return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.625 * usesLeft, 0.8125);
        }
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        if (world != null && (te = world.func_175625_s(pos)) != null && te instanceof TileEntitySaltLick) {
            double usesLeft = (double)((TileEntitySaltLick)te).usesLeft / (double)AnimaniaConfig.careAndFeeding.saltLickMaxUses;
            return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.625 * usesLeft, 0.8125);
        }
        return AABB;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149716_u() {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySaltLick();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }
}

