/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.generic.ai;

import com.animania.api.interfaces.ISleeping;
import com.animania.common.entities.generic.ai.GenericAISearchBlock;
import com.animania.config.AnimaniaConfig;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GenericAISleep<T extends EntityCreature>
extends GenericAISearchBlock {
    private final T entity;
    private int delay;
    private Block bedBlock;
    private Block bedBlock2;
    private Function<Long, Boolean> shouldSleep;

    public GenericAISleep(T entity, double speedIn, Block bed1, Block bed2, Class parentClass) {
        this(entity, speedIn, bed1, bed2, parentClass, (Long worldtime) -> worldtime >= 13000L);
    }

    public GenericAISleep(T entity, double speedIn, Block bed1, Block bed2, Class parentClass, Function<Long, Boolean> shouldSleepFunction) {
        super((EntityCreature)entity, speedIn, AnimaniaConfig.gameRules.aiBlockSearchRange, true, EnumFacing.UP);
        this.entity = entity;
        this.func_75248_a(3);
        this.delay = 0;
        this.bedBlock = bed1;
        this.bedBlock2 = bed2;
        this.shouldSleep = shouldSleepFunction;
    }

    @Override
    public boolean func_75250_a() {
        if (this.entity instanceof EntityTameable && ((EntityTameable)this.entity).func_70906_o()) {
            return false;
        }
        if (++this.delay <= AnimaniaConfig.gameRules.ticksBetweenAIFirings + this.entity.func_70681_au().nextInt(100)) {
            return false;
        }
        if (((ISleeping)this.entity).getSleeping()) {
            if (!this.shouldSleep.apply(this.world.func_72820_D() % 24000L).booleanValue() || this.entity.func_70027_ad() || ((EntityCreature)this.entity).field_70170_p.func_175727_C(this.entity.func_180425_c()) && ((EntityCreature)this.entity).field_70170_p.func_175678_i(this.entity.func_180425_c())) {
                ((ISleeping)this.entity).setSleeping(false);
                ((ISleeping)this.entity).setSleepingPos(NO_POS);
            }
            this.delay = 0;
            return false;
        }
        return this.shouldSleep.apply(this.world.func_72820_D() % 24000L) != false && !((EntityCreature)this.entity).field_70170_p.func_175727_C(this.entity.func_180425_c()) && this.entity.func_70681_au().nextInt(3) == 0 ? super.func_75250_a() : false;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.isAtDestination()) {
            ((ISleeping)this.entity).setSleeping(true);
            ((ISleeping)this.entity).setSleepingPos(this.entity.func_180425_c());
            this.delay = 0;
        }
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && !((ISleeping)this.entity).getSleeping();
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
    }

    @Override
    protected boolean shouldMoveTo(World worldIn, BlockPos pos) {
        IBlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block == this.bedBlock;
    }

    @Override
    protected boolean shouldMoveToSecondary(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block == this.bedBlock2;
    }
}

