/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.tileentities;

import com.animania.api.interfaces.AnimaniaType;
import com.animania.common.handler.AddonHandler;
import com.animania.common.handler.AnimalTypeHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.tileentities.handler.ItemHandlerNest;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityNest
extends TileEntity
implements ITickable {
    private NestContent nestContent;
    public AnimaniaType birdType;
    public ItemHandlerNest itemHandler = new ItemHandlerNest(this);
    private int oldItemCount = 0;

    public NestContent getNestContent() {
        return this.nestContent;
    }

    public AnimaniaType getBirdType() {
        return this.birdType;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound items = this.itemHandler.serializeNBT();
        compound.func_74782_a("items", (NBTBase)items);
        if (this.birdType != null) {
            compound.func_74778_a("birdType", this.birdType.toString());
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        AnimaniaType type;
        super.func_145839_a(compound);
        this.itemHandler = new ItemHandlerNest(this);
        this.itemHandler.deserializeNBT(compound.func_74775_l("items"));
        if (AddonHandler.isAddonLoaded("farm") && (type = AnimalTypeHandler.getType("animania:chicken", compound.func_74779_i("birdType"))) != null) {
            this.birdType = type;
        }
        if (AddonHandler.isAddonLoaded("extra") && (type = AnimalTypeHandler.getType("animania:peacock", compound.func_74779_i("birdType"))) != null) {
            this.birdType = type;
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_145838_q().func_176223_P(), this.func_145838_q().func_176223_P(), 1);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_189515_b(tagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_73660_a() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (!stack.func_190926_b()) {
            int count = stack.func_190916_E();
            if (count != this.oldItemCount) {
                this.func_70296_d();
                this.oldItemCount = count;
            }
            for (NestContent c : NestContent.values()) {
                if (stack.func_77973_b() != c.item || this.nestContent == c) continue;
                this.nestContent = c;
            }
        } else if (this.nestContent != NestContent.EMPTY) {
            this.nestContent = NestContent.EMPTY;
            this.birdType = null;
            this.func_70296_d();
        }
    }

    public boolean insertItem(ItemStack stack) {
        ItemStack item = this.itemHandler.getStackInSlot(0);
        if (item.func_190926_b() || ItemStack.func_179545_c((ItemStack)stack, (ItemStack)item)) {
            int count = item.func_190916_E();
            if (stack.func_190916_E() + count <= 3) {
                ItemStack newStack = stack.func_77946_l();
                newStack.func_190920_e(stack.func_190916_E() + count);
                this.itemHandler.setStackInSlot(0, newStack);
                return true;
            }
        }
        return false;
    }

    public void removeItem() {
        ItemStack item = this.itemHandler.getStackInSlot(0);
        ItemStack copy = item.func_77946_l();
        copy.func_190918_g(1);
        this.itemHandler.setStackInSlot(0, copy);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        super.func_70296_d();
        AnimaniaHelper.sendTileEntityUpdate(this);
    }

    public static enum NestContent {
        EMPTY(Items.field_190931_a),
        CHICKEN_WHITE(Items.field_151110_aK),
        CHICKEN_BROWN(Item.func_111206_d((String)"animania:brown_egg")),
        PEACOCK_WHITE(Item.func_111206_d((String)"animania:peacock_egg_white")),
        PEACOCK_BLUE(Item.func_111206_d((String)"animania:peacock_egg_blue"));

        private Item item;

        private NestContent(Item item) {
            if (item == null) {
                item = Items.field_190931_a;
            }
            this.item = item;
        }

        public Item getItem() {
            return this.item;
        }
    }
}

