/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.fixer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.zerono.mods.zerocore.lib.data.fixer.MissingRegistryEntryHandler;
import it.zerono.mods.zerocore.lib.init.IGameObjectMapper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.GameData;
import org.apache.commons.lang3.tuple.Pair;

public class BlockReplacer
implements IFixableData,
IGameObjectMapper<Block> {
    private static final String CHUNK_TAG_LEVEL = "Level";
    private static final String CHUNK_TAG_SECTIONS = "Sections";
    private static final String CHUNK_TAG_XPOS = "xPos";
    private static final String CHUNK_TAG_ZPOS = "zPos";
    private static final String CHUNK_TAG_TILEENTITIES = "TileEntities";
    private static final String CHUNK_TAG_Y = "Y";
    private static final String CHUNK_TAG_BLOCKS = "Blocks";
    private static final String CHUNK_TAG_DATA = "Data";
    private static final String CHUNK_TAG_ADD = "Add";
    private final int _dataVersion;
    private Map<ResourceLocation, MissingBlockEntry> _replacements;
    private Map<Integer, VariantReplacement[]> _variantsByBlockId;

    public BlockReplacer(int dataVersion) {
        this._dataVersion = dataVersion;
        this._replacements = Maps.newHashMap();
    }

    public void addReplacement(@Nonnull ResourceLocation oldBlockId, int oldMetadata, @Nonnull Block replacement) {
        this.addReplacement(oldBlockId, oldMetadata, replacement, null, null);
    }

    public void addReplacement(@Nonnull ResourceLocation oldBlockId, int oldMetadata, @Nonnull Block replacement, @Nullable BiFunction<Block, NBTTagCompound, IBlockState> blockStateGenerator, @Nullable Function<NBTTagCompound, Boolean> teDataConverter) {
        MissingBlockEntry entry = this._replacements.computeIfAbsent(oldBlockId, k -> new MissingBlockEntry(oldBlockId));
        entry.addVariant(oldMetadata, replacement, blockStateGenerator, teDataConverter);
    }

    @Override
    public void linkObjectsMap(@Nonnull ImmutableMap<String, Block> map) {
    }

    @Override
    public void remap(@Nonnull RegistryEvent.MissingMappings.Mapping<Block> mapping) {
        this.invalidateCache();
        this._replacements.values().forEach(handler -> handler.remap(mapping));
    }

    public int func_188216_a() {
        return this._dataVersion;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        if (this._replacements.isEmpty()) {
            return compound;
        }
        ObjectIntIdentityMap blockStateIdMap = GameData.getBlockStateIDMap();
        NBTTagCompound level = compound.func_74775_l(CHUNK_TAG_LEVEL);
        NBTTagList sections = level.func_150295_c(CHUNK_TAG_SECTIONS, 10);
        ChunkPos chunkPos = new ChunkPos(level.func_74762_e(CHUNK_TAG_XPOS), level.func_74762_e(CHUNK_TAG_ZPOS));
        NBTTagList tileEntities = level.func_150295_c(CHUNK_TAG_TILEENTITIES, 10);
        Map<BlockPos, Pair<Integer, NBTTagCompound>> tileEntityMap = BlockReplacer.buildTileEntitiesDataMap(tileEntities);
        IntArrayList tileEntityToRemove = new IntArrayList();
        for (int sectionIdx = 0; sectionIdx < sections.func_74745_c(); ++sectionIdx) {
            NBTTagCompound section = sections.func_150305_b(sectionIdx);
            byte sectionY = section.func_74771_c(CHUNK_TAG_Y);
            byte[] blockIds = section.func_74770_j(CHUNK_TAG_BLOCKS);
            NibbleArray metadataArray = new NibbleArray(section.func_74770_j(CHUNK_TAG_DATA));
            NibbleArray blockIdsExtension = section.func_150297_b(CHUNK_TAG_ADD, 7) ? new NibbleArray(section.func_74770_j(CHUNK_TAG_ADD)) : new NibbleArray();
            boolean hasExtendedBlockIds = section.func_150297_b(CHUNK_TAG_ADD, 7);
            for (int blockIdx = 0; blockIdx < blockIds.length; ++blockIdx) {
                int metadata;
                int x = blockIdx & 0xF;
                int y = blockIdx >> 8 & 0xF;
                int z = blockIdx >> 4 & 0xF;
                int blockIdExtension = blockIdsExtension.func_76582_a(x, y, z);
                int blockId = blockIdExtension << 8 | blockIds[blockIdx] & 0xFF;
                VariantReplacement variantReplacement = this.getVariantReplacement(blockId, metadata = metadataArray.func_76582_a(x, y, z));
                if (variantReplacement == null) continue;
                BlockPos blockPos = chunkPos.func_180331_a(x, sectionY << 4 | y, z);
                Pair<Integer, NBTTagCompound> tileEntityPair = tileEntityMap.get(blockPos);
                NBTTagCompound tileEntityNBT = tileEntityPair != null ? (NBTTagCompound)tileEntityPair.getValue() : null;
                IBlockState newBlockState = variantReplacement.getNewBlockState(tileEntityNBT);
                int blockStateID = blockStateIdMap.func_148747_b((Object)newBlockState);
                byte newBlockID = (byte)(blockStateID >> 4 & 0xFF);
                byte newBlockIDExtension = (byte)(blockStateID >> 12 & 0xF);
                byte newMetadata = (byte)(blockStateID & 0xF);
                blockIds[blockIdx] = newBlockID;
                metadataArray.func_76581_a(x, y, z, (int)newMetadata);
                if (newBlockIDExtension != 0) {
                    hasExtendedBlockIds = true;
                    blockIdsExtension.func_76581_a(x, y, z, (int)newBlockIDExtension);
                }
                if (null == tileEntityNBT || variantReplacement.convertTileEntityData(tileEntityNBT)) continue;
                tileEntityToRemove.add(tileEntityPair.getKey());
            }
            section.func_74773_a(CHUNK_TAG_BLOCKS, blockIds);
            section.func_74773_a(CHUNK_TAG_DATA, metadataArray.func_177481_a());
            if (!hasExtendedBlockIds) continue;
            section.func_74773_a(CHUNK_TAG_ADD, blockIdsExtension.func_177481_a());
        }
        tileEntityToRemove.sort(Comparator.reverseOrder());
        IntListIterator intListIterator = tileEntityToRemove.iterator();
        while (intListIterator.hasNext()) {
            int tileEntityIdx = (Integer)intListIterator.next();
            tileEntities.func_74744_a(tileEntityIdx);
        }
        return compound;
    }

    private static Map<BlockPos, Pair<Integer, NBTTagCompound>> buildTileEntitiesDataMap(@Nonnull NBTTagList tileEntities) {
        HashMap map = Maps.newHashMap();
        for (int idx = 0; idx < tileEntities.func_74745_c(); ++idx) {
            NBTTagCompound nbt = tileEntities.func_150305_b(idx);
            if (nbt.func_82582_d()) continue;
            map.put(new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")), Pair.of((Object)idx, (Object)nbt));
        }
        return map;
    }

    @Nullable
    protected VariantReplacement getVariantReplacement(int oldBlockId, int oldMetadata) {
        if (null == this._variantsByBlockId) {
            this.rebuildCache();
        }
        if (this._variantsByBlockId.containsKey(oldBlockId)) {
            return this._variantsByBlockId.get(oldBlockId)[oldMetadata];
        }
        return null;
    }

    private void invalidateCache() {
        this._variantsByBlockId = null;
    }

    private void rebuildCache() {
        this._variantsByBlockId = Maps.newHashMap();
        for (MissingBlockEntry replacement : this._replacements.values()) {
            this._variantsByBlockId.put(replacement.getOldId(), replacement.getVariants());
        }
    }

    private static class MissingBlockEntry
    extends MissingRegistryEntryHandler<Block> {
        private final VariantReplacement[] _variants = new VariantReplacement[16];

        MissingBlockEntry(@Nonnull ResourceLocation oldObjectKey) {
            super(oldObjectKey, RegistryEvent.MissingMappings.Action.IGNORE, null);
        }

        void addVariant(int oldMetadata, @Nonnull Block replacement, @Nullable BiFunction<Block, NBTTagCompound, IBlockState> blockStateGenerator, @Nullable Function<NBTTagCompound, Boolean> teDataConverter) {
            this._variants[oldMetadata] = new VariantReplacement(oldMetadata, replacement, blockStateGenerator, teDataConverter);
        }

        @Nonnull
        public VariantReplacement[] getVariants() {
            return this._variants;
        }
    }

    private static class VariantReplacement {
        final int _oldMetadata;
        final Block _replacement;
        final BiFunction<Block, NBTTagCompound, IBlockState> _blockStateGenerator;
        final Function<NBTTagCompound, Boolean> _teDataConverter;

        VariantReplacement(int oldMetadata, @Nonnull Block replacement, @Nullable BiFunction<Block, NBTTagCompound, IBlockState> blockStateGenerator, @Nullable Function<NBTTagCompound, Boolean> teDataConverter) {
            this._oldMetadata = oldMetadata;
            this._replacement = replacement;
            this._blockStateGenerator = blockStateGenerator;
            this._teDataConverter = teDataConverter;
        }

        public int getOldMetadata() {
            return this._oldMetadata;
        }

        public Block getReplacement() {
            return this._replacement;
        }

        @Nonnull
        public IBlockState getNewBlockState(@Nullable NBTTagCompound tileEntityData) {
            IBlockState state = null != this._blockStateGenerator ? this._blockStateGenerator.apply(this.getReplacement(), tileEntityData) : null;
            return null != state ? state : this.getReplacement().func_176223_P();
        }

        public boolean convertTileEntityData(@Nullable NBTTagCompound tileEntityData) {
            return null != this._teDataConverter ? this._teDataConverter.apply(tileEntityData) : true;
        }
    }
}

