/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.util;

import it.zerono.mods.zerocore.util.ItemHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictionaryHelper {
    public static String[] getOreNames(ItemStack stack) {
        int count;
        if (ItemHelper.stackIsEmpty(stack)) {
            return null;
        }
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        if (oreIDs == null || (count = oreIDs.length) < 1) {
            return null;
        }
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = OreDictionary.getOreName((int)oreIDs[i]);
        }
        return names;
    }

    public static String[] getOreNames(@Nonnull IBlockState state) {
        return OreDictionaryHelper.getOreNames(ItemHelper.stackFrom(state, 1));
    }

    public static String getFirstOreName(ItemStack stack) {
        String[] names = ItemHelper.stackIsValid(stack) ? OreDictionaryHelper.getOreNames(stack) : null;
        return null != names && names.length > 0 ? names[0] : "";
    }

    public static String getFirstOreName(@Nonnull IBlockState state) {
        return OreDictionaryHelper.getFirstOreName(ItemHelper.stackFrom(state, 1));
    }

    public static ItemStack getOre(String name) {
        return !OreDictionaryHelper.doesOreNameExist(name) ? null : ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)OreDictionary.getOres((String)name).get(0)), (int)1);
    }

    public static boolean doesOreNameExist(String name) {
        return OreDictionary.doesOreNameExist((String)name);
    }

    private OreDictionaryHelper() {
    }
}

