/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import cpw.mods.inventorysorter.InventorySorterCommand;
import cpw.mods.inventorysorter.Network;
import cpw.mods.inventorysorter.ServerHandler;
import cpw.mods.inventorysorter.SideProxy;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.command.ICommand;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="inventorysorter", name="Inventory Sorter", guiFactory="cpw.mods.inventorysorter.GuiConfigFactory", acceptedMinecraftVersions="[1.12.2]")
public class InventorySorter {
    @Mod.Instance(value="inventorysorter")
    public static InventorySorter INSTANCE;
    public Logger log;
    boolean debugLog;
    public SimpleNetworkWrapper channel;
    final Set<String> slotblacklist = new HashSet<String>();
    final Set<String> containerblacklist = new HashSet<String>();
    String containerTracking;

    @Mod.EventHandler
    public void handleimc(FMLInterModComms.IMCEvent evt) {
        this.handleimcmessages(Optional.ofNullable(evt.getMessages()));
    }

    private void handleimcmessages(Optional<List<FMLInterModComms.IMCMessage>> messages) {
        messages.ifPresent(m -> m.forEach(this::handleimcmessage));
    }

    private void handleimcmessage(FMLInterModComms.IMCMessage msg) {
        if ("slotblacklist".equals(msg.key) && msg.isStringMessage() && this.slotblacklist.add(msg.getStringValue())) {
            this.debugLog("SlotBlacklist added {}", () -> new String[]{msg.getStringValue()});
        }
        if ("containerblacklist".equals(msg.key) && msg.isStringMessage() && this.containerblacklist.add(msg.getStringValue())) {
            this.debugLog("ContainerBlacklist added {}", () -> new String[]{msg.getStringValue()});
        }
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent evt) {
        Properties versionProperties = evt.getVersionProperties();
        evt.getModMetadata().version = versionProperties != null ? versionProperties.getProperty("inventorysorter.version") : "1.0";
        this.log = evt.getModLog();
        SideProxy.INSTANCE.loadConfiguration(evt.getSuggestedConfigurationFile());
        this.channel = NetworkRegistry.INSTANCE.newSimpleChannel("inventorysorter");
        this.channel.registerMessage(ServerHandler.class, Network.ActionMessage.class, 1, Side.SERVER);
        SideProxy.INSTANCE.bindKeys();
        FMLInterModComms.sendMessage((String)"inventorysorter", (String)"slotblacklist", (String)"codechicken.core.inventory.SlotDummy");
    }

    @Mod.EventHandler
    public void onserverstarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new InventorySorterCommand());
    }

    boolean wheelModConflicts() {
        return Loader.isModLoaded((String)"mousetweaks");
    }

    boolean sortingModConflicts() {
        return false;
    }

    public final void debugLog(String message, Supplier<String[]> args) {
        if (this.debugLog) {
            this.log.error(message, (Object[])args.get());
        }
    }

    String modifyBlackList(Function<Set<String>, Boolean> modifier) {
        if (this.containerTracking != null) {
            if (modifier.apply(this.containerblacklist).booleanValue()) {
                SideProxy.INSTANCE.updateConfiguration(this.containerblacklist);
            }
            return this.containerTracking;
        }
        return null;
    }

    public static TextComponentTranslation blackListAdd() {
        String blacklist = INSTANCE.modifyBlackList(sa -> sa.add(InventorySorter.INSTANCE.containerTracking));
        if (blacklist != null) {
            return new TextComponentTranslation("inventorysorter.commands.inventorysorter.bladd.message", new Object[]{InventorySorter.greenText(blacklist)});
        }
        return InventorySorterCommand.NOOP_COMMAND;
    }

    public static TextComponentTranslation blackListRemove() {
        String blacklist = INSTANCE.modifyBlackList(sa -> sa.remove(InventorySorter.INSTANCE.containerTracking));
        if (blacklist != null) {
            return new TextComponentTranslation("inventorysorter.commands.inventorysorter.blremove.message", new Object[]{InventorySorter.greenText(blacklist)});
        }
        return InventorySorterCommand.NOOP_COMMAND;
    }

    public static TextComponentTranslation showLast() {
        if (InventorySorter.INSTANCE.containerTracking != null) {
            return new TextComponentTranslation("inventorysorter.commands.inventorysorter.show.message", new Object[]{InventorySorter.greenText(InventorySorter.INSTANCE.containerTracking)});
        }
        return InventorySorterCommand.NOOP_COMMAND;
    }

    public static TextComponentTranslation showBlacklist() {
        if (InventorySorter.INSTANCE.containerblacklist.isEmpty()) {
            return new TextComponentTranslation("inventorysorter.commands.inventorysorter.list.empty", new Object[0]);
        }
        return new TextComponentTranslation("inventorysorter.commands.inventorysorter.list.message", new Object[]{InventorySorter.INSTANCE.containerblacklist.stream().map(s -> "\"\u00a7a" + s + "\u00a7f\"").collect(Collectors.joining(","))});
    }

    private static TextComponentString greenText(String string) {
        TextComponentString tcs = new TextComponentString(string);
        tcs.func_150256_b().func_150238_a(TextFormatting.GREEN);
        return tcs;
    }
}

