/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.mobs;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.client.render.entity.layer.LayerDesertWolfCollar;
import com.teammetallurgy.atum.entity.animal.EntityDesertWolf;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderDesertWolf
extends RenderLiving<EntityDesertWolf> {
    private static final Map<String, ResourceLocation> CACHE = Maps.newHashMap();
    private static final ResourceLocation TAMED_DESERT_WOLF_TEXTURES = new ResourceLocation("atum", "textures/entity/desert_wolf_tame.png");
    private static final ResourceLocation ANGRY_DESERT_WOLF_TEXTURES = new ResourceLocation("atum", "textures/entity/desert_wolf_angry.png");
    private static final ResourceLocation SADDLE_DESERT_WOLF_TEXTURE = new ResourceLocation("atum", "textures/entity/desert_wolf_saddle.png");

    public RenderDesertWolf(RenderManager renderManager, ModelBase modelBase, float shadowSize) {
        super(renderManager, modelBase, shadowSize);
        this.func_177094_a(new LayerDesertWolfCollar(this));
    }

    protected float handleRotationFloat(EntityDesertWolf desertWolf, float rotation) {
        return desertWolf.getTailRotation();
    }

    public void doRender(@Nonnull EntityDesertWolf desertWolf, double x, double y, double z, float entityYaw, float partialTicks) {
        if (desertWolf.isWolfWet()) {
            GlStateManager.func_179094_E();
            float f = desertWolf.func_70013_c() * desertWolf.getShadingWhileWet(partialTicks);
            GlStateManager.func_179124_c((float)f, (float)f, (float)f);
            GlStateManager.func_179121_F();
        }
        super.func_76986_a((EntityLiving)desertWolf, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(@Nonnull EntityDesertWolf desertWolf) {
        String textureName = desertWolf.getTexture();
        ResourceLocation location = CACHE.get(textureName);
        if (location == null) {
            location = new ResourceLocation(textureName);
            String[] texturePath = new String[3];
            texturePath[0] = desertWolf.isAngry() ? ANGRY_DESERT_WOLF_TEXTURES.toString() : TAMED_DESERT_WOLF_TEXTURES.toString();
            ItemStack armor = desertWolf.getArmor();
            if (!armor.func_190926_b()) {
                EntityDesertWolf.ArmorType armorType = EntityDesertWolf.ArmorType.getByItemStack(armor);
                texturePath[1] = armorType.getTextureName();
            }
            if (desertWolf.isSaddled()) {
                texturePath[2] = SADDLE_DESERT_WOLF_TEXTURE.toString();
            }
            Minecraft.func_71410_x().func_110434_K().func_110579_a(location, (ITextureObject)new LayeredTexture(texturePath));
            CACHE.put(textureName, location);
        }
        return location;
    }

    protected void preRenderCallback(EntityDesertWolf desertWolf, float partialTickTime) {
        if (desertWolf.isAlpha()) {
            float scale = 1.5f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        }
    }
}

