/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.waila;

import com.teammetallurgy.atum.blocks.base.BlockAtumDoor;
import com.teammetallurgy.atum.blocks.vegetation.BlockDate;
import com.teammetallurgy.atum.utils.AtumUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class WailaHUDHandler
implements IWailaDataProvider {
    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        ResourceLocation location;
        if (accessor.getBlock() instanceof BlockAtumDoor && config.getConfig("vanilla.silverfish") && (location = Objects.requireNonNull(accessor.getBlock().getRegistryName())).toString().contains("limestone")) {
            location = new ResourceLocation(location.toString().replace("_door", ""));
            return new ItemStack((Item)Objects.requireNonNull(Item.field_150901_e.func_82594_a((Object)location)));
        }
        return accessor.getStack();
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlock() instanceof BlockDate && config.getConfig("general.showcrop")) {
            float growthValue = (float)accessor.getMetadata() / 7.0f * 100.0f;
            if (growthValue < 100.0f) {
                tooltip.add(AtumUtils.format("hud.msg.growth") + " : " + AtumUtils.format("hud.msg.growth.value", (int)growthValue));
            } else {
                tooltip.add(AtumUtils.format("hud.msg.growth") + " : " + AtumUtils.format("hud.msg.mature"));
            }
        }
        return tooltip;
    }
}

