/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.biome.base;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.world.gen.layer.GenLayerAtumBiome;
import com.teammetallurgy.atum.world.gen.layer.GenLayerAtumRiver;
import com.teammetallurgy.atum.world.gen.layer.GenLayerAtumRiverMix;
import com.teammetallurgy.atum.world.gen.layer.GenLayerOasis;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerBiomeEdge;
import net.minecraft.world.gen.layer.GenLayerEdge;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerHills;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.storage.WorldInfo;

public class AtumBiomeProvider
extends BiomeProvider {
    public AtumBiomeProvider(WorldInfo info) {
        GenLayer[] genLayers = this.initializeAllBiomeGenerators(info.func_76063_b(), info.func_76067_t(), this.field_190945_a);
        this.field_76944_d = genLayers[0];
        this.field_76945_e = genLayers[1];
    }

    private GenLayer[] initializeAllBiomeGenerators(long seed, WorldType worldType, ChunkGeneratorSettings settings) {
        int biomeSize;
        GenLayerIsland layer = new GenLayerIsland(seed);
        layer = new GenLayerFuzzyZoom(2000L, (GenLayer)layer);
        GenLayerZoom layerZoom = new GenLayerZoom(2001L, (GenLayer)layer);
        GenLayerEdge layerEdge = new GenLayerEdge(2L, (GenLayer)layerZoom, GenLayerEdge.Mode.COOL_WARM);
        layerEdge = new GenLayerEdge(3L, (GenLayer)layerEdge, GenLayerEdge.Mode.SPECIAL);
        GenLayerZoom layerZoom2 = new GenLayerZoom(2002L, (GenLayer)layerEdge);
        layerZoom2 = new GenLayerZoom(2003L, (GenLayer)layerZoom2);
        GenLayer magnify = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)layerZoom2, (int)0);
        int riverSize = biomeSize = 4;
        if (settings != null) {
            biomeSize = settings.field_177780_G;
            riverSize = settings.field_177788_H;
        }
        if (worldType == WorldType.field_77135_d) {
            biomeSize = 6;
        }
        GenLayer riverMagnify = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)magnify, (int)0);
        GenLayerRiverInit layerRiverInit = new GenLayerRiverInit(100L, riverMagnify);
        GenLayer layerBiomes = this.getBiomeLayer(worldType, seed, settings);
        GenLayer hillMagnify = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)layerRiverInit, (int)2);
        Object layerHills = new GenLayerHills(1000L, layerBiomes, hillMagnify);
        GenLayer riverMagnify2 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)layerRiverInit, (int)2);
        riverMagnify2 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)riverMagnify2, (int)riverSize);
        GenLayerAtumRiver layerRiver = new GenLayerAtumRiver(1L, riverMagnify2);
        GenLayerSmooth layerSmooth = new GenLayerSmooth(1000L, (GenLayer)layerRiver);
        layerHills = new GenLayerOasis(1001L, (GenLayer)layerHills);
        for (int k = 0; k < biomeSize; ++k) {
            layerHills = new GenLayerZoom((long)(1000 + k), (GenLayer)layerHills);
        }
        GenLayerSmooth layerSmoothRiver = new GenLayerSmooth(1000L, (GenLayer)layerHills);
        GenLayerAtumRiverMix layerRiverMix = new GenLayerAtumRiverMix(100L, (GenLayer)layerSmoothRiver, (GenLayer)layerSmooth);
        GenLayerVoronoiZoom layerVoronoi = new GenLayerVoronoiZoom(10L, (GenLayer)layerRiverMix);
        layerRiverMix.func_75905_a(seed);
        layerVoronoi.func_75905_a(seed);
        return new GenLayer[]{layerRiverMix, layerVoronoi, layerRiverMix};
    }

    private GenLayer getBiomeLayer(WorldType worldType, long worldSeed, ChunkGeneratorSettings chunkSettings) {
        GenLayerAtumBiome ret = new GenLayerAtumBiome(worldSeed, chunkSettings);
        ret = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)ret, (int)2);
        ret = new GenLayerBiomeEdge(1000L, (GenLayer)ret);
        return ret;
    }

    @Nonnull
    public List<Biome> func_76932_a() {
        return Lists.newArrayList((Object[])new Biome[]{AtumBiomes.DEAD_OASIS, AtumBiomes.DEADWOOD_FOREST, AtumBiomes.OASIS, AtumBiomes.SAND_DUNES, AtumBiomes.SAND_PLAINS});
    }
}

