/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.biome.base;

import com.google.common.base.Predicate;
import com.teammetallurgy.atum.blocks.stone.limestone.BlockLimestone;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.utils.AtumConfig;
import com.teammetallurgy.atum.world.gen.feature.WorldGenShrub;
import com.teammetallurgy.atum.world.gen.feature.WorldGenSpring;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeDecoratorAtum
extends BiomeDecorator {
    private WorldGenerator emeraldGen;
    private WorldGenerator boneGen;
    private WorldGenerator relicGen;
    private WorldGenerator alabasterGen = this.generateMineable(AtumBlocks.ALABASTER.func_176223_P(), 33);
    private WorldGenerator porphyryGen = this.generateMineable(AtumBlocks.PORPHYRY.func_176223_P(), 33);
    private WorldGenerator khnumite = this.generateMineable(AtumBlocks.KHNUMITE_RAW.func_176223_P(), 5);
    private WorldGenerator limestoneScarab = this.generateMineable(AtumBlocks.LIMESTONE.func_176223_P().func_177226_a((IProperty)BlockLimestone.HAS_SCARAB, (Comparable)Boolean.valueOf(true)), 10);
    public float shrubChance;

    BiomeDecoratorAtum() {
        this.boneGen = this.generateMineable(AtumBlocks.BONE_ORE.func_176223_P(), 8);
        this.relicGen = this.generateMineable(AtumBlocks.RELIC_ORE.func_176223_P(), 4);
        this.field_76821_k = this.generateMineable(AtumBlocks.COAL_ORE.func_176223_P(), 16);
        this.field_76818_l = this.generateMineable(AtumBlocks.IRON_ORE.func_176223_P(), 8);
        this.field_76819_m = this.generateMineable(AtumBlocks.GOLD_ORE.func_176223_P(), 8);
        this.field_180299_p = this.generateMineable(AtumBlocks.REDSTONE_ORE.func_176223_P(), 7);
        this.field_180298_q = this.generateMineable(AtumBlocks.DIAMOND_ORE.func_176223_P(), 7);
        this.emeraldGen = this.generateMineable(AtumBlocks.EMERALD_ORE.func_176223_P(), 5);
        this.field_76831_p = this.generateMineable(AtumBlocks.LAPIS_ORE.func_176223_P(), 6);
        this.field_76823_i = this.generateMineable(AtumBlocks.SAND.func_176223_P(), 32);
        this.field_76822_h = this.generateMineable(AtumBlocks.LIMESTONE_GRAVEL.func_176223_P(), 32);
        this.field_76809_f = this.generateMineable(AtumBlocks.MARL.func_176223_P(), 12);
        this.field_76832_z = 0;
        this.shrubChance = 0.3f;
        this.field_76808_K = false;
    }

    private WorldGenMinable generateMineable(IBlockState state, int size) {
        String category = "world gen.ore gen." + Objects.requireNonNull(state.func_177230_c().getRegistryName()).func_110623_a();
        size = AtumConfig.config.get(category, "vein size", size).getInt();
        AtumConfig.config.save();
        if (size > 0) {
            return new WorldGenMinable(state, size, (Predicate)BlockMatcher.func_177642_a((Block)AtumBlocks.LIMESTONE));
        }
        return null;
    }

    public void func_180292_a(World world, @Nonnull Random random, @Nonnull Biome biomeGenBase, @Nonnull BlockPos pos) {
        if (this.field_185425_a) {
            throw new RuntimeException("Already decorating!!");
        }
        this.field_180294_c = pos;
        this.func_150513_a(biomeGenBase, world, random);
        this.field_185425_a = false;
    }

    protected void func_76797_b(@Nonnull World world, @Nonnull Random random) {
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(world, random, this.field_180294_c));
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.field_76821_k, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.COAL)) {
            this.func_76795_a(world, random, 20, this.field_76821_k, 0, 128);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.field_76818_l, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.IRON)) {
            this.func_76795_a(world, random, 20, this.field_76818_l, 0, 62);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.field_76819_m, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GOLD)) {
            this.func_76795_a(world, random, 2, this.field_76819_m, 0, 32);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.field_180299_p, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.REDSTONE)) {
            this.func_76795_a(world, random, 8, this.field_180299_p, 0, 16);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.emeraldGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.EMERALD)) {
            this.func_76795_a(world, random, 3, this.emeraldGen, 4, 32);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.field_180298_q, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIAMOND)) {
            this.func_76795_a(world, random, 1, this.field_180298_q, 0, 16);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.field_76831_p, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.LAPIS)) {
            this.func_76793_b(world, random, 1, this.field_76831_p, 16, 16);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.boneGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.func_76795_a(world, random, 12, this.boneGen, 0, 128);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.relicGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.func_76795_a(world, random, 4, this.relicGen, 0, 64);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.field_76823_i, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.DIRT)) {
            this.func_76795_a(world, random, 32, this.field_76823_i, 0, 256);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.field_76822_h, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GRAVEL)) {
            this.func_76795_a(world, random, 10, this.field_76822_h, 0, 256);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.field_76809_f, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.func_76795_a(world, random, 8, this.field_76809_f, 0, 50);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.alabasterGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.func_76795_a(world, random, 10, this.alabasterGen, 0, 60);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.porphyryGen, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.func_76795_a(world, random, 10, this.porphyryGen, 0, 60);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.khnumite, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.func_76795_a(world, random, 4, this.khnumite, 0, 20);
        }
        if (TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)this.limestoneScarab, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            this.func_76795_a(world, random, 8, this.limestoneScarab, 11, 80);
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(world, random, this.field_180294_c));
    }

    protected void func_150513_a(@Nonnull Biome biomeGenBase, @Nonnull World world, Random random) {
        int i18;
        int j11;
        int k7;
        int l14;
        int j;
        int i;
        ChunkPos chunkPosition = new ChunkPos(this.field_180294_c);
        MinecraftForge.EVENT_BUS.post((Event)new OreGenEvent.Pre(world, random, this.field_180294_c));
        this.func_76797_b(world, random);
        boolean doGen = TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPosition, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SAND_PASS2);
        for (i = 0; doGen && i < this.field_76805_H; ++i) {
            j = random.nextInt(16) + 8;
            int k = random.nextInt(16) + 8;
            this.field_76810_g.func_180709_b(world, random, world.func_175672_r(this.field_180294_c.func_177982_a(j, 0, k)));
        }
        i = this.field_76832_z;
        if (random.nextInt(10) == 0) {
            ++i;
        }
        for (j = 0; TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPosition, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.GRASS) && j < this.field_76803_B; ++j) {
            int i11;
            int j7 = random.nextInt(16) + 8;
            int k14 = world.func_175645_m(this.field_180294_c.func_177982_a(j7, 0, i11 = random.nextInt(16) + 8)).func_177956_o() * 2;
            if (k14 <= 0) continue;
            int l17 = random.nextInt(k14);
            biomeGenBase.func_76730_b(random).func_180709_b(world, random, this.field_180294_c.func_177982_a(j7, l17, i11));
        }
        if (random.nextFloat() < this.shrubChance && (l14 = world.func_175645_m(this.field_180294_c.func_177982_a(k7 = random.nextInt(16) + 8, 0, j11 = random.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
            i18 = random.nextInt(l14);
            new WorldGenShrub((Block)AtumBlocks.SHRUB, 8).func_180709_b(world, random, this.field_180294_c.func_177982_a(k7, i18, j11));
        }
        if (random.nextFloat() < this.shrubChance && (l14 = world.func_175645_m(this.field_180294_c.func_177982_a(k7 = random.nextInt(16) + 8, 0, j11 = random.nextInt(16) + 8)).func_177956_o() * 2) > 0) {
            i18 = random.nextInt(l14);
            new WorldGenShrub((Block)AtumBlocks.WEED, 8).func_180709_b(world, random, this.field_180294_c.func_177982_a(k7, i18, j11));
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPosition, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE_WATER)) {
            for (int k5 = 0; k5 < 50; ++k5) {
                int x = random.nextInt(16) + 8;
                int z = random.nextInt(16) + 8;
                int y = random.nextInt(248) + 8;
                if (y <= 0) continue;
                int randomY = random.nextInt(y);
                BlockPos pos = this.field_180294_c.func_177982_a(x, randomY, z);
                new WorldGenSpring((Block)Blocks.field_150358_i).func_180709_b(world, random, pos);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new OreGenEvent.Post(world, random, this.field_180294_c));
    }
}

