/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.api.registry;

import erogenousbeef.bigreactors.api.data.ReactorInteriorData;
import it.zerono.mods.zerocore.util.ItemHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.oredict.OreDictionary;

public class ReactorInterior {
    private static Map<String, ReactorInteriorData> _reactorModeratorBlocks = new HashMap<String, ReactorInteriorData>();
    private static Map<String, ReactorInteriorData> _reactorModeratorFluids = new HashMap<String, ReactorInteriorData>();

    public static void registerBlock(String oreDictName, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        ReactorInterior.register(true, oreDictName, absorption, heatEfficiency, moderation, heatConductivity);
    }

    @Nullable
    public static ReactorInteriorData deregisterBlock(String oreDictName) {
        return ReactorInterior.deregister(true, oreDictName);
    }

    public static void registerFluid(String fluidName, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        ReactorInterior.register(false, fluidName, absorption, heatEfficiency, moderation, heatConductivity);
    }

    @Nullable
    public static ReactorInteriorData deregisterFluid(String fluidName) {
        return ReactorInterior.deregister(false, fluidName);
    }

    @Nullable
    public static ReactorInteriorData getBlockData(String oreDictName) {
        return _reactorModeratorBlocks.get(oreDictName);
    }

    @Nullable
    public static ReactorInteriorData getBlockData(ItemStack stack) {
        int len;
        int[] ids;
        int[] nArray = ids = ItemHelper.stackIsValid((ItemStack)stack) ? OreDictionary.getOreIDs((ItemStack)stack) : null;
        if (null == ids || 0 == (len = ids.length)) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            String name = OreDictionary.getOreName((int)ids[i]);
            if (!_reactorModeratorBlocks.containsKey(name)) continue;
            return _reactorModeratorBlocks.get(name);
        }
        return null;
    }

    @Nullable
    public static ReactorInteriorData getFluidData(String fluidName) {
        return _reactorModeratorFluids.get(fluidName);
    }

    private static void register(boolean isBlock, String name, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        Map<String, ReactorInteriorData> registry;
        Map<String, ReactorInteriorData> map = registry = isBlock ? _reactorModeratorBlocks : _reactorModeratorFluids;
        if (null == name || name.isEmpty()) {
            FMLLog.warning((String)"Blocked an attempt to register a new radiation moderator with an empty name", (Object[])new Object[0]);
            return;
        }
        if (registry.containsKey(name)) {
            FMLLog.warning((String)"Overriding existing radiation moderator data for <%s>", (Object[])new Object[]{name});
            ReactorInteriorData data = registry.get(name);
            data.absorption = absorption;
            data.heatEfficiency = heatEfficiency;
            data.moderation = moderation;
        } else {
            registry.put(name, new ReactorInteriorData(absorption, heatEfficiency, moderation, heatConductivity));
        }
    }

    @Nullable
    private static ReactorInteriorData deregister(boolean isBlock, String name) {
        Map<String, ReactorInteriorData> registry = isBlock ? _reactorModeratorBlocks : _reactorModeratorFluids;
        return null != name && !name.isEmpty() ? registry.remove(name) : null;
    }
}

