/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common;

import erogenousbeef.bigreactors.client.ClientProxy;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum CircuitType {
    DISABLED(0),
    inputActive(-1),
    inputSetControlRod(-1),
    inputEjectWaste(-1),
    outputFuelTemperature(1),
    outputCasingTemperature(1),
    outputFuelMix(1),
    outputFuelAmount(1),
    outputWasteAmount(1),
    outputEnergyAmount(1);

    public static final CircuitType[] TYPES;
    private final byte _flow;
    private static final String[] s_grabbableTooltips;

    private CircuitType(int flowDirection) {
        this._flow = (byte)flowDirection;
    }

    public boolean isInput() {
        return this._flow < 0;
    }

    public boolean isOutput() {
        return this._flow > 0;
    }

    public String getTooltip() {
        return s_grabbableTooltips[this.ordinal() - 1];
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getIcon() {
        if (DISABLED == this) {
            return TextureMap.field_174945_f;
        }
        return ClientProxy.GuiIcons.getIcon(37 + this.ordinal() - 1);
    }

    public static boolean hasCoordinate(CircuitType circuitType) {
        return circuitType == inputSetControlRod;
    }

    public static boolean canBeToggledBetweenPulseAndNormal(CircuitType circuitType) {
        return circuitType == inputActive;
    }

    static {
        TYPES = CircuitType.values();
        s_grabbableTooltips = new String[]{"Input: Toggle reactor on/off", "Input: Change control rod insertion", "Input: Eject Waste", "Output: Fuel Temp (C)", "Output: Casing Temp (C)", "Output: Fuel mix (% fuel, 0-100)", "Output: Fuel amount", "Output: Waste amount", "Output: Energy amount (%)"};
    }
}

