/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.serialization;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import xaero.common.category.ObjectCategory;
import xaero.common.category.serialization.data.ObjectCategoryData;
import xaero.common.category.serialization.data.ObjectCategoryDataSerializer;
import xaero.common.category.setting.ObjectCategorySetting;

public abstract class ObjectCategorySerializationHandler<D extends ObjectCategoryData<D>, C extends ObjectCategory<D, C>, B extends ObjectCategory.Builder<C, B>, DB extends ObjectCategoryData.Builder<D, DB>> {
    private final ObjectCategoryDataSerializer<D> serializer;
    private final Supplier<DB> dataBuilderFactory;
    private final Supplier<B> objectCategoryBuilderFactory;
    private final Function<String, ObjectCategorySetting<?>> settingTypeGetter;

    protected ObjectCategorySerializationHandler(@Nonnull ObjectCategoryDataSerializer<D> serializer, @Nonnull Supplier<DB> dataBuilderFactory, @Nonnull Supplier<B> objectCategoryBuilderFactory, @Nonnull Function<String, ObjectCategorySetting<?>> settingTypeGetter) {
        this.serializer = serializer;
        this.dataBuilderFactory = dataBuilderFactory;
        this.objectCategoryBuilderFactory = objectCategoryBuilderFactory;
        this.settingTypeGetter = settingTypeGetter;
    }

    public String serialize(C category) {
        DB dataBuilder = this.getConfiguredDataBuilderForCategory(category);
        String serializedData = this.serializer.serialize(((ObjectCategoryData.Builder)dataBuilder).build());
        return serializedData;
    }

    protected DB getConfiguredDataBuilderForCategory(C category) {
        Object dataBuilder = ((ObjectCategoryData.Builder)this.dataBuilderFactory.get()).setDefault();
        ((ObjectCategoryData.Builder)dataBuilder).setName(((ObjectCategory)category).getName());
        ((ObjectCategoryData.Builder)dataBuilder).setProtection(((ObjectCategory)category).getProtection());
        ((ObjectCategory)category).getSettingOverridesIterator().forEachRemaining(new Consumer<Map.Entry<ObjectCategorySetting<?>, Object>>((ObjectCategoryData.Builder)dataBuilder){
            final /* synthetic */ ObjectCategoryData.Builder val$dataBuilder;
            {
                this.val$dataBuilder = builder;
            }

            @Override
            public void accept(Map.Entry<ObjectCategorySetting<?>, Object> e) {
                this.val$dataBuilder.setSettingOverride(e.getKey().getId(), e.getValue());
            }
        });
        ((ObjectCategory)category).getDirectSubCategoryIterator().forEachRemaining(new Consumer<C>((ObjectCategoryData.Builder)dataBuilder){
            final /* synthetic */ ObjectCategoryData.Builder val$dataBuilder;
            {
                this.val$dataBuilder = builder;
            }

            @Override
            public void accept(C c) {
                this.val$dataBuilder.addSubCategoryBuilder(ObjectCategorySerializationHandler.this.getConfiguredDataBuilderForCategory(c));
            }
        });
        return (DB)dataBuilder;
    }

    public C deserialize(String serializedData) {
        D data = this.serializer.deserialize(serializedData);
        B categoryBuilder = this.getConfiguredCategoryBuilderForData(data);
        return ((ObjectCategory.Builder)categoryBuilder).build();
    }

    protected B getConfiguredCategoryBuilderForData(D data) {
        final Object objectCategoryBuilder = ((ObjectCategory.Builder)this.objectCategoryBuilderFactory.get()).setDefault();
        String dataName = ((ObjectCategoryData)data).getName();
        ((ObjectCategory.Builder)objectCategoryBuilder).setName(dataName);
        ((ObjectCategory.Builder)objectCategoryBuilder).setProtection(((ObjectCategoryData)data).getProtection());
        ((ObjectCategoryData)data).getSettingOverrideIterator().forEachRemaining(new Consumer<Map.Entry<String, Object>>(){

            @Override
            public void accept(Map.Entry<String, Object> e) {
                ObjectCategorySetting setting = (ObjectCategorySetting)ObjectCategorySerializationHandler.this.settingTypeGetter.apply(e.getKey());
                if (setting != null) {
                    ObjectCategorySerializationHandler.this.setSettingValue(objectCategoryBuilder, setting, e.getValue());
                }
            }
        });
        ((ObjectCategoryData)data).getSubCategoryIterator().forEachRemaining(new Consumer<D>((ObjectCategory.Builder)objectCategoryBuilder){
            final /* synthetic */ ObjectCategory.Builder val$objectCategoryBuilder;
            {
                this.val$objectCategoryBuilder = builder;
            }

            @Override
            public void accept(D subCategory) {
                this.val$objectCategoryBuilder.addSubCategoryBuilder(ObjectCategorySerializationHandler.this.getConfiguredCategoryBuilderForData(subCategory));
            }
        });
        return objectCategoryBuilder;
    }

    private <T> void setSettingValue(B objectCategoryBuilder, ObjectCategorySetting<T> setting, Object value) {
        ((ObjectCategory.Builder)objectCategoryBuilder).setSettingValue(setting, (Object)value);
    }

    public static abstract class Builder<D extends ObjectCategoryData<D>, C extends ObjectCategory<D, C>, B extends ObjectCategory.Builder<C, B>, DB extends ObjectCategoryData.Builder<D, DB>, SH extends ObjectCategorySerializationHandler<D, C, B, DB>, SHB extends Builder<D, C, B, DB, SH, SHB>> {
        protected final SHB self = this;
        protected final ObjectCategoryDataSerializer.Builder<D> serializerBuilder;
        protected Supplier<DB> dataBuilderFactory;
        protected Supplier<B> objectCategoryBuilderFactory;
        protected Function<String, ObjectCategorySetting<?>> settingTypeGetter;

        public Builder(ObjectCategoryDataSerializer.Builder<D> serializerBuilder) {
            this.serializerBuilder = serializerBuilder;
        }

        public SHB setDefault() {
            this.setDataBuilderFactory(null);
            this.setObjectCategoryBuilderFactory(null);
            this.setSettingTypeGetter(null);
            return this.self;
        }

        public SHB setDataBuilderFactory(Supplier<DB> dataBuilderFactory) {
            this.dataBuilderFactory = dataBuilderFactory;
            return this.self;
        }

        public SHB setObjectCategoryBuilderFactory(Supplier<B> objectCategoryBuilderFactory) {
            this.objectCategoryBuilderFactory = objectCategoryBuilderFactory;
            return this.self;
        }

        public SHB setSettingTypeGetter(Function<String, ObjectCategorySetting<?>> settingTypeGetter) {
            this.settingTypeGetter = settingTypeGetter;
            return this.self;
        }

        public SH build() {
            if (this.dataBuilderFactory == null || this.objectCategoryBuilderFactory == null || this.settingTypeGetter == null) {
                throw new IllegalStateException("required fields not set!");
            }
            return this.buildInternally();
        }

        protected abstract SH buildInternally();
    }
}

