/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.data.options;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorOptionData;
import xaero.common.category.ui.entry.CategorySettingsListMainEntryFactory;
import xaero.common.graphics.CursorBox;

public abstract class GuiCategoryUIEditorOptionsData<V>
extends GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorOptionData<V>> {
    protected GuiCategoryUIEditorOptionData<V> currentValue;
    protected Supplier<String> messageSupplier;
    protected final String displayName;
    private final IOptionsDataIsActiveSupplier isActiveSupplier;

    protected GuiCategoryUIEditorOptionsData(@Nonnull String displayName, boolean movable, CategorySettingsListMainEntryFactory listEntryFactory, BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorOptionData<V>>, Supplier<CursorBox>> tooltipSupplier, IOptionsDataIsActiveSupplier isActiveSupplier) {
        super(movable, listEntryFactory, tooltipSupplier);
        this.displayName = displayName;
        this.isActiveSupplier = isActiveSupplier;
    }

    public GuiCategoryUIEditorOptionData<V> getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(GuiCategoryUIEditorOptionData<V> currentValue) {
        this.currentValue = currentValue;
    }

    public final Supplier<String> getMessageSupplier() {
        if (this.messageSupplier == null) {
            this.messageSupplier = new Supplier<String>(){

                @Override
                public String get() {
                    return GuiCategoryUIEditorOptionsData.this.isExpanded() ? GuiCategoryUIEditorOptionsData.this.displayName : String.format("%s: %s", GuiCategoryUIEditorOptionsData.this.displayName, GuiCategoryUIEditorOptionsData.this.currentValue.getDisplayName());
                }
            };
        }
        return this.messageSupplier;
    }

    public IOptionsDataIsActiveSupplier getIsActiveSupplier() {
        return this.isActiveSupplier;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @FunctionalInterface
    public static interface IOptionsDataIsActiveSupplier {
        public boolean get(GuiCategoryUIEditorExpandableData<?> var1, GuiCategoryUIEditorOptionsData<?> var2);
    }

    public static abstract class Builder<V, B extends Builder<V, B>>
    extends GuiCategoryUIEditorExpandableData.Builder<GuiCategoryUIEditorOptionData<V>, B> {
        protected B self = this;
        protected V currentValue;
        protected String displayName;
        protected IOptionsDataIsActiveSupplier isActiveSupplier;

        protected Builder() {
        }

        @Override
        public B setDefault() {
            super.setDefault();
            this.setCurrentValue(null);
            this.setDisplayName(null);
            this.setIsActiveSupplier(new IOptionsDataIsActiveSupplier(){

                @Override
                public boolean get(GuiCategoryUIEditorExpandableData<?> p, GuiCategoryUIEditorOptionsData<?> d) {
                    return true;
                }
            });
            return this.self;
        }

        public B setCurrentValue(V currentValue) {
            this.currentValue = currentValue;
            return this.self;
        }

        public B setDisplayName(String displayName) {
            this.displayName = displayName;
            return this.self;
        }

        public B setIsActiveSupplier(IOptionsDataIsActiveSupplier isActiveSupplier) {
            this.isActiveSupplier = isActiveSupplier;
            return this.self;
        }

        @Override
        public GuiCategoryUIEditorOptionsData<V> build() {
            if (this.displayName == null) {
                throw new IllegalStateException("required fields not set!");
            }
            GuiCategoryUIEditorOptionsData result = (GuiCategoryUIEditorOptionsData)super.build();
            return result;
        }

        @Override
        protected abstract GuiCategoryUIEditorOptionsData<V> buildInternally();
    }
}

