/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentSkipListSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiClearSet;
import xaero.common.gui.GuiDeleteSet;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypointsOptions;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.common.misc.KeySortableByOther;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

@SideOnly(value=Side.CLIENT)
public class GuiWaypoints
extends ScreenBase
implements IDropDownCallback {
    private static final int TEMPORARY = 0;
    private static final int DISABLED = 1;
    private static final int SERVER = 2;
    public static final int ROTATION = 3;
    private static final int FRAME_TOP_SIZE = 58;
    private static final int FRAME_BOTTOM_SIZE = 61;
    public static double distanceDivided;
    private List list;
    private WaypointWorld displayedWorld;
    private ConcurrentSkipListSet<Integer> selectedListSet;
    private ArrayList<GuiDropDown> dropDowns;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private GuiDropDown containersDD;
    private GuiDropDown worldsDD;
    private GuiDropDown setsDD;
    private XaeroMinimapSession minimapSession;
    private WaypointsManager waypointsManager;
    private int draggingFromX;
    private int draggingFromY;
    private int draggingFromSlot;
    private Waypoint draggingWaypoint;
    private boolean dropped = false;
    private boolean displayingTeleportableWorld;
    private int shiftSelectFirst;
    private ArrayList<Waypoint> waypointsSorted;
    private final String frozenAutoContainerID;
    private final String frozenAutoWorldID;
    private boolean buttonClicked;

    public GuiWaypoints(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, GuiScreen par1GuiScreen) {
        this(modMain, minimapSession, par1GuiScreen, null);
    }

    public GuiWaypoints(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, GuiScreen par1GuiScreen, GuiScreen escapeScreen) {
        super(modMain, par1GuiScreen, escapeScreen);
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.selectedListSet = new ConcurrentSkipListSet();
        this.dropDowns = new ArrayList();
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.frozenAutoContainerID = this.waypointsManager.getAutoContainerID();
        this.frozenAutoWorldID = this.waypointsManager.getAutoWorldID();
        this.displayedWorld = this.waypointsManager.getCurrentWorld(this.frozenAutoContainerID, this.frozenAutoWorldID);
        String currentContainer = this.displayedWorld.getContainer().getRootContainer().getKey();
        this.containers = new GuiWaypointContainers(modMain, this.waypointsManager, currentContainer, this.frozenAutoContainerID);
        this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, this.displayedWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
        this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
        this.waypointsSorted = new ArrayList();
    }

    @Override
    public void func_73866_w_() {
        this.updateSortedList();
        this.sets = new GuiWaypointSets(true, this.displayedWorld, this.displayedWorld.getCurrent());
        this.field_146292_n.clear();
        this.field_146292_n.add(new MyTinyButton(5, this.field_146294_l / 2 + 129, this.field_146295_m - 53, I18n.func_135052_a((String)"gui.xaero_delete", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(6, this.field_146294_l / 2 - 100, this.field_146295_m - 29, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.field_146292_n.add(new MyTinyButton(7, this.field_146294_l / 2 - 203, this.field_146295_m - 53, I18n.func_135052_a((String)"gui.xaero_add_edit", (Object[])new Object[0])));
        this.field_146292_n.add(new MyTinyButton(8, this.field_146294_l / 2 - 120, this.field_146295_m - 53, I18n.func_135052_a((String)"gui.xaero_waypoint_teleport", (Object[])new Object[0]) + " (T)"));
        this.field_146292_n.add(new MyTinyButton(9, this.field_146294_l / 2 + 46, this.field_146295_m - 53, I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0])));
        this.field_146292_n.add(new MyTinyButton(10, this.field_146294_l / 2 + 130, 32, I18n.func_135052_a((String)"gui.xaero_clear", (Object[])new Object[0])));
        this.field_146292_n.add(new MyTinyButton(11, this.field_146294_l / 2 - 203, 32, I18n.func_135052_a((String)"gui.xaero_options", (Object[])new Object[0])));
        this.field_146292_n.add(new MyTinyButton(12, this.field_146294_l / 2 - 37, this.field_146295_m - 53, I18n.func_135052_a((String)"gui.xaero_share", (Object[])new Object[0])));
        this.list = new List();
        this.list.func_148134_d(7, 8);
        this.dropDowns.clear();
        this.containersDD = new GuiDropDown(this.containers.options, this.field_146294_l / 2 - 202, 17, 200, this.containers.current, this);
        this.dropDowns.add(this.containersDD);
        this.worldsDD = new GuiDropDown(this.worlds.options, this.field_146294_l / 2 + 2, 17, 200, this.worlds.current, this);
        this.dropDowns.add(this.worldsDD);
        this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 100, 33, 200, this.sets.getCurrentSet(), this);
        this.dropDowns.add(this.setsDD);
    }

    @Override
    protected void func_146284_a(GuiButton p_146284_1_) {
        this.buttonClicked = true;
        if (p_146284_1_.field_146124_l) {
            switch (p_146284_1_.field_146127_k) {
                case 5: {
                    Waypoint w;
                    if (!this.isSomethingSelected()) break;
                    this.undrag();
                    boolean shouldRestore = true;
                    for (int i : this.selectedListSet) {
                        w = this.list.getWaypoint(i);
                        if (w.isTemporary()) continue;
                        shouldRestore = false;
                        w.setTemporary(true);
                    }
                    if (shouldRestore) {
                        for (int i : this.selectedListSet) {
                            w = this.list.getWaypoint(i);
                            w.setTemporary(false);
                        }
                    }
                    try {
                        this.modMain.getSettings().saveWaypoints(this.displayedWorld);
                    }
                    catch (IOException e) {
                        MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                    break;
                }
                case 6: {
                    this.goBack();
                    break;
                }
                case 7: {
                    if (!this.isAddEditEnabled()) {
                        return;
                    }
                    ArrayList<Waypoint> selectedWaypoints = this.getSelectedWaypointsList(false);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiAddWaypoint(this.modMain, this.waypointsManager, this, this.escape, selectedWaypoints, this.displayedWorld.getContainer().getRootContainer().getKey(), this.displayedWorld, this.displayedWorld.getCurrent(), selectedWaypoints.isEmpty()));
                    this.list.setSelected(-1);
                    break;
                }
                case 8: {
                    if (!this.canTeleport()) {
                        return;
                    }
                    this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
                    this.waypointsManager.teleportToWaypoint(this.list.getWaypoint(this.selectedListSet.first()), this.displayedWorld, this);
                    break;
                }
                case 9: {
                    if (!this.isSomethingSelected()) {
                        return;
                    }
                    ArrayList<Waypoint> selectedWaypoints = this.getSelectedWaypointsList(true);
                    if (GuiWaypoints.allWaypointsAre(selectedWaypoints, 0)) {
                        for (Waypoint selected : selectedWaypoints) {
                            this.displayedWorld.getCurrentSet().getList().remove(selected);
                        }
                        this.selectedListSet.clear();
                    } else if (GuiWaypoints.allWaypointsAre(selectedWaypoints, 1)) {
                        for (Waypoint selected : selectedWaypoints) {
                            selected.setDisabled(false);
                        }
                    } else {
                        for (Waypoint selected : selectedWaypoints) {
                            selected.setDisabled(true);
                        }
                    }
                    this.updateSortedList();
                    try {
                        this.modMain.getSettings().saveWaypoints(this.displayedWorld);
                    }
                    catch (IOException e) {
                        MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                    break;
                }
                case 10: {
                    String[] worldKeys = this.worlds.getCurrentKeys();
                    if (this.shouldDeleteSet()) {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiDeleteSet(this.modMain, I18n.func_135052_a((String)this.sets.getOptions()[this.sets.getCurrentSet()], (Object[])new Object[0]), worldKeys[0], worldKeys[1], this.sets.getOptions()[this.sets.getCurrentSet()], this, this.escape, this.minimapSession));
                        break;
                    }
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiClearSet(this.modMain, I18n.func_135052_a((String)this.sets.getOptions()[this.sets.getCurrentSet()], (Object[])new Object[0]), worldKeys[0], worldKeys[1], this.sets.getOptions()[this.sets.getCurrentSet()], this, this.escape, this.minimapSession));
                    break;
                }
                case 11: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiWaypointsOptions(this.modMain, this.minimapSession, this, this.escape, this.displayedWorld, this.frozenAutoContainerID, this.frozenAutoWorldID));
                    break;
                }
                case 12: {
                    Waypoint selected;
                    if (!this.isOneSelected()) {
                        return;
                    }
                    Waypoint waypoint = selected = this.selectedListSet.isEmpty() ? null : this.list.getWaypoint(this.selectedListSet.first());
                    if (selected == null) break;
                    this.minimapSession.getWaypointSharing().shareWaypoint(this, selected, this.displayedWorld);
                }
            }
        }
    }

    private ArrayList<Waypoint> getSelectedWaypointsList(boolean includeServer) {
        ArrayList<Waypoint> result = new ArrayList<Waypoint>();
        for (Integer i : this.selectedListSet) {
            Waypoint w = this.list.getWaypoint(i);
            if (!includeServer && w.isServerWaypoint()) continue;
            result.add(w);
        }
        return result;
    }

    public static boolean allWaypointsAre(ArrayList<Waypoint> waypoints, int predicate) {
        boolean allTrue = true;
        block0 : switch (predicate) {
            case 0: {
                for (Waypoint w : waypoints) {
                    if (w.isTemporary()) continue;
                    allTrue = false;
                    break block0;
                }
                break;
            }
            case 1: {
                for (Waypoint w : waypoints) {
                    if (w.isDisabled()) continue;
                    allTrue = false;
                    break block0;
                }
                break;
            }
            case 2: {
                for (Waypoint w : waypoints) {
                    if (w.isServerWaypoint()) continue;
                    allTrue = false;
                    break block0;
                }
                break;
            }
            case 3: {
                for (Waypoint w : waypoints) {
                    if (w.isRotation()) continue;
                    allTrue = false;
                    break block0;
                }
                break;
            }
        }
        return allTrue;
    }

    public boolean shouldDeleteSet() {
        return !this.sets.getOptions()[this.sets.getCurrentSet()].equals("gui.xaero_default") && this.displayedWorld.getCurrentSet().getList().isEmpty();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel() / 120;
        if (wheel != 0) {
            ScaledResolution scaledResolution = new ScaledResolution(this.field_146297_k);
            int mouseXScaled = Mouse.getX() / scaledResolution.func_78325_e();
            int mouseYScaled = scaledResolution.func_78328_b() - 1 - Mouse.getY() / scaledResolution.func_78325_e();
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.field_146295_m)) continue;
                d.mouseScrolled(wheel, mouseXScaled, mouseYScaled, this.field_146295_m);
                return;
            }
        }
        if (!this.dropped) {
            this.list.func_178039_p();
        }
    }

    private void undrag() {
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.draggingWaypoint = null;
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown(par1, par2, this.field_146295_m)) {
                d.mouseClicked(par1, par2, par3, this.field_146295_m);
                return;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown(par1, par2, this.field_146295_m)) {
                d.mouseClicked(par1, par2, par3, this.field_146295_m);
                return;
            }
            d.setClosed(true);
        }
        if (this.dropped) {
            return;
        }
        if (par3 == 0) {
            if (par2 >= 58 && par2 < this.field_146295_m - 61 && this.displayedWorld.getContainer().getRootContainer().getSortType() == WaypointsSort.NONE) {
                this.draggingFromX = par1;
                this.draggingFromY = par2;
                this.draggingFromSlot = this.list.func_148124_c(par1, par2);
                if (this.draggingFromSlot >= this.displayedWorld.getCurrentSet().getList().size()) {
                    this.draggingFromSlot = -1;
                }
            }
        } else {
            this.list.setSelected(-1);
        }
        this.buttonClicked = false;
        super.func_73864_a(par1, par2, par3);
        if (!this.buttonClicked && Misc.inputMatchesKeyBinding(true, par3, ModSettings.keyWaypoints)) {
            this.goBack();
        }
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        try {
            if (this.draggingWaypoint != null) {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        this.undrag();
        super.func_146286_b(par1, par2, par3);
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased(par1, par2, par3, this.field_146295_m);
        }
    }

    @Override
    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        switch (par2) {
            case 211: {
                if (!((GuiButton)this.field_146292_n.get((int)4)).field_146124_l) break;
                for (int i : this.selectedListSet) {
                    this.list.getWaypoint(i).setTemporary(true);
                }
                this.func_146284_a((GuiButton)this.field_146292_n.get(4));
                break;
            }
            case 20: {
                this.func_146284_a((GuiButton)this.field_146292_n.get(3));
                break;
            }
            default: {
                if (!Misc.inputMatchesKeyBinding(false, par2, ModSettings.keyWaypoints)) break;
                this.goBack();
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int k;
        if (this.field_146297_k.field_71439_g == null) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        this.updateButtons();
        this.list.func_148128_a(par1, par2, par3);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_world_server", (Object[])new Object[0]), this.field_146294_l / 2 - 102, 5, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_subworld_dimension", (Object[])new Object[0]), this.field_146294_l / 2 + 102, 5, 0xFFFFFF);
        if (this.draggingFromSlot != -1) {
            int distance = (int)Math.sqrt(Math.pow(par1 - this.draggingFromX, 2.0) + Math.pow(par2 - this.draggingFromY, 2.0));
            int toSlot = Math.min(this.displayedWorld.getCurrentSet().getList().size() - 1, this.list.func_148124_c(par1, par2));
            if (distance > 4 && this.draggingWaypoint == null) {
                this.draggingWaypoint = this.displayedWorld.getCurrentSet().getList().get(this.draggingFromSlot);
                this.list.setSelected(-1);
            }
            if (this.draggingWaypoint != null && this.draggingFromSlot != toSlot && toSlot != -1) {
                int direction = toSlot > this.draggingFromSlot ? 1 : -1;
                for (int i = this.draggingFromSlot; i != toSlot; i += direction) {
                    this.displayedWorld.getCurrentSet().getList().set(i, this.displayedWorld.getCurrentSet().getList().get(i + direction));
                }
                this.displayedWorld.getCurrentSet().getList().set(toSlot, this.draggingWaypoint);
                this.draggingFromSlot = toSlot;
            }
            int fromCenter = this.draggingFromX - this.list.field_148155_a / 2;
            this.list.drawWaypointSlot(this.draggingWaypoint, par1 - 108 - fromCenter, par2 - this.list.field_148149_f / 4);
        }
        if (this.dropped) {
            super.func_73863_a(0, 0, par3);
        } else {
            super.func_73863_a(par1, par2, par3);
        }
        this.dropped = false;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) {
                this.dropDowns.get(k).drawButton(par1, par2, this.field_146295_m);
                continue;
            }
            this.dropped = true;
        }
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) continue;
            this.dropDowns.get(k).drawButton(par1, par2, this.field_146295_m);
        }
        GlStateManager.func_179121_F();
    }

    private void updateButtons() {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = this.isSomethingSelected();
        ((GuiButton)this.field_146292_n.get((int)7)).field_146124_l = this.isOneSelected();
        ((GuiButton)this.field_146292_n.get((int)3)).field_146124_l = this.canTeleport();
        ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = this.isAddEditEnabled();
        ArrayList<Waypoint> selectedWaypointsList = this.getSelectedWaypointsList(true);
        ((GuiButton)this.field_146292_n.get((int)5)).field_146126_j = I18n.func_135052_a((String)(this.shouldDeleteSet() ? "gui.xaero_delete_set" : "gui.xaero_clear"), (Object[])new Object[0]);
        if (this.isSomethingSelected() && GuiWaypoints.allWaypointsAre(selectedWaypointsList, 0)) {
            ((GuiButton)this.field_146292_n.get((int)4)).field_146126_j = I18n.func_135052_a((String)"gui.xaero_delete", (Object[])new Object[0]);
            ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = I18n.func_135052_a((String)"gui.xaero_restore", (Object[])new Object[0]);
        } else {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = I18n.func_135052_a((String)"gui.xaero_delete", (Object[])new Object[0]);
            String[] enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
            ((GuiButton)this.field_146292_n.get((int)4)).field_146126_j = enabledisable[!GuiWaypoints.allWaypointsAre(selectedWaypointsList, 1) ? 0 : 1];
        }
    }

    private boolean isAddEditEnabled() {
        ArrayList<Waypoint> selectedWaypointsList = this.getSelectedWaypointsList(true);
        return selectedWaypointsList.isEmpty() || !GuiWaypoints.allWaypointsAre(selectedWaypointsList, 2);
    }

    private boolean isSomethingSelected() {
        return !this.selectedListSet.isEmpty();
    }

    private boolean isOneSelected() {
        return this.selectedListSet.size() == 1;
    }

    private boolean canTeleport() {
        return this.isOneSelected() && (this.modMain.getSettings().allowWrongWorldTeleportation || this.displayingTeleportableWorld) && this.displayedWorld.getContainer().getRootContainer().isTeleportationEnabled();
    }

    @Override
    public boolean onSelected(GuiDropDown menu, int selectedIndex) {
        if (menu == this.containersDD || menu == this.worldsDD) {
            if (menu == this.containersDD) {
                this.containers.current = selectedIndex;
                if (this.containers.current != this.containers.auto) {
                    WaypointWorld firstWorld = this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld();
                    this.waypointsManager.setCustomContainerID(firstWorld.getContainer().getKey());
                    this.waypointsManager.setCustomWorldID(firstWorld.getId());
                } else {
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.setCustomWorldID(null);
                }
                this.displayedWorld = this.waypointsManager.getCurrentWorld(this.frozenAutoContainerID, this.frozenAutoWorldID);
                this.updateSortedList();
                this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, this.displayedWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
                this.worldsDD = new GuiDropDown(this.worlds.options, this.field_146294_l / 2 + 2, 17, 200, this.worlds.current, this);
                this.dropDowns.set(1, this.worldsDD);
            } else if (menu == this.worldsDD) {
                this.worlds.current = selectedIndex;
                if (this.worlds.current != this.worlds.auto) {
                    String[] keys = this.worlds.getCurrentKeys();
                    this.waypointsManager.setCustomContainerID(keys[0]);
                    this.waypointsManager.setCustomWorldID(keys[1]);
                } else {
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.setCustomWorldID(null);
                }
                this.displayedWorld = this.waypointsManager.getCurrentWorld(this.frozenAutoContainerID, this.frozenAutoWorldID);
                this.updateSortedList();
            }
            this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
            this.waypointsManager.updateWaypoints();
            this.list.setSelected(-1);
            this.sets = new GuiWaypointSets(true, this.displayedWorld, this.displayedWorld.getCurrent());
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 100, 33, 200, this.sets.getCurrentSet(), this);
            this.dropDowns.set(2, this.setsDD);
            return true;
        }
        if (menu == this.setsDD) {
            this.list.setSelected(-1);
            if (selectedIndex == menu.size() - 1) {
                MinimapLogs.LOGGER.info("New waypoint set gui");
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNewSet(this.modMain, this.minimapSession, this, this.escape, this.displayedWorld));
                return false;
            }
            this.sets.setCurrentSet(selectedIndex);
            this.displayedWorld.setCurrent(this.sets.getCurrentSetKey());
            this.updateSortedList();
            this.waypointsManager.updateWaypoints();
            try {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private void updateSortedList() {
        Vec3d lookVector;
        WaypointsSort sortType = this.displayedWorld.getContainer().getRootContainer().getSortType();
        if (sortType == WaypointsSort.NONE) {
            this.waypointsSorted = this.displayedWorld.getCurrentSet().getList();
            return;
        }
        distanceDivided = this.waypointsManager.getDimensionDivision(this.displayedWorld.getContainer().getKey());
        ArrayList<KeySortableByOther<Waypoint>> sortableKeys = new ArrayList<KeySortableByOther<Waypoint>>();
        Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
        Vec3d cameraPos = ActiveRenderInfo.getCameraPosition().func_72441_c(renderViewEntity.field_70165_t, renderViewEntity.field_70163_u, renderViewEntity.field_70161_v);
        Vec3d vec3d = lookVector = renderViewEntity == null ? new Vec3d(1.0, 0.0, 0.0) : renderViewEntity.func_70040_Z();
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2) {
            lookVector = lookVector.func_186678_a(-1.0);
        }
        for (Waypoint waypoint : this.displayedWorld.getCurrentSet().getList()) {
            sortableKeys.add(new KeySortableByOther<Waypoint>(waypoint, (Comparable)(sortType == WaypointsSort.ANGLE ? Double.valueOf(-waypoint.getComparisonAngleCos(cameraPos, lookVector, distanceDivided)) : (sortType == WaypointsSort.NAME ? waypoint.getComparisonName() : (sortType == WaypointsSort.SYMBOL ? waypoint.getSymbol() : Double.valueOf(waypoint.getComparisonDistance(cameraPos, distanceDivided)))))));
        }
        Collections.sort(sortableKeys);
        this.waypointsSorted = new ArrayList();
        for (KeySortableByOther keySortableByOther : sortableKeys) {
            this.waypointsSorted.add((Waypoint)keySortableByOther.getKey());
        }
        if (this.displayedWorld.getContainer().getRootContainer().isSortReversed()) {
            Collections.reverse(this.waypointsSorted);
        }
    }

    @SideOnly(value=Side.CLIENT)
    class List
    extends GuiSlot {
        private int lastClickedThisFrame;

        public List() {
            super(GuiWaypoints.this.field_146297_k, GuiWaypoints.this.field_146294_l, GuiWaypoints.this.field_146295_m, 58, Math.max(62, GuiWaypoints.this.field_146295_m - 61), 18);
            this.lastClickedThisFrame = -1;
        }

        protected int func_148127_b() {
            int size = GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size();
            if (GuiWaypoints.this.waypointsManager.getServerWaypoints() != null) {
                size += GuiWaypoints.this.waypointsManager.getServerWaypoints().size();
            }
            return size;
        }

        private Waypoint getWaypoint(int slotIndex) {
            int serverWPIndex;
            Waypoint waypoint = null;
            if (slotIndex < GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size()) {
                waypoint = (Waypoint)GuiWaypoints.this.waypointsSorted.get(slotIndex);
            } else if (GuiWaypoints.this.waypointsManager.getServerWaypoints() != null && (serverWPIndex = slotIndex - GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size()) < GuiWaypoints.this.waypointsManager.getServerWaypoints().size()) {
                waypoint = GuiWaypoints.this.waypointsManager.getServerWaypoints().get(serverWPIndex);
            }
            return waypoint;
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            if (slotIndex != this.lastClickedThisFrame) {
                this.setSelected(slotIndex);
                this.lastClickedThisFrame = slotIndex;
            }
        }

        public void setSelected(int index) {
            if (index == -1) {
                GuiWaypoints.this.selectedListSet.clear();
                GuiWaypoints.this.shiftSelectFirst = -1;
                return;
            }
            int currentSize = GuiWaypoints.this.selectedListSet.size();
            boolean shiftPressed = GuiScreen.func_146272_n();
            if ((currentSize > 1 || currentSize == 1 && (Integer)GuiWaypoints.this.selectedListSet.first() != index) && !GuiScreen.func_146271_m() && !shiftPressed) {
                GuiWaypoints.this.selectedListSet.clear();
            }
            if (currentSize > 0 && shiftPressed) {
                int direction = index > GuiWaypoints.this.shiftSelectFirst ? 1 : -1;
                GuiWaypoints.this.selectedListSet.clear();
                for (int i = GuiWaypoints.this.shiftSelectFirst; i != index + direction; i += direction) {
                    GuiWaypoints.this.selectedListSet.add(i);
                }
            } else if (GuiWaypoints.this.selectedListSet.contains(index)) {
                GuiWaypoints.this.selectedListSet.remove(index);
            } else {
                GuiWaypoints.this.shiftSelectFirst = index;
                GuiWaypoints.this.selectedListSet.add(index);
            }
        }

        protected boolean func_148131_a(int p_148131_1_) {
            return !GuiWaypoints.this.selectedListSet.isEmpty() && GuiWaypoints.this.selectedListSet.contains(p_148131_1_);
        }

        protected int func_148138_e() {
            return this.func_148127_b() * 18;
        }

        protected void func_148123_a() {
            this.lastClickedThisFrame = -1;
            GuiWaypoints.this.func_146276_q_();
        }

        public void func_192637_a(int p_192637_1_, int p_192637_2_, int p_192637_3_, int p_192637_4_, int p_192637_5_, int p_192637_6_, float p_192637_7_) {
            Waypoint w = this.getWaypoint(p_192637_1_);
            if (w == GuiWaypoints.this.draggingWaypoint) {
                return;
            }
            this.drawWaypointSlot(w, p_192637_2_, p_192637_3_);
        }

        public void drawWaypointSlot(Waypoint w, int p_180791_2_, int p_180791_3_) {
            if (w == null) {
                return;
            }
            GuiWaypoints.this.func_73732_a(GuiWaypoints.this.field_146289_q, w.getLocalizedName() + (w.isDisabled() ? " \u00a74" + I18n.func_135052_a((String)"gui.xaero_disabled", (Object[])new Object[0]) : (w.isTemporary() ? " \u00a74" + I18n.func_135052_a((String)"gui.xaero_temporary", (Object[])new Object[0]) : "")), p_180791_2_ + 110, p_180791_3_ + 1, 0xFFFFFF);
            int rectX = p_180791_2_ + 8 + 4;
            int rectY = p_180791_3_ + 6;
            if (w.isGlobal()) {
                GuiWaypoints.this.func_73732_a(GuiWaypoints.this.field_146289_q, "*", rectX - 25, rectY - 3, 0xFFFFFF);
            }
            GuiWaypoints.this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawIconOnGUI(w, GuiWaypoints.this.modMain.getSettings(), rectX, rectY);
        }

        public boolean func_148125_i() {
            if (GuiWaypoints.this.dropped || GuiWaypoints.this.draggingWaypoint != null) {
                return false;
            }
            return super.func_148125_i();
        }
    }
}

