/*
 * Decompiled with CFR 0.152.
 */
package josephcsible.oreberries;

import javax.annotation.Nullable;
import josephcsible.oreberries.OreberriesMod;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Triple;

public final class RecipeUtils {
    private static int recipeCounter = 0;

    private RecipeUtils() {
    }

    @Nullable
    public static Triple<String, String, String> splitItemName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        String metadata = null;
        int colonPos = name.indexOf(58);
        if (colonPos == -1) {
            return Triple.of(null, (Object)name, null);
        }
        String modname = name.substring(0, colonPos);
        String itemname = name.substring(colonPos + 1);
        if ((colonPos = itemname.indexOf(58)) != -1) {
            metadata = itemname.substring(colonPos + 1);
            itemname = itemname.substring(0, colonPos);
        }
        return Triple.of((Object)modname, (Object)itemname, metadata);
    }

    @Nullable
    public static ItemStack getItemFromName(Triple<String, String, String> name) {
        int metadata;
        if (name.getRight() != null) {
            try {
                metadata = Integer.parseInt((String)name.getRight());
            }
            catch (NumberFormatException e) {
                OreberriesMod.logger.warn("Ignoring item with invalid metadata: {}", name);
                return null;
            }
        } else {
            metadata = 0;
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation((String)name.getLeft(), (String)name.getMiddle()));
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1, metadata);
    }

    @Nullable
    public static ItemStack getItemFromOredict(String name, @Nullable Item exclude) {
        NonNullList ores = OreDictionary.getOres((String)name);
        if (ores.isEmpty()) {
            return null;
        }
        ItemStack stack = (ItemStack)ores.get(0);
        if (stack.func_77973_b() == exclude) {
            if (ores.size() == 1) {
                return null;
            }
            stack = (ItemStack)ores.get(1);
        }
        return stack;
    }

    public static ResourceLocation getNewRecipeName() {
        return new ResourceLocation("oreberries", "recipe_" + ++recipeCounter);
    }
}

