/*
 * Decompiled with CFR 0.152.
 */
package josephcsible.oreberries.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import josephcsible.oreberries.config.OreberryConfig;
import net.minecraft.util.text.translation.I18n;

public class NuggetConfig {
    protected final OreberryConfig oreberry;
    public final String name;
    public final String color;
    public final List<String> oredictNames;
    public final List<String> ingotNames;

    public NuggetConfig(OreberryConfig oreberry, JsonObject json) {
        Gson gson = new Gson();
        this.oreberry = oreberry;
        JsonElement jsonName = json.get("name");
        this.name = jsonName == null ? this.getDefaultName() : jsonName.getAsString();
        JsonElement jsonColor = json.get("color");
        this.color = jsonColor == null ? this.getDefaultColor() : jsonColor.getAsString();
        JsonElement jsonOredictNames = json.get("oredictNames");
        this.oredictNames = jsonOredictNames == null ? this.getDefaultOredictNames() : Arrays.asList((Object[])gson.fromJson(jsonOredictNames, String[].class));
        JsonElement jsonIngotNames = json.get("ingotNames");
        this.ingotNames = jsonIngotNames == null ? this.getDefaultIngotNames() : Arrays.asList((Object[])gson.fromJson(jsonIngotNames, String[].class));
    }

    protected String getDefaultName() {
        return I18n.func_74837_a((String)"item.oreberries.nugget.name", (Object[])new Object[]{this.oreberry.name});
    }

    protected String getDefaultColor() {
        return this.oreberry.color;
    }

    protected List<String> getDefaultOredictNames() {
        return this.oreberry.oredictNames;
    }

    protected List<String> getDefaultIngotNames() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("ingot" + OreberryConfig.firstUpper(this.oreberry.name));
        return retval;
    }

    public JsonObject toJson() {
        Gson gson = new Gson();
        JsonObject json = new JsonObject();
        if (!this.name.equals(this.getDefaultName())) {
            json.addProperty("name", this.name);
        }
        if (!this.color.equals(this.getDefaultColor())) {
            json.addProperty("color", this.color);
        }
        if (!this.oredictNames.equals(this.getDefaultOredictNames())) {
            json.add("oredictNames", gson.toJsonTree(this.oredictNames));
        }
        if (!this.ingotNames.equals(this.getDefaultIngotNames())) {
            json.add("ingotNames", gson.toJsonTree(this.ingotNames));
        }
        return json;
    }
}

