/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rwtema.extrautils2.backend.IMetaProperty;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.backend.multiblockstate.XUBlockStateMulti;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.MapPopulator;
import net.minecraft.util.math.Cartesian;

public class MultiBlockStateBuilder<T extends XUBlock> {
    public final Class<T> clazz;
    private final List<IProperty<? extends Comparable>> worldProperties = Lists.newArrayList();
    private final List<IProperty<? extends Comparable>> dropProperties = Lists.newArrayList();
    private final List<IProperty<? extends Comparable>> metaProperties = Lists.newArrayList();
    private final HashMap<IProperty, Comparable> defaultValues = Maps.newHashMap();
    private final Constructor<T> constructor;
    private final Object[] parameters;
    public IBlockState[] meta2states;
    public TObjectIntHashMap<IBlockState> states2meta;
    public HashSet<IBlockState> genericPipeStates = new HashSet();
    public HashMap<Map<IProperty<?>, Comparable<?>>, XUBlockState> propertyStateBlockStatesMap;
    public boolean initialized = false;
    public XUBlockStateMulti defaultState;
    public T mainBlock;

    public MultiBlockStateBuilder(Class<T> clazz, Object ... parameters) {
        this.clazz = clazz;
        this.parameters = parameters;
        Class[] parameClazzes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameClazzes[i] = parameters[i] == null ? Integer.TYPE : parameters[i].getClass();
        }
        try {
            this.constructor = clazz.getConstructor(parameClazzes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public MultiBlockStateBuilder<T> addMetaProperties(Collection<IProperty<?>> properties) {
        this.metaProperties.addAll(properties);
        return this;
    }

    public <K extends Comparable<K>> MultiBlockStateBuilder<T> addWorldProperties(Collection<IProperty<K>> properties) {
        this.worldProperties.addAll(properties);
        return this;
    }

    public <K extends Comparable<K>> MultiBlockStateBuilder<T> addDropProperties(Collection<IProperty<K>> properties) {
        this.dropProperties.addAll(properties);
        return this;
    }

    public MultiBlockStateBuilder<T> addWorldProperties(IProperty<?> ... properties) {
        Collections.addAll(this.worldProperties, properties);
        return this;
    }

    public MultiBlockStateBuilder<T> addDropProperties(IProperty<?> ... properties) {
        Collections.addAll(this.dropProperties, properties);
        return this;
    }

    public <K extends Comparable<K>> MultiBlockStateBuilder<T> setDefaultValue(IProperty<K> property, K value) {
        this.defaultValues.put(property, value);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public List<T> createBlocks(T firstBlock) {
        int i;
        IProperty[] worldProperties = this.worldProperties.toArray(new IProperty[0]);
        IProperty[] dropProperties = this.dropProperties.toArray(new IProperty[0]);
        IProperty<?>[] properties = XUBlockStateCreator.joinProperties(worldProperties, dropProperties);
        Arrays.sort(properties, XUBlockStateCreator.property_sorter);
        final IMetaProperty[] metaProperties = this.metaProperties.toArray(new IMetaProperty[0]);
        ArrayList allowedValues = Lists.newArrayList();
        for (IProperty<?> property : properties) {
            allowedValues.add(property.func_177700_c());
        }
        ArrayList propertyStates = Lists.newArrayList((Iterable)Cartesian.func_179321_a((Iterable)allowedValues));
        if (propertyStates.size() < 16) {
            throw new RuntimeException("No of iblockstates = " + propertyStates.size() + " - Dont be silly");
        }
        int numBlocks = (int)Math.ceil((double)propertyStates.size() / 16.0);
        ArrayList blocks = Lists.newArrayListWithCapacity((int)numBlocks);
        if (firstBlock != null) {
            blocks.add(firstBlock);
        }
        while (blocks.size() < numBlocks) {
            try {
                Object[] par = new Object[this.parameters.length];
                for (int i2 = 0; i2 < par.length; ++i2) {
                    par[i2] = this.parameters[i2] == null ? Integer.valueOf(blocks.size()) : this.parameters[i2];
                }
                blocks.add(this.constructor.newInstance(par));
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        }
        this.mainBlock = (XUBlock)blocks.get(0);
        final HashMap<ImmutableMap, XUBlock> propertyStateBlockMap = new HashMap<ImmutableMap, XUBlock>();
        this.propertyStateBlockStatesMap = new HashMap();
        for (int i2 = 0; i2 < propertyStates.size(); ++i2) {
            List propertState = (List)propertyStates.get(i2);
            ImmutableMap immutableMap = ImmutableMap.copyOf((Map)MapPopulator.func_179400_b(Arrays.asList(properties), (Iterable)propertState));
            XUBlock t = (XUBlock)blocks.get(i2 / 16);
            propertyStateBlockMap.put(immutableMap, t);
        }
        this.meta2states = new IBlockState[propertyStates.size()];
        HashMap<XUBlock, 1> map = new HashMap<XUBlock, 1>();
        for (i = 0; i < blocks.size(); ++i) {
            final XUBlock xUBlock = (XUBlock)blocks.get(i);
            final ArrayList myStates = Lists.newArrayList();
            XUBlockStateCreator creator = new XUBlockStateCreator(xUBlock, worldProperties, dropProperties, metaProperties, this.defaultValues){

                @Override
                @Nonnull
                protected BlockStateContainer.StateImplementation createState(@Nonnull Block block, @Nonnull ImmutableMap<IProperty<?>, Comparable<?>> properties) {
                    if (MultiBlockStateBuilder.this.propertyStateBlockStatesMap.containsKey(properties)) {
                        XUBlockState xuBlockState = MultiBlockStateBuilder.this.propertyStateBlockStatesMap.get(properties);
                        xuBlockState.clearPropertyTable();
                        if (xuBlockState.func_177230_c() == xUBlock) {
                            myStates.add(xuBlockState);
                        }
                        return xuBlockState;
                    }
                    HashMap cleanProps = new HashMap((Map<IProperty<?>, Comparable<?>>)properties);
                    for (IMetaProperty metaProperty : metaProperties) {
                        cleanProps.remove(metaProperty);
                    }
                    XUBlock blockIn = (XUBlock)propertyStateBlockMap.get(cleanProps);
                    XUBlockStateMulti state = MultiBlockStateBuilder.this.createXUBlockStateMulti(blockIn, properties, MultiBlockStateBuilder.this.mainBlock);
                    if (blockIn == xUBlock) {
                        myStates.add(state);
                    }
                    MultiBlockStateBuilder.this.propertyStateBlockStatesMap.put((Map<IProperty<?>, Comparable<?>>)properties, state);
                    return state;
                }

                @Nonnull
                public ImmutableList<IBlockState> func_177619_a() {
                    return ImmutableList.copyOf((Collection)myStates);
                }

                @Override
                protected Collection<IBlockState> getMyStates(ImmutableList<IBlockState> validStates) {
                    return myStates;
                }
            };
            creator.mainBlock = this.mainBlock;
            System.arraycopy(creator.meta2state, 0, this.meta2states, i * 16, creator.meta2state.length);
            this.genericPipeStates.addAll(myStates);
            map.put(xUBlock, creator);
        }
        this.states2meta = new TObjectIntHashMap();
        for (i = 0; i < this.meta2states.length; ++i) {
            this.states2meta.put((Object)this.meta2states[i], i);
        }
        Iterator<Object> iterator = this.propertyStateBlockStatesMap.values().iterator();
        while (iterator.hasNext()) {
            void var13_23;
            XUBlockState xUBlockState;
            XUBlockState curState = xUBlockState = iterator.next();
            for (IMetaProperty property : metaProperties) {
                Comparable obj = this.defaultValues.containsKey(property) ? this.defaultValues.get(property) : (Comparable)Collections.min(property.func_177700_c());
                XUBlockState xUBlockState2 = (XUBlockState)var13_23.func_177226_a((IProperty)property, obj);
            }
            this.states2meta.putIfAbsent((Object)curState, this.states2meta.get((Object)var13_23));
        }
        this.defaultState = (XUBlockStateMulti)((XUBlockStateCreator)((Object)map.get(this.mainBlock))).defaultState;
        this.initialized = true;
        for (Map.Entry entry2 : map.entrySet()) {
            ((XUBlock)entry2.getKey()).setBlockState((XUBlockStateCreator)((Object)entry2.getValue()));
        }
        return blocks;
    }

    @Nonnull
    protected XUBlockStateMulti createXUBlockStateMulti(T blockIn, ImmutableMap<IProperty<?>, Comparable<?>> properties, T mainBlock) {
        return new XUBlockStateMulti((Block)blockIn, properties, (XUBlock)mainBlock);
    }
}

