/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.google.common.base.Throwables;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockFull;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.textures.SpriteCompressed;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.blockaccess.BlockAccessDelegate;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BlockCompressed
extends XUBlockFull {
    public final PropertyInteger property_compression;
    private final IBlockState baseState;
    private final String texture;
    private final int max_n;
    private final Block baseBlock;

    public BlockCompressed(IBlockState baseState, String texture, int max_n) {
        super(baseState.func_185904_a());
        this.baseState = baseState;
        this.baseBlock = baseState.func_177230_c();
        this.texture = texture;
        this.max_n = max_n;
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.property_compression = PropertyInteger.func_177719_a((String)("compression_level_" + texture.toLowerCase()), (int)1, (int)max_n);
        this.setBlockState(new XUBlockStateCreator((XUBlock)this, false, new IProperty[]{this.property_compression}));
    }

    @Override
    public void registerTextures() {
        for (int i = 0; i <= this.max_n; ++i) {
            Textures.textureNames.put("compr_" + this.texture + "_" + i, new SpriteCompressed(this.texture, i, MathHelper.func_76129_c((float)(this.max_n * 8)) + 0.5f));
        }
    }

    @Override
    public String getTexture(IBlockState state, EnumFacing side) {
        int i = (Integer)state.func_177229_b((IProperty)this.property_compression);
        return "compr_" + this.texture + "_" + i;
    }

    public boolean canHarvestBlock(IBlockAccess world, final @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return ForgeHooks.canHarvestBlock((Block)this.baseBlock, (EntityPlayer)player, (IBlockAccess)new BlockAccessDelegate(world){

            @Override
            @Nonnull
            public IBlockState func_180495_p(@Nonnull BlockPos p) {
                return p.equals((Object)pos) ? BlockCompressed.this.baseState : super.func_180495_p(pos);
            }
        }, (BlockPos)pos);
    }

    public boolean isFireSource(@Nonnull World worldIn, BlockPos pos, EnumFacing side) {
        IBlockState oldState = worldIn.func_180495_p(pos);
        try {
            worldIn.func_180501_a(pos, this.baseState, 4);
            boolean v = this.baseBlock.isFireSource(worldIn, pos, side);
            worldIn.func_180501_a(pos, oldState, 4);
            return v;
        }
        catch (Throwable err) {
            worldIn.func_180501_a(pos, oldState, 4);
            throw Throwables.propagate((Throwable)err);
        }
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        int value = (Integer)state.func_177229_b((IProperty)this.property_compression);
        return value <= 6;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nonnull Entity exploder, Explosion explosion) {
        int value = (Integer)world.func_180495_p(pos).func_177229_b((IProperty)this.property_compression);
        return this.baseBlock.func_149638_a(exploder) * (float)((int)Math.pow(1.5, value - 1));
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        XUBlockState state = this.xuBlockState.getStateFromItemStack(stack);
        int value = (Integer)state.func_177229_b((IProperty)this.property_compression);
        tooltip.add(Lang.translateArgs("%s Blocks", StringHelper.format(Math.pow(9.0, value))));
    }

    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        int value = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)this.property_compression);
        IBlockState oldState = worldIn.func_180495_p(pos);
        try {
            worldIn.func_180501_a(pos, this.baseState, 4);
            float v = this.baseState.func_185887_b(worldIn, pos) * (float)Math.pow(2.25, value - 1);
            worldIn.func_180501_a(pos, oldState, 4);
            return v;
        }
        catch (Throwable err) {
            worldIn.func_180501_a(pos, oldState, 4);
            throw Throwables.propagate((Throwable)err);
        }
    }
}

