/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.XUItemFlat;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.fluids.FluidColors;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBiomeMarker
extends XUItemFlat {
    public ItemBiomeMarker() {
        this.func_77625_d(1);
    }

    @Nullable
    public static Biome getBiome(ItemStack stack) {
        if (StackHelper.isNull(stack)) {
            return null;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_150297_b("Biome", 8)) {
            return null;
        }
        return (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(tagCompound.func_74779_i("Biome")));
    }

    @Nonnull
    public static ItemStack setBiome(@Nonnull ItemStack itemStackIn, Biome biome) {
        itemStackIn = itemStackIn.func_77946_l();
        ResourceLocation nameForObject = (ResourceLocation)Biome.field_185377_q.func_177774_c((Object)biome);
        if (nameForObject == null) {
            throw new IllegalStateException(biome + " is not registered");
        }
        NBTHelper.getOrInitTagCompound(itemStackIn).func_74778_a("Biome", nameForObject.toString());
        return itemStackIn;
    }

    @Override
    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return super.func_77653_i(stack);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        Biome biome = ItemBiomeMarker.getBiome(stack);
        if (biome != null) {
            tooltip.add(biome.func_185359_l());
        }
    }

    @Override
    public void getSubItemsBase(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        ItemStack stack = new ItemStack(itemIn);
        subItems.add(stack);
        for (Biome biome : Biome.field_185377_q) {
            subItems.add(ItemBiomeMarker.setBiome(stack, biome));
        }
    }

    @Override
    public void registerTextures() {
        Textures.register("biome_marker", "biome_marker_active", "biome_marker_active_0", "biome_marker_active_1", "biome_marker_active_2", "biome_marker_active_3");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addItemColors(ItemColors itemColors, BlockColors blockColors) {
        itemColors.func_186730_a(new IItemColor(){

            public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
                Biome biome = ItemBiomeMarker.getBiome(stack);
                if (biome != null) {
                    float d0 = MathHelper.func_76131_a((float)biome.func_185353_n(), (float)0.0f, (float)1.0f);
                    float d1 = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
                    int color = ColorizerGrass.func_77480_a((double)d0, (double)d1);
                    switch (tintIndex) {
                        case 0: {
                            return biome.getModdedBiomeFoliageColor(color);
                        }
                        case 2: {
                            return biome.getModdedBiomeGrassColor(color);
                        }
                        case 1: {
                            return biome.func_76731_a(d0);
                        }
                        case 3: {
                            int col = (Integer)FluidColors.FLUID_COLOR.getUnchecked((Object)FluidRegistry.WATER);
                            int waterColor = biome.func_185361_o();
                            if (waterColor == -1) {
                                return col;
                            }
                            return ColorHelper.colorClamp(ColorHelper.getRF(col) * ColorHelper.getRF(waterColor), ColorHelper.getGF(col) * ColorHelper.getGF(waterColor), ColorHelper.getBF(col) * ColorHelper.getBF(waterColor), 1.0f);
                        }
                    }
                }
                return -1;
            }
        }, new Item[]{this});
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> onItemRightClickBase(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        Biome biome = ItemBiomeMarker.getBiome(itemStackIn);
        if (biome != null) {
            if (!playerIn.func_70093_af()) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
            }
            NBTTagCompound nbt = itemStackIn.func_77978_p();
            if (nbt != null) {
                nbt.func_82580_o("Biome");
                if (nbt.func_82582_d()) {
                    itemStackIn.func_77982_d(null);
                }
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        Biome biomeForCoordsBody = worldIn.getBiomeForCoordsBody(new BlockPos((Entity)playerIn));
        itemStackIn = ItemBiomeMarker.setBiome(itemStackIn, biomeForCoordsBody);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public String getTexture(@Nullable ItemStack itemStack, int renderPass) {
        if (StackHelper.isNull(itemStack) || ItemBiomeMarker.getBiome(itemStack) == null) {
            return "biome_marker";
        }
        switch (renderPass) {
            default: {
                return "biome_marker_active";
            }
            case 1: {
                return "biome_marker_active_0";
            }
            case 2: {
                return "biome_marker_active_1";
            }
            case 3: {
                return "biome_marker_active_2";
            }
            case 4: 
        }
        return "biome_marker_active_3";
    }

    @Override
    public int getRenderLayers(@Nullable ItemStack itemStack) {
        if (StackHelper.isNull(itemStack) || ItemBiomeMarker.getBiome(itemStack) == null) {
            return 1;
        }
        return 5;
    }

    @Override
    public int getTint(ItemStack stack, int i) {
        if (i == 0 || StackHelper.isNull(stack) || ItemBiomeMarker.getBiome(stack) == null) {
            return -1;
        }
        return i - 1;
    }

    @Override
    public TextureAtlasSprite getBaseTexture() {
        return Textures.getSprite("biome_marker");
    }

    @Override
    public int getMaxMetadata() {
        return 0;
    }

    public static class ItemBiomeHandler
    extends SingleStackHandler {
        @Override
        protected int getStackLimit(@Nonnull ItemStack stack) {
            return stack.func_77973_b() == XU2Entries.biomeMarker.value ? super.getStackLimit(stack) : 0;
        }

        public WidgetSlotItemHandler getSlot(int x, int y) {
            return new WidgetSlotItemHandler(this, 0, x, y){

                @Override
                public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                    super.renderBackground(manager, gui, guiLeft, guiTop);
                    if (!this.func_75216_d()) {
                        ItemStack stack = ItemIngredients.Type.BIOME_MARKER_BLANK.newStack();
                        gui.renderStack(stack, guiLeft + this.getX() + 1, guiTop + this.getY() + 1, "");
                    }
                }

                @Override
                public List<String> getToolTip() {
                    if (this.isEmpty()) {
                        return ImmutableList.of((Object)new ItemStack((Item)XU2Entries.biomeMarker.value).func_82833_r());
                    }
                    return null;
                }
            };
        }

        @Nullable
        public Biome getBiome() {
            return ItemBiomeMarker.getBiome(this.getStack());
        }
    }
}

