/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import java.util.Objects;

public abstract class UnorderedPair<T> {
    public static <E> UnorderedPair<E> of(E a, E b) {
        if (Objects.equals(a, b)) {
            return new Unary(a);
        }
        return new Diff<E>(a, b);
    }

    public abstract T getA();

    public abstract T getB();

    private static class Diff<T>
    extends UnorderedPair<T> {
        final T a;
        final T b;

        protected Diff(T a, T b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Diff)) {
                return false;
            }
            Diff that = (Diff)o;
            return Objects.equals(this.a, that.a) && Objects.equals(this.b, that.b) || Objects.equals(this.a, that.b) && Objects.equals(this.b, that.a);
        }

        public int hashCode() {
            return Objects.hashCode(this.a) + Objects.hashCode(this.b);
        }

        @Override
        public T getA() {
            return this.a;
        }

        @Override
        public T getB() {
            return this.b;
        }
    }

    private static class Unary<T>
    extends UnorderedPair<T> {
        final T key;

        private Unary(T key) {
            this.key = key;
        }

        @Override
        public T getA() {
            return this.key;
        }

        @Override
        public T getB() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Unary)) {
                return false;
            }
            Unary unary = (Unary)o;
            return this.key != null ? this.key.equals(unary.key) : unary.key == null;
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }
    }
}

