/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import gnu.trove.list.TLinkable;
import gnu.trove.list.linked.TLinkedList;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class WeakQueue<T>
extends AbstractQueue<T> {
    final ReferenceQueue<T> q = new ReferenceQueue();
    TLinkedList<Node> list = new TLinkedList();

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.list.size();
    }

    @Override
    public boolean offer(T t) {
        this.expungeStaleEntries();
        return this.list.add((TLinkable)new Node(t));
    }

    @Override
    public T poll() {
        this.expungeStaleEntries();
        return this.list.isEmpty() ? null : (T)((Node)this.list.remove(0)).get();
    }

    @Override
    public T peek() {
        this.expungeStaleEntries();
        return this.list.isEmpty() ? null : (T)((Node)this.list.get(0)).get();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<T> x;
        while ((x = this.q.poll()) != null) {
            ReferenceQueue<T> referenceQueue = this.q;
            synchronized (referenceQueue) {
                Node e = (Node)x;
                this.list.remove((Object)e);
            }
        }
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        this.expungeStaleEntries();
        return new NodeIterator();
    }

    private class NodeIterator
    implements Iterator<T> {
        Iterator<Node> iterator;
        Node curNode;
        T next;

        public NodeIterator() {
            this.iterator = new ArrayList<Node>((Collection<Node>)WeakQueue.this.list).iterator();
        }

        @Override
        public void remove() {
            WeakQueue.this.list.remove((Object)this.curNode);
        }

        @Override
        public T next() {
            return this.next;
        }

        @Override
        public boolean hasNext() {
            do {
                if (!this.iterator.hasNext()) {
                    this.next = null;
                    return false;
                }
                this.curNode = this.iterator.next();
                this.next = this.curNode.get();
            } while (this.next == null);
            return true;
        }
    }

    private final class Node
    extends WeakReference<T>
    implements TLinkable<Node> {
        private volatile Node next;
        private volatile Node prev;

        public Node(T referent) {
            super(referent, WeakQueue.this.q);
        }

        public Node getNext() {
            return this.next;
        }

        public void setNext(Node linkable) {
            this.next = linkable;
        }

        public Node getPrevious() {
            return this.prev;
        }

        public void setPrevious(Node linkable) {
            this.prev = linkable;
        }
    }
}

