/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.items.armor;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.client.models.ModelColoredArmor;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.registry.creative_tabs.AetherCreativeTabs;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAetherArmor
extends ItemArmor {
    private String[] defualt_location = new String[]{"textures/models/armor/iron_layer_1.png", "textures/models/armor/iron_layer_2.png"};
    private boolean shouldDefualt = false;
    private int colorization = -1;
    private String armorName;
    private Item source = null;

    public ItemAetherArmor(EntityEquipmentSlot armorType, ItemArmor.ArmorMaterial material, String name, Item repair) {
        super(material, 0, armorType);
        this.source = repair;
        this.armorName = name;
    }

    public ItemAetherArmor(EntityEquipmentSlot armorType, ItemArmor.ArmorMaterial material, String name, Item repair, int hex) {
        this(armorType, material, name, repair);
        this.source = repair;
        this.armorName = name;
        this.colorization = hex;
        this.shouldDefualt = true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == AetherCreativeTabs.armor || tab == CreativeTabs.field_78027_g) {
            items.add((Object)new ItemStack((Item)this));
        }
    }

    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        return this.colorization != -1 ? this.colorization : 0;
    }

    public int getColorization(ItemStack stack) {
        return this.colorization;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String type1;
        boolean leggings = this.func_77658_a().contains("leggings");
        String string = type1 = leggings ? "layer_2" : "layer_1";
        return this.shouldDefualt ? (leggings ? this.defualt_location[1] : this.defualt_location[0]) : Aether.modAddress() + "textures/armor/" + this.armorName + "_" + type1 + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.shouldDefualt) {
            return new ModelColoredArmor(this.func_77658_a().contains("leggings") ? 0.5f : 1.0f, (Item)this, armorSlot);
        }
        return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.source == null ? false : repair.func_77973_b() == this.source;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return !this.armorName.contains("zanite") && !this.armorName.contains("gravitite") ? ItemsAether.aether_loot : super.func_77613_e(stack);
    }
}

