/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.Config;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class VersionCheck {
    public static String currentversion = "2.4.6";
    private static String lastCheckedversion = "";
    private static String latestWebVersion;
    private static final String siteURL = "https://bibliocraftmod.com/";
    private static final String versionURL = "https://bibliocraftmod.com/vcheck/version.txt";
    private static final String messageURL = "https://bibliocraftmod.com/vcheck/message.txt";
    private boolean runEvent = true;
    private EntityPlayer player;

    @SubscribeEvent
    public void onWorldLoad(EntityJoinWorldEvent event) {
        if (this.runEvent && Config.checkforupdate && event.getEntity() instanceof EntityPlayer && event.getWorld().field_72995_K) {
            this.player = (EntityPlayer)event.getEntity();
            this.runEvent = false;
            new Thread(() -> VersionCheck.getNetVersion(this.player)).start();
        }
    }

    private static String httpReadLine(URL url) throws IOException {
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        http.setRequestMethod("GET");
        http.setRequestProperty("Host", url.getHost());
        http.setRequestProperty("Alt-Used", url.getHost());
        http.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.81 Safari/537.36");
        int rCode = http.getResponseCode();
        if (rCode == 200) {
            BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
            String netVersionString = in.readLine();
            in.close();
            return netVersionString;
        }
        BiblioCraft.LOGGER.error("GET request to " + url.getHost() + " failed with code " + rCode);
        return null;
    }

    public static void getNetVersion(EntityPlayer player) {
        try {
            String netVersionString = VersionCheck.httpReadLine(new URL(versionURL));
            if (netVersionString != null) {
                latestWebVersion = netVersionString;
                if (latestWebVersion.length() > 8 || latestWebVersion.length() < 3) {
                    return;
                }
                if (!latestWebVersion.substring(1).startsWith(".")) {
                    return;
                }
                lastCheckedversion = Config.bConfig.get("Stored Variables", "lastVersionChecked", currentversion).getString();
                if (!latestWebVersion.contains(lastCheckedversion) && !latestWebVersion.contains(currentversion)) {
                    Config.bConfig.load();
                    Config.bConfig.get("Stored Variables", "lastVersionChecked", currentversion).set(netVersionString);
                    VersionCheck.setUpdateMessage(player);
                    Config.bConfig.save();
                }
            } else {
                BiblioCraft.LOGGER.error("Version check responded with no version");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setUpdateMessage(EntityPlayer player) {
        try {
            String data = VersionCheck.httpReadLine(new URL(messageURL));
            player.func_145747_a((ITextComponent)new TextComponentString(data));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

