/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import jds.bibliocraft.Config;
import jds.bibliocraft.items.ItemBigBook;
import jds.bibliocraft.items.ItemRecipeBook;
import jds.bibliocraft.items.ItemStockroomCatalog;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class FileUtil {
    private final String savePath = "books_bibliocraft";

    public boolean isBookSaved(ItemStack stack, World world) {
        if (stack.func_77942_o()) {
            NBTTagCompound pageTags = stack.func_77978_p();
            if (stack.func_77973_b() instanceof ItemBigBook) {
                String filename = "";
                String title = stack.func_82833_r();
                title = TextFormatting.func_110646_a((String)title);
                String author = pageTags.func_74779_i("author");
                author = TextFormatting.func_110646_a((String)author);
                filename = author + ", " + title;
                File book = new File(this.getSaveDir(world), filename);
                if (book.exists()) {
                    return true;
                }
            } else if (stack.func_77973_b() instanceof ItemRecipeBook || stack.func_77973_b() instanceof ItemStockroomCatalog) {
                String title = stack.func_82833_r();
                title = TextFormatting.func_110646_a((String)title);
                title = title.replace(":", ";");
                File book = new File(this.getSaveDir(world), title);
                if (book.exists()) {
                    return true;
                }
            } else {
                NBTTagString titleTag = (NBTTagString)pageTags.func_74781_a("title");
                NBTTagString authorTag = (NBTTagString)pageTags.func_74781_a("author");
                if (titleTag != null && authorTag != null) {
                    String title = titleTag.toString();
                    String author = authorTag.toString();
                    title = title.replace("\"", "");
                    author = author.replace("\"", "");
                    NBTTagList page = pageTags.func_150295_c("pages", 8);
                    File book = new File(this.getSaveDir(world), author + ", " + title + "");
                    if (book.exists()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void saveBook(ItemStack stack, World world) {
        if (stack.func_77942_o()) {
            NBTTagCompound pageTags = stack.func_77978_p();
            NBTTagString titleTag = (NBTTagString)pageTags.func_74781_a("title");
            NBTTagString authorTag = (NBTTagString)pageTags.func_74781_a("author");
            if (titleTag != null && authorTag != null) {
                String title = titleTag.toString();
                String author = authorTag.toString();
                title = title.replace("\"", "");
                author = author.replace("\"", "");
                title = TextFormatting.func_110646_a((String)title);
                author = TextFormatting.func_110646_a((String)author);
                NBTTagList page = pageTags.func_150295_c("pages", 8);
                File book = new File(this.getSaveDir(world), author + ", " + title + "");
                if (!book.exists()) {
                    try {
                        FileWriter writer = new FileWriter(book);
                        writer.write(title);
                        writer.write("\n");
                        writer.write(author);
                        writer.write("\n");
                        if (Config.enablePublicTypesettingBooks) {
                            writer.write("public");
                        } else {
                            writer.write("private");
                        }
                        writer.write("\n");
                        for (int i = 0; i < page.func_74745_c(); ++i) {
                            writer.write("#pgx" + i);
                            writer.write("\n");
                            writer.write(page.func_150307_f(i));
                            writer.write("\n");
                        }
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public int getBookNumber(World world, String author, String title) {
        String[] booksArray = this.scanBookDir(world);
        int bookint = -1;
        if (booksArray != null) {
            for (int x = 0; x < booksArray.length; ++x) {
                if (!booksArray[x].contains(author) || !booksArray[x].contains(title)) continue;
                bookint = x;
            }
        }
        return bookint;
    }

    public int getBookNumber(World world, String authortitle) {
        String[] booksArray = this.scanBookDir(world);
        int bookint = -1;
        if (booksArray != null) {
            for (int x = 0; x < booksArray.length; ++x) {
                if (!booksArray[x].contains(authortitle)) continue;
                bookint = x;
            }
        }
        return bookint;
    }

    public int getBookNumber(boolean isclient, String authortitle) {
        String[] booksArray = this.scanBookDir(isclient);
        int bookint = -1;
        if (booksArray != null) {
            for (int x = 0; x < booksArray.length; ++x) {
                if (!booksArray[x].contains(authortitle)) continue;
                bookint = x;
            }
        }
        return bookint;
    }

    public ItemStack loadBook(World world, ItemStack stack, int bookint) {
        if (stack.func_77973_b() != Items.field_151122_aG) {
            System.out.println("Cannot print to these type of book");
            return ItemStack.field_190927_a;
        }
        String[] booksArray = this.scanBookDir(world);
        if (booksArray != null) {
            if (booksArray.length < bookint) {
                return ItemStack.field_190927_a;
            }
            stack = new ItemStack(Items.field_151164_bB);
            File book = new File(this.getSaveDir(world), booksArray[bookint]);
            NBTTagCompound bookinfo = new NBTTagCompound();
            try {
                FileReader reader = new FileReader(book);
                BufferedReader breader = new BufferedReader(reader);
                String line = breader.readLine();
                if (line != null) {
                    bookinfo.func_74782_a("title", (NBTBase)new NBTTagString(line));
                    line = breader.readLine();
                    bookinfo.func_74782_a("author", (NBTBase)new NBTTagString(line));
                    line = breader.readLine();
                }
                line = breader.readLine();
                NBTTagList bookTagList = new NBTTagList();
                while (line != null) {
                    if (!line.contains("#pgx") && line != null) {
                        String pagetag = line;
                        line = breader.readLine();
                        if (line != null) {
                            if (line.isEmpty()) {
                                line = " ";
                            }
                            while (!line.contains("#pgx") && line != null) {
                                pagetag = pagetag + "\n" + line;
                                line = breader.readLine();
                                if (line == null) break;
                                if (!line.isEmpty()) continue;
                                line = " ";
                            }
                        }
                        NBTTagString nbtpage = new NBTTagString(pagetag);
                        bookTagList.func_74742_a((NBTBase)nbtpage);
                        bookinfo.func_74782_a("pages", (NBTBase)bookTagList);
                        byte resolveByte = 1;
                        NBTTagByte resolve = new NBTTagByte(resolveByte);
                        bookinfo.func_74782_a("resolved", (NBTBase)resolve);
                        continue;
                    }
                    line = breader.readLine();
                }
                breader.close();
                stack.func_77982_d(bookinfo);
                return stack;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public String[] scanBookDir(World world) {
        File bookLoc = this.getSaveDir(world);
        File[] bookList = bookLoc.listFiles();
        if (bookList != null) {
            String[] bookArray = new String[bookList.length];
            for (int x = 0; x < bookList.length; ++x) {
                String bookName = bookList[x].getName();
                bookArray[x] = bookList[x].getName();
            }
            ArrayList<String> bookSortList = new ArrayList<String>();
            for (int n = 0; n < bookArray.length; ++n) {
                if (bookArray[n].contains(".dat")) continue;
                bookSortList.add(bookArray[n]);
            }
            String[] newBookArray = new String[bookSortList.size()];
            for (int n = 0; n < newBookArray.length; ++n) {
                newBookArray[n] = (String)bookSortList.get(n);
            }
            bookArray = newBookArray;
            return bookArray;
        }
        return null;
    }

    public File getSaveDir(World world) {
        File storage;
        if (FMLCommonHandler.instance().getMinecraftServerInstance().toString().contains("integrated")) {
            storage = new File(Minecraft.func_71410_x().field_71412_D, "config");
        } else {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            storage = new File(server.func_71270_I());
        }
        File biblioDir = new File(storage, "books_bibliocraft");
        if (biblioDir.mkdir()) {
            // empty if block
        }
        return biblioDir;
    }

    public String[] scanBookDir(boolean isclient) {
        File bookLoc = this.getSaveDir(isclient);
        File[] bookList = bookLoc.listFiles();
        if (bookList != null) {
            int n;
            String[] bookArray = new String[bookList.length];
            for (int x = 0; x < bookList.length; ++x) {
                String bookName = bookList[x].getName();
                bookArray[x] = bookList[x].getName();
            }
            ArrayList<String> bookSortList = new ArrayList<String>();
            for (n = 0; n < bookArray.length; ++n) {
                bookSortList.add(bookArray[n]);
            }
            for (n = 0; n < bookSortList.size(); ++n) {
                String bname = (String)bookSortList.get(n);
                if (!bname.contains(".dat")) continue;
                bookSortList.remove(n);
            }
            String[] newBookArray = new String[bookSortList.size()];
            for (int n2 = 0; n2 < newBookArray.length; ++n2) {
                newBookArray[n2] = (String)bookSortList.get(n2);
            }
            bookArray = newBookArray;
            return bookArray;
        }
        return null;
    }

    public String getBookName(World world, int booknum) {
        String[] booklist = this.scanBookDir(world);
        if (booklist.length > booknum) {
            return booklist[booknum];
        }
        return null;
    }

    public String[] getAuthorList(String[] books, boolean isClient) {
        File bookLoc = this.getSaveDir(isClient);
        String[] authorList = new String[books.length];
        for (int i = 0; i < books.length; ++i) {
            try {
                File book = new File(bookLoc, books[i]);
                FileReader reader = new FileReader(book);
                BufferedReader breader = new BufferedReader(reader);
                String line = breader.readLine();
                line = breader.readLine();
                if (line != null) {
                    authorList[i] = line;
                }
                breader.close();
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return authorList;
    }

    public boolean[] getPublistList(String[] books, boolean isClient) {
        File bookLoc = this.getSaveDir(isClient);
        boolean[] isPublicList = new boolean[books.length];
        for (int i = 0; i < books.length; ++i) {
            try {
                File book = new File(bookLoc, books[i]);
                FileReader reader = new FileReader(book);
                BufferedReader breader = new BufferedReader(reader);
                String line = breader.readLine();
                if (line != null) {
                    line = breader.readLine();
                }
                if (line != null) {
                    line = breader.readLine();
                }
                if (line != null) {
                    if (line.contains("private")) {
                        isPublicList[i] = false;
                    } else if (line.contains("public")) {
                        isPublicList[i] = true;
                    } else {
                        this.addPublicPrivateFieldToBook(bookLoc, books[i]);
                        isPublicList[i] = true;
                    }
                }
                breader.close();
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return isPublicList;
    }

    public void addPublicPrivateFieldToBook(File dir, String bookFile) {
        ArrayList<String> bookText = new ArrayList<String>();
        try {
            File book = new File(dir, bookFile);
            FileReader reader = new FileReader(book);
            BufferedReader breader = new BufferedReader(reader);
            String line = breader.readLine();
            if (line != null) {
                bookText.add(line);
            }
            if ((line = breader.readLine()) != null) {
                bookText.add(line);
            }
            if ((line = breader.readLine()) != null) {
                if (line.contains("private") || line.contains("public")) {
                    bookText.add(line);
                } else {
                    bookText.add("public");
                }
            }
            line = breader.readLine();
            while (line != null) {
                bookText.add(line);
                line = breader.readLine();
            }
            breader.close();
            FileWriter writer = new FileWriter(book);
            for (int i = 0; i < bookText.size(); ++i) {
                writer.write((String)bookText.get(i));
                writer.write("\n");
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getSaveDir(boolean isclient) {
        File storage;
        if (isclient) {
            storage = new File(Minecraft.func_71410_x().field_71412_D, "config");
        } else {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            storage = new File(server.func_71270_I());
        }
        File biblioDir = new File(storage, "books_bibliocraft");
        if (biblioDir.mkdir()) {
            // empty if block
        }
        return biblioDir;
    }

    public boolean deleteBook(boolean isClient, String bookname) {
        File bookDat;
        int bookCheck;
        bookname = TextFormatting.func_110646_a((String)bookname);
        File saveDir = this.getSaveDir(isClient);
        File book = new File(saveDir, bookname);
        return book.getParentFile().getAbsolutePath().equals(saveDir.getAbsolutePath()) && ((bookCheck = this.getBookType(isClient, this.getBookNumber(isClient, bookname))) == -1 ? book.delete() : (bookDat = new File(this.getSaveDir(isClient), bookname + ".dat")).getParentFile().getAbsolutePath().equals(saveDir.getAbsolutePath()) && book.delete() && bookDat.delete());
    }

    public boolean updatePublicFlag(boolean isClient, String bookname, boolean flag) {
        ArrayList<String> bookText = new ArrayList<String>();
        try {
            File saveDir = this.getSaveDir(isClient);
            File book = new File(saveDir, bookname);
            if (book.getParentFile().getAbsolutePath().equals(saveDir.getAbsolutePath())) {
                FileReader reader = new FileReader(book);
                BufferedReader breader = new BufferedReader(reader);
                String line = breader.readLine();
                if (line != null) {
                    bookText.add(line);
                }
                if ((line = breader.readLine()) != null) {
                    bookText.add(line);
                }
                if ((line = breader.readLine()) != null) {
                    if (flag) {
                        bookText.add("public");
                    } else {
                        bookText.add("private");
                    }
                }
                line = breader.readLine();
                while (line != null) {
                    bookText.add(line);
                    line = breader.readLine();
                }
                breader.close();
                FileWriter writer = new FileWriter(book);
                for (int i = 0; i < bookText.size(); ++i) {
                    writer.write((String)bookText.get(i));
                    writer.write("\n");
                }
                writer.close();
                return true;
            }
            return false;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean saveNBTtoFile(ItemStack book, World world, int type) {
        NBTTagCompound nbt;
        if (book != ItemStack.field_190927_a && (nbt = book.func_77978_p()) != null) {
            String filename = "";
            String title = book.func_82833_r();
            title = TextFormatting.func_110646_a((String)title);
            boolean savedMeta = false;
            if (type == 0) {
                String author = nbt.func_74779_i("author");
                author = TextFormatting.func_110646_a((String)author);
                filename = author + ", " + title;
                savedMeta = this.saveBookMeta(world, filename, title, author, "Big");
            } else if (type == 1) {
                filename = title = title.replace(":", ";");
                savedMeta = this.saveBookMeta(world, filename, title, "NoAuthor", "Recipe");
            } else if (type == 2) {
                filename = title = title.replace(":", ";");
                savedMeta = this.saveBookMeta(world, filename, title, "NoAuthor", "Stockroom");
            } else {
                return false;
            }
            if (savedMeta) {
                File bookFile;
                String metaname = filename + ".dat";
                metaname = metaname.replace("..", ".");
                File saveDir = this.getSaveDir(world);
                if (this.isWithin(saveDir, bookFile = new File(saveDir, metaname))) {
                    try {
                        CompressedStreamTools.func_74795_b((NBTTagCompound)nbt, (File)bookFile);
                        return true;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    private boolean isWithin(File dir, File file) {
        return file.getParentFile().getAbsolutePath().equals(dir.getAbsolutePath());
    }

    public boolean saveBookMeta(World world, String filename, String title, String author, String type) {
        File saveDir = this.getSaveDir(world);
        File bookFile = new File(saveDir, filename);
        if (!bookFile.exists() && this.isWithin(saveDir, bookFile)) {
            try {
                FileWriter writer = new FileWriter(bookFile);
                writer.write(title);
                writer.write("\n");
                writer.write(author);
                writer.write("\n");
                if (Config.enablePublicTypesettingBooks) {
                    writer.write("public");
                } else {
                    writer.write("private");
                }
                writer.write("\n");
                writer.write("Booktype&=" + type);
                writer.write("\n");
                writer.write(filename);
                writer.close();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public int getBookType(World world, int bookNum) {
        String[] booksArray = this.scanBookDir(world);
        try {
            File saveDir = this.getSaveDir(world);
            File book = new File(saveDir, booksArray[bookNum]);
            if (!this.isWithin(saveDir, book)) {
                return -1;
            }
            FileReader reader = new FileReader(book);
            BufferedReader breader = new BufferedReader(reader);
            String line = breader.readLine();
            line = breader.readLine();
            line = breader.readLine();
            line = breader.readLine();
            if (line != null && line.contains("Booktype=")) {
                line = line.replace("Booktype=", "");
            }
            breader.close();
            if (line.contains("Big")) {
                return 0;
            }
            if (line.contains("Recipe")) {
                return 1;
            }
            if (line.contains("Stockroom")) {
                return 2;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public int getBookType(boolean isClient, int bookNum) {
        String[] booksArray = this.scanBookDir(isClient);
        try {
            File saveDir = this.getSaveDir(isClient);
            File book = new File(saveDir, booksArray[bookNum]);
            if (!this.isWithin(saveDir, book)) {
                return -1;
            }
            FileReader reader = new FileReader(book);
            BufferedReader breader = new BufferedReader(reader);
            String line = breader.readLine();
            line = breader.readLine();
            line = breader.readLine();
            line = breader.readLine();
            if (line != null && line.contains("Booktype=")) {
                line = line.replace("Booktype=", "");
            }
            breader.close();
            if (line.contains("Big")) {
                return 0;
            }
            if (line.contains("Recipe")) {
                return 1;
            }
            if (line.contains("Stockroom")) {
                return 2;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public ItemStack loadBookNBT(World world, ItemStack bookstack, int booknum) {
        File book;
        String[] booklist = this.scanBookDir(world);
        File saveDir = this.getSaveDir(world);
        if (this.isWithin(saveDir, book = new File(saveDir, booklist[booknum] + ".dat"))) {
            NBTTagCompound nbt = null;
            if (book.exists()) {
                try {
                    nbt = CompressedStreamTools.func_74797_a((File)book);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (nbt != null) {
                    bookstack.func_77982_d(nbt);
                }
            }
        }
        return bookstack;
    }
}

