/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network.packet;

import java.util.ArrayList;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.gui.GuiAtlasMap;
import jds.bibliocraft.gui.GuiAtlasWaypointTransfer;
import jds.bibliocraft.gui.GuiBigBook;
import jds.bibliocraft.gui.GuiClipboard;
import jds.bibliocraft.gui.GuiRecipeBook;
import jds.bibliocraft.gui.GuiScreenBookDesk;
import jds.bibliocraft.gui.GuiStockCatalog;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.helpers.SortedListItem;
import jds.bibliocraft.items.ItemRecipeBook;
import jds.bibliocraft.network.BiblioNetworking;
import jds.bibliocraft.network.packet.client.BiblioRecipeText;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Utils {
    @SideOnly(value=Side.CLIENT)
    public static void openWritingGUI(EntityPlayer player, ItemStack book, int x, int y, int z, boolean signed) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenBookDesk(player, book, signed, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public static void openClipboardGUI(ItemStack stack, boolean inInv, int x, int y, int z) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiClipboard(stack, inInv, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public static void openRecipeBookGUI(ItemStack stack, int x, int y, int z, int slot, boolean canCraft) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiRecipeBook(stack, true, x, y, z, slot, canCraft));
    }

    @SideOnly(value=Side.CLIENT)
    public static void openWaypointTransferGUI(World world, EntityPlayer player, ItemStack stack, TileEntityMapFrame tile) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAtlasWaypointTransfer(world, player, stack, tile));
    }

    @SideOnly(value=Side.CLIENT)
    public static void openMapGUI(EntityPlayer player, ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAtlasMap((World)Minecraft.func_71410_x().field_71441_e, player, stack));
    }

    @SideOnly(value=Side.CLIENT)
    public static void openBigBookGUI(ItemStack stack, int x, int y, int z, String author) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiBigBook(stack, false, x, y, z, author));
    }

    public static boolean checkForValidRecipeIngredients(NonNullList<ItemStack> ingredients, EntityPlayerMP player, boolean remove) {
        int i;
        NonNullList inventory;
        if (player.field_71075_bZ.field_75098_d) {
            remove = false;
        }
        boolean[] passed = new boolean[]{false, false, false, false, false, false, false, false, false};
        NonNullList playerInventory = inventory = player.field_71071_by.field_70462_a;
        NonNullList playerIngredients = NonNullList.func_191197_a((int)ingredients.size(), (Object)ItemStack.field_190927_a);
        for (int i2 = 0; i2 < ingredients.size(); ++i2) {
            playerIngredients.set(i2, ingredients.get(i2));
        }
        NonNullList countedIngredients = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        for (i = 0; i < playerIngredients.size(); ++i) {
            ItemStack thing = (ItemStack)playerIngredients.get(i);
            if (thing == ItemStack.field_190927_a) continue;
            int count = 0;
            for (int n = 0; n < playerIngredients.size(); ++n) {
                ItemStack subThing = (ItemStack)playerIngredients.get(n);
                if (!subThing.func_77977_a().equals(thing.func_77977_a())) continue;
                ++count;
                playerIngredients.set(n, (Object)ItemStack.field_190927_a);
            }
            thing.func_190920_e(count);
            countedIngredients.set(i, (Object)thing);
        }
        block3: for (i = 0; i < countedIngredients.size(); ++i) {
            ItemStack ingredientItem = (ItemStack)countedIngredients.get(i);
            if (ingredientItem != ItemStack.field_190927_a && !ingredientItem.func_77977_a().contentEquals(ItemStack.field_190927_a.func_77977_a())) {
                for (int n = 0; n < playerInventory.size(); ++n) {
                    ItemStack inventoryItem = (ItemStack)playerInventory.get(n);
                    if (inventoryItem == ItemStack.field_190927_a || !inventoryItem.func_77977_a().equals(ingredientItem.func_77977_a())) continue;
                    if (inventoryItem.func_190916_E() >= ingredientItem.func_190916_E()) {
                        if (remove) {
                            inventoryItem.func_190920_e(inventoryItem.func_190916_E() - ingredientItem.func_190916_E());
                            if (inventoryItem.func_190916_E() <= 0) {
                                inventory.set(n, (Object)ItemStack.field_190927_a);
                            } else {
                                inventory.set(n, (Object)inventoryItem);
                            }
                        }
                        passed[i] = true;
                        continue block3;
                    }
                    inventoryItem.func_190920_e(ingredientItem.func_190916_E() - inventoryItem.func_190916_E());
                    countedIngredients.set(i, (Object)ingredientItem);
                    if (!remove) continue;
                    inventory.set(n, (Object)ItemStack.field_190927_a);
                }
                continue;
            }
            passed[i] = true;
        }
        boolean hasIngredients = true;
        for (int m = 0; m < passed.length; ++m) {
            if (passed[m]) continue;
            hasIngredients = false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            hasIngredients = true;
        }
        return hasIngredients;
    }

    public static boolean checkIfValidPacketItem(String input) {
        String[] validPacketItems = new String[]{"item.AtlasBook", "item.BigBook", "item.RecipeBook", "item.BiblioClipboard", "item.BiblioRedBook", "item.SlottedBook", "item.compass"};
        for (int i = 0; i < validPacketItems.length; ++i) {
            if (!validPacketItems[i].equals(input)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPointLoaded(EntityPlayerMP player, BlockPos pos) {
        if (pos == null) {
            BiblioCraft.LOGGER.error("Null position passed to load check by " + player.getDisplayNameString());
        }
        WorldServer sworld = player.func_71121_q();
        PlayerChunkMap chunkMap = sworld.func_184164_w();
        return chunkMap.func_72694_a(player, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openCatalogGUI(EntityPlayer player, ArrayList<SortedListItem> AlphaList, ArrayList<SortedListItem> QuantaList, ItemStack[] stacks, int[] compasses, String title) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiStockCatalog(player, AlphaList, QuantaList, stacks, compasses, title));
    }

    public static void sendARecipeBookTextPacket(EntityPlayerMP player, String text, int slot) {
        ItemStack currentBook = player.field_71071_by.func_70301_a(slot);
        if (currentBook != ItemStack.field_190927_a && currentBook.func_77973_b() instanceof ItemRecipeBook) {
            BiblioNetworking.INSTANCE.sendTo((IMessage)new BiblioRecipeText(text, slot), player);
        }
    }

    public static ItemStack getCurrentMapStack(ItemStack stack) {
        ItemStack mapStack;
        int mapSlot;
        InventoryBasic inv = Utils.getInventory(stack);
        NBTTagCompound atlasTags = stack.func_77978_p();
        if (atlasTags != null && (mapSlot = atlasTags.func_74762_e("mapSlot")) != -1 && (mapStack = inv.func_70301_a(mapSlot)) != ItemStack.field_190927_a && mapStack.func_77973_b() == Items.field_151098_aY) {
            return mapStack;
        }
        return null;
    }

    public static InventoryBasic getInventory(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", true, 48);
            NBTTagList tagList = tags.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
                ItemStack invStack = new ItemStack(tag);
                atlasInventory.func_70299_a((int)slot, invStack);
            }
            return atlasInventory;
        }
        return null;
    }

    public static NBTTagCompound getNewMapDataCompound(TileEntityMapFrame tile, String newMapName) {
        int mapRotation = tile.getRotation();
        NBTTagCompound newMapData = new NBTTagCompound();
        newMapData.func_74778_a("mapName", newMapName);
        newMapData.func_74768_a("xCenter", tile.mapXCenter);
        newMapData.func_74768_a("zCenter", tile.mapZCenter);
        newMapData.func_74768_a("mapScale", tile.mapScale);
        EnumFacing angle = tile.getAngle();
        EnumVertPosition vertAngle = tile.getVertPosition();
        int rotations = 0;
        switch (mapRotation) {
            case 1: {
                rotations = 3;
                break;
            }
            case 2: {
                rotations = 2;
                break;
            }
            case 3: {
                rotations = 1;
            }
        }
        ArrayList xPins = new ArrayList();
        xPins = (ArrayList)tile.xPin.clone();
        ArrayList yPins = new ArrayList();
        yPins = (ArrayList)tile.yPin.clone();
        for (int i = 0; i < rotations; ++i) {
            int n;
            ArrayList xCurrent = xPins;
            ArrayList yCurrent = yPins;
            if ((angle == EnumFacing.SOUTH || angle == EnumFacing.EAST) && vertAngle == EnumVertPosition.WALL || vertAngle == EnumVertPosition.CEILING) {
                xPins = yCurrent;
                yCurrent = yPins = xCurrent;
                for (n = 0; n < xCurrent.size(); ++n) {
                    yPins.set(n, Float.valueOf(1.0f - ((Float)yCurrent.get(n)).floatValue()));
                }
                continue;
            }
            xPins = yCurrent;
            yPins = xCurrent;
            xCurrent = xPins;
            for (n = 0; n < xCurrent.size(); ++n) {
                xPins.set(n, Float.valueOf(1.0f - ((Float)xCurrent.get(n)).floatValue()));
            }
        }
        NBTTagList mapXPins = new NBTTagList();
        for (int i = 0; i < xPins.size(); ++i) {
            float xpin = ((Float)xPins.get(i)).floatValue();
            if (tile.getVertPosition() == EnumVertPosition.WALL && (tile.getAngle() == EnumFacing.WEST || tile.getAngle() == EnumFacing.NORTH)) {
                xpin = 1.0f - xpin;
            }
            mapXPins.func_74742_a((NBTBase)new NBTTagFloat(xpin));
        }
        newMapData.func_74782_a("xMapWaypoints", (NBTBase)mapXPins);
        NBTTagList mapYPins = new NBTTagList();
        for (int i = 0; i < yPins.size(); ++i) {
            float ypin = ((Float)yPins.get(i)).floatValue();
            if (tile.getVertPosition() == EnumVertPosition.CEILING || tile.getVertPosition() == EnumVertPosition.WALL) {
                ypin = 1.0f - ypin;
            }
            mapYPins.func_74742_a((NBTBase)new NBTTagFloat(ypin));
        }
        newMapData.func_74782_a("yMapWaypoints", (NBTBase)mapYPins);
        NBTTagList mapPinNames = new NBTTagList();
        for (int i = 0; i < tile.pinStrings.size(); ++i) {
            mapPinNames.func_74742_a((NBTBase)new NBTTagString((String)tile.pinStrings.get(i)));
        }
        newMapData.func_74782_a("MapWaypointNames", (NBTBase)mapPinNames);
        NBTTagList mapPinColors = new NBTTagList();
        for (int i = 0; i < tile.pinColors.size(); ++i) {
            mapPinColors.func_74742_a((NBTBase)new NBTTagFloat(((Float)tile.pinColors.get(i)).floatValue()));
        }
        newMapData.func_74782_a("MapWaypointColors", (NBTBase)mapPinColors);
        return newMapData;
    }
}

